import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-tooltip.service";
import * as i2 from "../../services/model.service";
export class StiTooltipComponent {
    constructor(tooltipService, model) {
        this.tooltipService = tooltipService;
        this.model = model;
        this.initialized = false;
    }
    ngAfterViewInit() {
        setTimeout(() => {
            this.initialized = true;
        });
    }
    getTooltipArrow() {
        switch (this.tooltipService.position) {
            case "top":
                return "bottom-arrow";
            case "bottom":
                return "top-arrow";
            case "left":
                return "right-arrow";
            case "right":
                return "left-arrow";
        }
    }
    getLeft(tooltipElement) {
        let elementRect = this.model.getPositionRelativeToForm(tooltipElement);
        if (this.tooltipService.elementRect && this.initialized) {
            switch (this.tooltipService.position) {
                case "left":
                    return this.correctLeftLimits(this.tooltipService.elementRect.left - (elementRect.width + 8), elementRect);
                case "right":
                    return this.correctLeftLimits(this.tooltipService.elementRect.right + 8, elementRect);
                case "top":
                case "bottom":
                    return this.correctLeftLimits(this.tooltipService.elementRect.left + (this.tooltipService.elementRect.width / 2 - elementRect.width / 2), elementRect);
            }
        }
        else {
            return -999;
        }
    }
    getTop(tooltipElement) {
        let elementRect = this.model.getPositionRelativeToForm(tooltipElement);
        if (this.tooltipService.elementRect && this.initialized) {
            switch (this.tooltipService.position) {
                case "top":
                    return this.correctTopLimits(this.tooltipService.elementRect.top - (elementRect.height + 8), elementRect);
                case "bottom":
                    return this.correctTopLimits(this.tooltipService.elementRect.bottom + 8, elementRect);
                case "left":
                case "right":
                    return this.correctTopLimits(this.tooltipService.elementRect.top + (this.tooltipService.elementRect.height / 2 - elementRect.height / 2), elementRect);
            }
        }
        else {
            return -999;
        }
    }
    correctLeftLimits(value, tooltipRect) {
        if (value < 0) {
            return 0;
        }
        else if (value + tooltipRect.width > window.innerWidth) {
            return Math.round(window.innerWidth - tooltipRect.width).toFixed(2);
        }
        else {
            return Math.round(value).toFixed(2);
        }
    }
    correctTopLimits(value, tooltipRect) {
        if (value < 0) {
            return 0;
        }
        else if (value + tooltipRect.height > window.innerHeight) {
            return Math.round(window.innerHeight - tooltipRect.height).toFixed(2);
        }
        else {
            return Math.round(value).toFixed(2);
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTooltipComponent, deps: [{ token: i1.StiTooltipService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTooltipComponent, selector: "sti-tooltip", ngImport: i0, template: ` <div
    #tooltip
    class="sti-tooltip {{ getTooltipArrow() }}"
    [style.left.px]="getLeft(tooltip)"
    [style.top.px]="getTop(tooltip)"
  >
    <span>{{ tooltipService.text }}</span>
  </div>`, isInline: true, styles: [".sti-tooltip{position:absolute;background:var(--back-color);color:var(--text-color);padding:.429rem;box-shadow:0 3px 6px #00000029;border-radius:3px;z-index:99999999;white-space:pre-line}.sti-tooltip span{font-size:16px;font-family:Arial}.bottom-arrow:before,.bottom-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);bottom:-16px;border:8px solid transparent;border-top:8px solid white}.bottom-arrow:after{border-top:8px solid white;bottom:-16px}.top-arrow:before,.top-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);top:-16px;border:8px solid transparent;border-bottom:8px solid white}.top-arrow:after{border-bottom:8px solid white;top:-16px}.left-arrow:before,.left-arrow:after{content:\"\";position:absolute;left:-16px;top:calc(50% - 8px);border:8px solid transparent;border-right:8px solid white}.left-arrow:after{border-right:8px solid white;left:-16px}.right-arrow:before,.right-arrow:after{content:\"\";position:absolute;right:-16px;top:calc(50% - 8px);border:8px solid transparent;border-left:8px solid white}.right-arrow:after{border-left:8px solid white;right:-16px}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTooltipComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-tooltip", template: ` <div
    #tooltip
    class="sti-tooltip {{ getTooltipArrow() }}"
    [style.left.px]="getLeft(tooltip)"
    [style.top.px]="getTop(tooltip)"
  >
    <span>{{ tooltipService.text }}</span>
  </div>`, styles: [".sti-tooltip{position:absolute;background:var(--back-color);color:var(--text-color);padding:.429rem;box-shadow:0 3px 6px #00000029;border-radius:3px;z-index:99999999;white-space:pre-line}.sti-tooltip span{font-size:16px;font-family:Arial}.bottom-arrow:before,.bottom-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);bottom:-16px;border:8px solid transparent;border-top:8px solid white}.bottom-arrow:after{border-top:8px solid white;bottom:-16px}.top-arrow:before,.top-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);top:-16px;border:8px solid transparent;border-bottom:8px solid white}.top-arrow:after{border-bottom:8px solid white;top:-16px}.left-arrow:before,.left-arrow:after{content:\"\";position:absolute;left:-16px;top:calc(50% - 8px);border:8px solid transparent;border-right:8px solid white}.left-arrow:after{border-right:8px solid white;left:-16px}.right-arrow:before,.right-arrow:after{content:\"\";position:absolute;right:-16px;top:calc(50% - 8px);border:8px solid transparent;border-left:8px solid white}.right-arrow:after{border-left:8px solid white;right:-16px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiTooltipService }, { type: i2.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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