import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-expression.service";
export class StiTableLabelComponent {
    get cell() {
        let value = this.expressionService.isSystemVariables(this.item.expression)
            ? this.item.cells[this.index]
            : this.model.getFormattedValue(this.item, this.item.cells[this.index]);
        return `${this.item.prefix}${value != null && value != undefined ? value : ""}${this.item.suffix}`;
    }
    /* public set cell(value) {
      this.item.cells[this.index] = value;
    } */
    constructor(model, expressionService) {
        this.model = model;
        this.expressionService = expressionService;
        this.isClone = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableLabelComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExpressionService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableLabelComponent, selector: "sti-table-label-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone" }, ngImport: i0, template: `<div
    class="cell"
    [style.text-align]="'inherit'"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <span
      [style]="object.font.htmlStyle()"
      [style.text-decoration]="'none'"
      [style.width]="'100%'"
      [style.border-color]="item.cellBorderColor.toHtmlColor()"
      [style.color]="item.cellForeColor.toHtmlColor()"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style.whiteSpace]="'nowrap'"
      >{{ cell }}</span
    >
  </div>`, isInline: true, styles: [".cell{display:flex;width:100%}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableLabelComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-label-component", template: `<div
    class="cell"
    [style.text-align]="'inherit'"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <span
      [style]="object.font.htmlStyle()"
      [style.text-decoration]="'none'"
      [style.width]="'100%'"
      [style.border-color]="item.cellBorderColor.toHtmlColor()"
      [style.color]="item.cellForeColor.toHtmlColor()"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style.whiteSpace]="'nowrap'"
      >{{ cell }}</span
    >
  </div>`, styles: [".cell{display:flex;width:100%}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiExpressionService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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