import { Component, Input } from "@angular/core";
import { Enum } from "../../../system/Enum";
import { StiHorizontalAlignment } from "../../../system/enums";
import { StiRadioButtonColumnItem } from "../../../elements/table/columns/StiRadioButtonColumnItem";
import { StiTableElement } from "../../../elements/StiTableElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "../../sti-number.component";
import * as i4 from "../sti-table-text-input/sti-table-text-input.component";
import * as i5 from "../sti-table-radiobutton/sti-table-radiobutton.component";
import * as i6 from "../sti-table-combobox/sti-table-combobox.component";
import * as i7 from "../sti-table-checkbox/sti-table-checkbox.component";
import * as i8 from "../sti-table-label/sti-table-label.component";
export class StiTableColumnComponent {
    getColumnAlignment(column) {
        return Enum.getName(StiHorizontalAlignment, column.cellAlignment);
    }
    changeState(column, i) {
        if (column instanceof StiRadioButtonColumnItem) {
            if (this.element instanceof StiTableElement) {
                this.element.columns.forEach((col) => {
                    if (col instanceof StiRadioButtonColumnItem && col != column) {
                        col.cells[i].isChecked = false;
                    }
                });
            }
            if (!column.cells[i].isChecked) {
                column.cells[i].isChecked = true;
            }
        }
        else {
            column.cells[i].isChecked = !column.cells[i].isChecked;
        }
    }
    constructor(model) {
        this.model = model;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableColumnComponent, selector: "sti-table-column-component", inputs: { column: "column", index: "index", element: "element" }, ngImport: i0, template: `
    <sti-table-label-component
      *ngIf="column && column.type == 'LabelColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [style.text-align]="getColumnAlignment(column)"
      [index]="index"
      [object]="element"
      [style.overflow]="'hidden'"
      [style.width]="'100%'"
    ></sti-table-label-component>
    <sti-table-input-text-component
      *ngIf="column && column.type == 'TextBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      [style.overflow]="'hidden'"
      [style.width]="'100%'"
    ></sti-table-input-text-component>
    <sti-table-radio-button-component
      *ngIf="column && column.type == 'RadioButtonColumn'"
      [item]="column"
      [alignment]="getColumnAlignment(column)"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      (buttonClick)="changeState(column, index)"
      [style.width]="'100%'"
    ></sti-table-radio-button-component>
    <sti-number-component
      *ngIf="column && column.type == 'NumberBoxColumn'"
      [element]="column"
      [index]="index"
      [table]="element"
      [style.width]="'100%'"
      [style.overflow]="'hidden'"
    ></sti-number-component>
    <sti-table-combobox-component
      *ngIf="column && column.type == 'ComboBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      [style.width]="'100%'"
      [style.overflow]="'hidden'"
    ></sti-table-combobox-component>
    <sti-table-checkbox-component
      *ngIf="column && column.type == 'CheckBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [object]="element"
      [alignment]="getColumnAlignment(column)"
      [index]="index"
      (buttonClick)="changeState(column, index)"
      [style.width]="'100%'"
    ></sti-table-checkbox-component>
  `, isInline: true, styles: [""], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.StiNumberComponent, selector: "sti-number-component", inputs: ["element", "index", "table"] }, { kind: "component", type: i4.StiTableInputTextComponent, selector: "sti-table-input-text-component", inputs: ["item", "index", "object", "disabled", "isClone"] }, { kind: "component", type: i5.StiTableRadioButtonComponent, selector: "sti-table-radio-button-component", inputs: ["item", "index", "disabled", "isClone", "object", "alignment"], outputs: ["buttonClick"] }, { kind: "component", type: i6.StiTableComboboxComponent, selector: "sti-table-combobox-component", inputs: ["item", "index", "object", "disabled", "isClone"] }, { kind: "component", type: i7.StiTableCheckboxComponent, selector: "sti-table-checkbox-component", inputs: ["item", "index", "object", "disabled", "isClone", "alignment"], outputs: ["buttonClick"] }, { kind: "component", type: i8.StiTableLabelComponent, selector: "sti-table-label-component", inputs: ["item", "index", "object", "disabled", "isClone"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-column-component", template: `
    <sti-table-label-component
      *ngIf="column && column.type == 'LabelColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [style.text-align]="getColumnAlignment(column)"
      [index]="index"
      [object]="element"
      [style.overflow]="'hidden'"
      [style.width]="'100%'"
    ></sti-table-label-component>
    <sti-table-input-text-component
      *ngIf="column && column.type == 'TextBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      [style.overflow]="'hidden'"
      [style.width]="'100%'"
    ></sti-table-input-text-component>
    <sti-table-radio-button-component
      *ngIf="column && column.type == 'RadioButtonColumn'"
      [item]="column"
      [alignment]="getColumnAlignment(column)"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      (buttonClick)="changeState(column, index)"
      [style.width]="'100%'"
    ></sti-table-radio-button-component>
    <sti-number-component
      *ngIf="column && column.type == 'NumberBoxColumn'"
      [element]="column"
      [index]="index"
      [table]="element"
      [style.width]="'100%'"
      [style.overflow]="'hidden'"
    ></sti-number-component>
    <sti-table-combobox-component
      *ngIf="column && column.type == 'ComboBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [index]="index"
      [object]="element"
      [style.width]="'100%'"
      [style.overflow]="'hidden'"
    ></sti-table-combobox-component>
    <sti-table-checkbox-component
      *ngIf="column && column.type == 'CheckBoxColumn'"
      [item]="column"
      [disabled]="element?.readOnly"
      [object]="element"
      [alignment]="getColumnAlignment(column)"
      [index]="index"
      (buttonClick)="changeState(column, index)"
      [style.width]="'100%'"
    ></sti-table-checkbox-component>
  ` }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { column: [{
                type: Input
            }], index: [{
                type: Input
            }], element: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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