import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
export class StiTableCheckboxComponent {
    get cell() {
        return this.item.cells[this.index] ? this.item.cells[this.index] : null;
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
        this.buttonClick = new EventEmitter();
    }
    changeState() {
        this.buttonClick.emit();
    }
    ngOnInit() { }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableCheckboxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableCheckboxComponent, selector: "sti-table-checkbox-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone", alignment: "alignment" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: ` <div
    class="custom-checkbox"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input
      type="checkbox"
      name=""
      tooltipPosition="bottom"
      showDelay="500"
      [tabIndex]="tabIndex"
      (click)="changeState()"
      [disabled]="disabled"
    />
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
      <rect
        class="box"
        x="0.5"
        y="15.5"
        width="16"
        height="16"
        transform="rotate(-90 0.5 15.5)"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <path
        *ngIf="cell?.isChecked"
        class="check"
        d="M5 7.23529L8.15 12L14 3"
        [attr.stroke]="item.cellForeColor.toHtmlColor()"
        fill="transparent"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
      />
    </svg>
  </div>`, isInline: true, styles: ["input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:fit-content;position:relative;display:flex;width:100%}.custom-checkbox input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-checkbox-component", template: ` <div
    class="custom-checkbox"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input
      type="checkbox"
      name=""
      tooltipPosition="bottom"
      showDelay="500"
      [tabIndex]="tabIndex"
      (click)="changeState()"
      [disabled]="disabled"
    />
    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
      <rect
        class="box"
        x="0.5"
        y="15.5"
        width="16"
        height="16"
        transform="rotate(-90 0.5 15.5)"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <path
        *ngIf="cell?.isChecked"
        class="check"
        d="M5 7.23529L8.15 12L14 3"
        [attr.stroke]="item.cellForeColor.toHtmlColor()"
        fill="transparent"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
      />
    </svg>
  </div>`, styles: ["input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:fit-content;position:relative;display:flex;width:100%}.custom-checkbox input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }], alignment: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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