import { Component, ContentChild, EventEmitter, Input, Output, TemplateRef } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
export class StiSelectButtonComponent {
    constructor() {
        this.onOptionClick = new EventEmitter();
        this.onChange = new EventEmitter();
        this.valueChange = new EventEmitter();
    }
    getOptionLabel(option) {
        return option[this.optionLabel];
    }
    isSelected(option) {
        let optionValue = this.getOptionValue(option);
        if (this.multiple) {
            if (this.value && this.value?.indexOf(optionValue) != -1) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return optionValue === this.value;
        }
    }
    getOptionValue(option) {
        return option.value ? option.value : option;
    }
    removeOption(option) {
        let optionValue = this.getOptionValue(option);
        this.value = this.value.filter((item) => item != optionValue);
    }
    selectOption(event, option, index) {
        if (this.disabled) {
            return;
        }
        let optionValue = this.getOptionValue(option);
        if (this.multiple) {
            if (this.isSelected(option))
                this.removeOption(option);
            else
                this.value = [...(this.value || []), optionValue];
            this.onChange.emit({
                originalEvent: event,
                value: this.value,
            });
            this.valueChange.emit(this.value);
        }
        else if (this.value !== optionValue) {
            this.value = optionValue;
            this.onChange.emit({
                originalEvent: event,
                value: this.value,
            });
            this.valueChange.emit(this.value);
        }
        this.onOptionClick.emit({
            originalEvent: event,
            option: option,
            index: index,
        });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSelectButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSelectButtonComponent, selector: "sti-selectButton", inputs: { options: "options", value: "value", optionLabel: "optionLabel", optionValue: "optionValue", multiple: "multiple", disabled: "disabled" }, outputs: { onOptionClick: "onOptionClick", onChange: "onChange", valueChange: "valueChange" }, queries: [{ propertyName: "itemTemplate", first: true, predicate: TemplateRef, descendants: true }], ngImport: i0, template: ` <div class="button-container {{ disabled ? 'disabled' : '' }}">
    <div
      #button
      class="button {{ isSelected(option) ? 'selected' : '' }} {{ i == 0 ? 'left' : '' }} {{
        i == options.length - 1 ? 'right' : ''
      }}"
      [style.border-right-width.px]="i == options.length - 1 ? 1 : 0"
      *ngFor="let option of options; let i = index"
      (click)="selectOption($event, option, i)"
    >
      <ng-container *ngIf="!itemTemplate; else customcontent">
        <span class="label">{{ getOptionLabel(option) }}</span>
      </ng-container>
      <ng-template #customcontent>
        <ng-container *ngTemplateOutlet="itemTemplate; context: { $implicit: option, index: i }"></ng-container>
      </ng-template>
    </div>
  </div>`, isInline: true, styles: [".disabled{pointer-events:none;opacity:.5}.button{background-color:var(--back-color);border:1px solid var(--back-color);color:var(--text-color);padding:3px 6px;width:auto;height:inherit;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:14px;font-weight:400;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--active-color);border-color:var(--active-color);cursor:pointer}.selected{background-color:var(--active-color);border-color:var(--active-color)}.button-container{display:flex;width:100%;height:inherit}.left{border-top-left-radius:3px;border-bottom-left-radius:3px}.right{border-top-right-radius:3px;border-bottom-right-radius:3px}\n"], dependencies: [{ kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSelectButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-selectButton", template: ` <div class="button-container {{ disabled ? 'disabled' : '' }}">
    <div
      #button
      class="button {{ isSelected(option) ? 'selected' : '' }} {{ i == 0 ? 'left' : '' }} {{
        i == options.length - 1 ? 'right' : ''
      }}"
      [style.border-right-width.px]="i == options.length - 1 ? 1 : 0"
      *ngFor="let option of options; let i = index"
      (click)="selectOption($event, option, i)"
    >
      <ng-container *ngIf="!itemTemplate; else customcontent">
        <span class="label">{{ getOptionLabel(option) }}</span>
      </ng-container>
      <ng-template #customcontent>
        <ng-container *ngTemplateOutlet="itemTemplate; context: { $implicit: option, index: i }"></ng-container>
      </ng-template>
    </div>
  </div>`, styles: [".disabled{pointer-events:none;opacity:.5}.button{background-color:var(--back-color);border:1px solid var(--back-color);color:var(--text-color);padding:3px 6px;width:auto;height:inherit;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:14px;font-weight:400;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--active-color);border-color:var(--active-color);cursor:pointer}.selected{background-color:var(--active-color);border-color:var(--active-color)}.button-container{display:flex;width:100%;height:inherit}.left{border-top-left-radius:3px;border-bottom-left-radius:3px}.right{border-top-right-radius:3px;border-bottom-right-radius:3px}\n"] }]
        }], ctorParameters: () => [], propDecorators: { options: [{
                type: Input
            }], value: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], optionValue: [{
                type: Input
            }], multiple: [{
                type: Input
            }], disabled: [{
                type: Input
            }], onOptionClick: [{
                type: Output
            }], onChange: [{
                type: Output
            }], valueChange: [{
                type: Output
            }], itemTemplate: [{
                type: ContentChild,
                args: [TemplateRef]
            }] } });
//# sourceMappingURL=data:application/json;base64,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