import { Component, Input } from "@angular/core";
import { StiTextItem } from "../../elements/text/StiTextItem";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-editable-content.service";
import * as i3 from "@angular/common";
import * as i4 from "../sti-component";
import * as i5 from "../sti-editable-content.component";
import * as i6 from "../sti-tooltip/sti-tooltip.directive";
export class StiListBoxComponent {
    get align() {
        return "start";
    }
    get needToFill() {
        return this.element.required && this.element.value.length == 0 && this.model.hasEmptyReuiredFields;
    }
    constructor(model, editableService) {
        this.model = model;
        this.editableService = editableService;
        this.isClone = false;
    }
    disableDrag(event) {
        setTimeout(() => {
            this.editableService.editableContent = new StiTextItem("", this.element.font, this.element.textColor, this.element.backgroundColor);
            this.editableService.usedElement = this.element;
        }, 0);
        this.model.canDrag = false;
    }
    ngOnInit() { }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    selectValue(option) {
        if (this.element.allowMultiselection) {
            if (this.element.selectedOptions.indexOf(option) >= 0) {
                this.element?.selectedOptions.splice(this.element.selectedOptions.indexOf(option), 1);
            }
            else {
                this.element.selectedOptions.push(option);
            }
        }
        else {
            this.element.selectedOptions = [];
            this.element.selectedOptions.push(option);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    get htmlStyleElement() {
        return this.element;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiListBoxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiListBoxComponent, selector: "sti-listbox-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-list-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [required]="element.required"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <ul
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="'center'"
            class="{{ element?.readOnly ? 'disabled' : '' }}"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style]="htmlStyleElement?.htmlStyle()"
            [style.border-width]="borderWidth()"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
          >
            <li
              *ngFor="let option of element.options"
              [disabled]="element?.readOnly ? true : false"
              (mousedown)="selectValue(option)"
              class="{{ element.selectedOptions.indexOf(option) >= 0 ? 'active' : '' }}"
            >
              {{ option }}
            </li>
          </ul>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-list-box ul{width:100%;list-style:none;padding:2px;margin-top:10px;margin-bottom:0;border:1px solid}.sti-list-box li{padding:1px 4px;border:1px solid transparent}.sti-list-box li:hover{background-color:#e5f3fb;border-color:#70c0e7}.sti-list-box li:active{background-color:#cbe8f6;border-color:#26a0da}.active{background-color:#f6f6f6;border-color:#dadada!important}.active:hover{background-color:#e5f3fb;border-color:#70c0e7}.active:focus{background-color:#cbe8f6;border-color:#26a0da}.disabled{pointer-events:none;opacity:.5}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i5.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiListBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-listbox-component", template: ` <sti-component [element]="element" [isClone]="isClone" class="sti-list-box">
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [editableContent]="element.label"
      [style.align-self]="align"
      [style.text-align]="element?.getContentAlign()"
      [hideEmpty]="element.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      [required]="element.required"
      [style.width]="element?.getLabelWidth()"
    ></sti-editable-content-component>
    <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <ul
            [style.margin-top.px]="element?.getTopMargin()"
            [style.align-self]="'center'"
            class="{{ element?.readOnly ? 'disabled' : '' }}"
            [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
            [style.background-color]="element?.backgroundColor.toHtmlColor()"
            [style.color]="element?.textColor.toHtmlColor()"
            [style]="htmlStyleElement?.htmlStyle()"
            [style.border-width]="borderWidth()"
            [stiTooltip]="element?.tooltip"
            [tabIndex]="element['tabIndex']"
            tooltipPosition="bottom"
            showDelay="500"
            (mousedown)="disableDrag($event)"
            (mouseup)="this.model.canDrag = true"
          >
            <li
              *ngFor="let option of element.options"
              [disabled]="element?.readOnly ? true : false"
              (mousedown)="selectValue(option)"
              class="{{ element.selectedOptions.indexOf(option) >= 0 ? 'active' : '' }}"
            >
              {{ option }}
            </li>
          </ul>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0">
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}.sti-list-box ul{width:100%;list-style:none;padding:2px;margin-top:10px;margin-bottom:0;border:1px solid}.sti-list-box li{padding:1px 4px;border:1px solid transparent}.sti-list-box li:hover{background-color:#e5f3fb;border-color:#70c0e7}.sti-list-box li:active{background-color:#cbe8f6;border-color:#26a0da}.active{background-color:#f6f6f6;border-color:#dadada!important}.active:hover{background-color:#e5f3fb;border-color:#70c0e7}.active:focus{background-color:#cbe8f6;border-color:#26a0da}.disabled{pointer-events:none;opacity:.5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWxpc3QtYm94LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3N0aS1saXN0LWJveC9zdGktbGlzdC1ib3guY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBTXpELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxpQ0FBaUMsQ0FBQzs7Ozs7Ozs7QUErSDlELE1BQU0sT0FBTyxtQkFBbUI7SUFHOUIsSUFBVyxLQUFLO1FBQ2QsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQztJQUNELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztJQUNyRyxDQUFDO0lBQ0QsWUFBbUIsS0FBc0IsRUFBUyxlQUEwQztRQUF6RSxVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUFTLG9CQUFlLEdBQWYsZUFBZSxDQUEyQjtRQVBuRixZQUFPLEdBQVksS0FBSyxDQUFDO0lBTzZELENBQUM7SUFDaEcsV0FBVyxDQUFDLEtBQUs7UUFDZixVQUFVLENBQUMsR0FBRyxFQUFFO1lBQ2QsSUFBSSxDQUFDLGVBQWUsQ0FBQyxlQUFlLEdBQUcsSUFBSSxXQUFXLENBQ3BELEVBQUUsRUFDRixJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksRUFDakIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQ3RCLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUM3QixDQUFDO1lBQ0YsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUNsRCxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDTixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNELFFBQVEsS0FBVSxDQUFDO0lBRVosV0FBVztRQUNoQixPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLElBQUksQ0FBQztJQUMxQyxDQUFDO0lBQ00sV0FBVyxDQUFDLE1BQU07UUFDdkIsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLG1CQUFtQixFQUFFLENBQUM7WUFDckMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDeEYsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUM1QyxDQUFDO1FBQ0gsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsR0FBRyxFQUFFLENBQUM7WUFDbEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzVDLENBQUM7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsT0FBa0MsQ0FBQztJQUNqRCxDQUFDOytHQTNDVSxtQkFBbUI7bUdBQW5CLG1CQUFtQixpSEEzSHBCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O21CQW1FTzs7NEZBd0ROLG1CQUFtQjtrQkE3SC9CLFNBQVM7K0JBQ0UsdUJBQXVCLFlBQ3ZCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O21CQW1FTzs0SEF5RFIsT0FBTztzQkFBZixLQUFLO2dCQUNHLE9BQU87c0JBQWYsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcblxyXG5pbXBvcnQgeyBTdGlMaXN0Qm94RWxlbWVudCB9IGZyb20gXCIuLi8uLi9lbGVtZW50cy9TdGlMaXN0Qm94RWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlIdG1sU3R5bGUgfSBmcm9tIFwiLi4vLi4vc3lzdGVtL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IHsgU3RpRWRpdGFibGVDb250ZW50U2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9zdGktZWRpdGFibGUtY29udGVudC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aVRleHRJdGVtIH0gZnJvbSBcIi4uLy4uL2VsZW1lbnRzL3RleHQvU3RpVGV4dEl0ZW1cIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1saXN0Ym94LWNvbXBvbmVudFwiLFxyXG4gIHRlbXBsYXRlOiBgIDxzdGktY29tcG9uZW50IFtlbGVtZW50XT1cImVsZW1lbnRcIiBbaXNDbG9uZV09XCJpc0Nsb25lXCIgY2xhc3M9XCJzdGktbGlzdC1ib3hcIj5cclxuICAgIDxzdGktZWRpdGFibGUtY29udGVudC1jb21wb25lbnRcclxuICAgICAgKm5nSWY9XCJlbGVtZW50Py5sYWJlbC52YWx1ZT8ubGVuZ3RoID4gMCAmJiBlbGVtZW50Py5pc0xhYmVsVG9wQWxpZ25tZW50KClcIlxyXG4gICAgICBbZWRpdGFibGVDb250ZW50XT1cImVsZW1lbnQubGFiZWxcIlxyXG4gICAgICBbc3R5bGUuYWxpZ24tc2VsZl09XCJhbGlnblwiXHJcbiAgICAgIFtzdHlsZS50ZXh0LWFsaWduXT1cImVsZW1lbnQ/LmdldENvbnRlbnRBbGlnbigpXCJcclxuICAgICAgW2hpZGVFbXB0eV09XCJlbGVtZW50LnNob3dMYWJlbFBsYWNlaG9sZGVyKG1vZGVsPy5zZWxlY3RlZENvbXBvbmVudD8uZWxlbWVudCA9PSBlbGVtZW50KVwiXHJcbiAgICAgIFtyZXF1aXJlZF09XCJlbGVtZW50LnJlcXVpcmVkXCJcclxuICAgICAgW3N0eWxlLndpZHRoXT1cImVsZW1lbnQ/LmdldExhYmVsV2lkdGgoKVwiXHJcbiAgICA+PC9zdGktZWRpdGFibGUtY29udGVudC1jb21wb25lbnQ+XHJcbiAgICA8dGFibGUgW3N0eWxlLndpZHRoXT1cIicxMDAlJ1wiIFtzdHlsZS5oZWlnaHRdPVwiJ21heC1jb250ZW50J1wiIFtzdHlsZS5tYXJnaW4tdG9wLnB4XT1cImVsZW1lbnQ/LmdldFRvcE1hcmdpbigpXCI+XHJcbiAgICAgIDx0cj5cclxuICAgICAgICA8dGRcclxuICAgICAgICAgICpuZ0lmPVwiZWxlbWVudD8ubGFiZWwudmFsdWU/Lmxlbmd0aCA+IDAgJiYgIWVsZW1lbnQ/LmlzTGFiZWxUb3BBbGlnbm1lbnQoKVwiXHJcbiAgICAgICAgICBbc3R5bGUuZGlzcGxheV09XCInZmxleCdcIlxyXG4gICAgICAgICAgW3N0eWxlLmhlaWdodF09XCInMTAwJSdcIlxyXG4gICAgICAgICAgW3N0eWxlLndpZHRoXT1cImVsZW1lbnQ/LmdldExhYmVsV2lkdGgoKVwiXHJcbiAgICAgICAgICBbc3R5bGUuYWxpZ24taXRlbXNdPVwiZWxlbWVudD8uZ2V0VmVydGljYWxBbGlnbm1lbnQoKVwiXHJcbiAgICAgICAgPlxyXG4gICAgICAgICAgPHN0aS1lZGl0YWJsZS1jb250ZW50LWNvbXBvbmVudFxyXG4gICAgICAgICAgICAqbmdJZj1cImVsZW1lbnQ/LmxhYmVsLnZhbHVlPy5sZW5ndGggPiAwXCJcclxuICAgICAgICAgICAgW2VkaXRhYmxlQ29udGVudF09XCJlbGVtZW50Py5sYWJlbFwiXHJcbiAgICAgICAgICAgIFtyZXF1aXJlZF09XCJlbGVtZW50LnJlcXVpcmVkXCJcclxuICAgICAgICAgICAgW3N0eWxlLnRleHQtYWxpZ25dPVwiZWxlbWVudD8uZ2V0Q29udGVudEFsaWduKClcIlxyXG4gICAgICAgICAgICBbc3R5bGUud2lkdGhdPVwiZWxlbWVudD8uZ2V0TGFiZWxXaWR0aCgpXCJcclxuICAgICAgICAgICAgW2hpZGVFbXB0eV09XCJlbGVtZW50Py5zaG93TGFiZWxQbGFjZWhvbGRlcihtb2RlbD8uc2VsZWN0ZWRDb21wb25lbnQ/LmVsZW1lbnQgPT0gZWxlbWVudClcIlxyXG4gICAgICAgICAgPjwvc3RpLWVkaXRhYmxlLWNvbnRlbnQtY29tcG9uZW50PlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgICAgPHRkIFtzdHlsZS53aWR0aF09XCInMTAwJSdcIj5cclxuICAgICAgICAgIDx1bFxyXG4gICAgICAgICAgICBbc3R5bGUubWFyZ2luLXRvcC5weF09XCJlbGVtZW50Py5nZXRUb3BNYXJnaW4oKVwiXHJcbiAgICAgICAgICAgIFtzdHlsZS5hbGlnbi1zZWxmXT1cIidjZW50ZXInXCJcclxuICAgICAgICAgICAgY2xhc3M9XCJ7eyBlbGVtZW50Py5yZWFkT25seSA/ICdkaXNhYmxlZCcgOiAnJyB9fVwiXHJcbiAgICAgICAgICAgIFtzdHlsZS5ib3JkZXItY29sb3JdPVwibmVlZFRvRmlsbCA/ICdyZWQnIDogZWxlbWVudD8uYm9yZGVyQ29sb3IudG9IdG1sQ29sb3IoKVwiXHJcbiAgICAgICAgICAgIFtzdHlsZS5iYWNrZ3JvdW5kLWNvbG9yXT1cImVsZW1lbnQ/LmJhY2tncm91bmRDb2xvci50b0h0bWxDb2xvcigpXCJcclxuICAgICAgICAgICAgW3N0eWxlLmNvbG9yXT1cImVsZW1lbnQ/LnRleHRDb2xvci50b0h0bWxDb2xvcigpXCJcclxuICAgICAgICAgICAgW3N0eWxlXT1cImh0bWxTdHlsZUVsZW1lbnQ/Lmh0bWxTdHlsZSgpXCJcclxuICAgICAgICAgICAgW3N0eWxlLmJvcmRlci13aWR0aF09XCJib3JkZXJXaWR0aCgpXCJcclxuICAgICAgICAgICAgW3N0aVRvb2x0aXBdPVwiZWxlbWVudD8udG9vbHRpcFwiXHJcbiAgICAgICAgICAgIFt0YWJJbmRleF09XCJlbGVtZW50Wyd0YWJJbmRleCddXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgKG1vdXNlZG93bik9XCJkaXNhYmxlRHJhZygkZXZlbnQpXCJcclxuICAgICAgICAgICAgKG1vdXNldXApPVwidGhpcy5tb2RlbC5jYW5EcmFnID0gdHJ1ZVwiXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIDxsaVxyXG4gICAgICAgICAgICAgICpuZ0Zvcj1cImxldCBvcHRpb24gb2YgZWxlbWVudC5vcHRpb25zXCJcclxuICAgICAgICAgICAgICBbZGlzYWJsZWRdPVwiZWxlbWVudD8ucmVhZE9ubHkgPyB0cnVlIDogZmFsc2VcIlxyXG4gICAgICAgICAgICAgIChtb3VzZWRvd24pPVwic2VsZWN0VmFsdWUob3B0aW9uKVwiXHJcbiAgICAgICAgICAgICAgY2xhc3M9XCJ7eyBlbGVtZW50LnNlbGVjdGVkT3B0aW9ucy5pbmRleE9mKG9wdGlvbikgPj0gMCA/ICdhY3RpdmUnIDogJycgfX1cIlxyXG4gICAgICAgICAgICA+XHJcbiAgICAgICAgICAgICAge3sgb3B0aW9uIH19XHJcbiAgICAgICAgICAgIDwvbGk+XHJcbiAgICAgICAgICA8L3VsPlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgIDwvdHI+XHJcbiAgICAgIDx0ciAqbmdJZj1cImVsZW1lbnQ/LmRlc2NyaXB0aW9uLnZhbHVlPy5sZW5ndGggPiAwXCI+XHJcbiAgICAgICAgPHRkICpuZ0lmPVwiZWxlbWVudD8ubGFiZWwudmFsdWU/Lmxlbmd0aCA+IDAgJiYgIWVsZW1lbnQ/LmlzTGFiZWxUb3BBbGlnbm1lbnQoKVwiPjwvdGQ+XHJcbiAgICAgICAgPHRkIFtzdHlsZS5tYXhXaWR0aC5weF09XCJlbGVtZW50Lm1heFdpZHRoICsgMVwiPlxyXG4gICAgICAgICAgPHN0aS1lZGl0YWJsZS1jb250ZW50LWNvbXBvbmVudFxyXG4gICAgICAgICAgICAqbmdJZj1cImVsZW1lbnQ/LmRlc2NyaXB0aW9uLnZhbHVlPy5sZW5ndGggPiAwXCJcclxuICAgICAgICAgICAgW2VkaXRhYmxlQ29udGVudF09XCJlbGVtZW50LmRlc2NyaXB0aW9uXCJcclxuICAgICAgICAgID5cclxuICAgICAgICAgIDwvc3RpLWVkaXRhYmxlLWNvbnRlbnQtY29tcG9uZW50PlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgIDwvdHI+XHJcbiAgICA8L3RhYmxlPlxyXG4gIDwvc3RpLWNvbXBvbmVudD5gLFxyXG4gIHN0eWxlczogW1xyXG4gICAgYFxyXG4gICAgICB0YWJsZSB7XHJcbiAgICAgICAgYm9yZGVyLXNwYWNpbmc6IDA7XHJcbiAgICAgIH1cclxuICAgICAgdHIge1xyXG4gICAgICAgIGhlaWdodDogbWF4LWNvbnRlbnQ7XHJcbiAgICAgICAgcGFkZGluZzogMDtcclxuICAgICAgICBtYXJnaW46IDA7XHJcbiAgICAgIH1cclxuICAgICAgdGQge1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgICBwYWRkaW5nOiAwO1xyXG4gICAgICAgIG1hcmdpbjogMDtcclxuICAgICAgfVxyXG4gICAgICAuc3RpLWxpc3QtYm94IHVsIHtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBsaXN0LXN0eWxlOiBub25lO1xyXG4gICAgICAgIHBhZGRpbmc6IDJweDtcclxuICAgICAgICBtYXJnaW4tdG9wOiAxMHB4O1xyXG4gICAgICAgIG1hcmdpbi1ib3R0b206IDA7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQ7XHJcbiAgICAgIH1cclxuICAgICAgLnN0aS1saXN0LWJveCBsaSB7XHJcbiAgICAgICAgcGFkZGluZzogMXB4IDRweDtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB0cmFuc3BhcmVudDtcclxuICAgICAgfVxyXG4gICAgICAuc3RpLWxpc3QtYm94IGxpOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjI5LCAyNDMsIDI1MSk7XHJcbiAgICAgICAgYm9yZGVyLWNvbG9yOiByZ2IoMTEyLCAxOTIsIDIzMSk7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC5zdGktbGlzdC1ib3ggbGk6YWN0aXZlIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjAzLCAyMzIsIDI0Nik7XHJcbiAgICAgICAgYm9yZGVyLWNvbG9yOiByZ2IoMzgsIDE2MCwgMjE4KTtcclxuICAgICAgfVxyXG4gICAgICAuYWN0aXZlIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjQ2LCAyNDYsIDI0Nik7XHJcbiAgICAgICAgYm9yZGVyLWNvbG9yOiByZ2IoMjE4LCAyMTgsIDIxOCkgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgICAuYWN0aXZlOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjI5LCAyNDMsIDI1MSk7XHJcbiAgICAgICAgYm9yZGVyLWNvbG9yOiByZ2IoMTEyLCAxOTIsIDIzMSk7XHJcbiAgICAgIH1cclxuICAgICAgLmFjdGl2ZTpmb2N1cyB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIwMywgMjMyLCAyNDYpO1xyXG4gICAgICAgIGJvcmRlci1jb2xvcjogcmdiKDM4LCAxNjAsIDIxOCk7XHJcbiAgICAgIH1cclxuICAgICAgLmRpc2FibGVkIHtcclxuICAgICAgICBwb2ludGVyLWV2ZW50czogbm9uZTtcclxuICAgICAgICBvcGFjaXR5OiAwLjU7XHJcbiAgICAgIH1cclxuICAgIGAsXHJcbiAgXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aUxpc3RCb3hDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIEBJbnB1dCgpIGVsZW1lbnQ6IFN0aUxpc3RCb3hFbGVtZW50O1xyXG4gIEBJbnB1dCgpIGlzQ2xvbmU6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgZ2V0IGFsaWduKCkge1xyXG4gICAgcmV0dXJuIFwic3RhcnRcIjtcclxuICB9XHJcbiAgcHVibGljIGdldCBuZWVkVG9GaWxsKCkge1xyXG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudC5yZXF1aXJlZCAmJiB0aGlzLmVsZW1lbnQudmFsdWUubGVuZ3RoID09IDAgJiYgdGhpcy5tb2RlbC5oYXNFbXB0eVJldWlyZWRGaWVsZHM7XHJcbiAgfVxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLCBwdWJsaWMgZWRpdGFibGVTZXJ2aWNlOiBTdGlFZGl0YWJsZUNvbnRlbnRTZXJ2aWNlKSB7fVxyXG4gIGRpc2FibGVEcmFnKGV2ZW50KSB7XHJcbiAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgdGhpcy5lZGl0YWJsZVNlcnZpY2UuZWRpdGFibGVDb250ZW50ID0gbmV3IFN0aVRleHRJdGVtKFxyXG4gICAgICAgIFwiXCIsXHJcbiAgICAgICAgdGhpcy5lbGVtZW50LmZvbnQsXHJcbiAgICAgICAgdGhpcy5lbGVtZW50LnRleHRDb2xvcixcclxuICAgICAgICB0aGlzLmVsZW1lbnQuYmFja2dyb3VuZENvbG9yXHJcbiAgICAgICk7XHJcbiAgICAgIHRoaXMuZWRpdGFibGVTZXJ2aWNlLnVzZWRFbGVtZW50ID0gdGhpcy5lbGVtZW50O1xyXG4gICAgfSwgMCk7XHJcbiAgICB0aGlzLm1vZGVsLmNhbkRyYWcgPSBmYWxzZTtcclxuICB9XHJcbiAgbmdPbkluaXQoKTogdm9pZCB7fVxyXG5cclxuICBwdWJsaWMgYm9yZGVyV2lkdGgoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiBgJHt0aGlzLmVsZW1lbnQuYm9yZGVyV2VpZ2h0fXB4YDtcclxuICB9XHJcbiAgcHVibGljIHNlbGVjdFZhbHVlKG9wdGlvbikge1xyXG4gICAgaWYgKHRoaXMuZWxlbWVudC5hbGxvd011bHRpc2VsZWN0aW9uKSB7XHJcbiAgICAgIGlmICh0aGlzLmVsZW1lbnQuc2VsZWN0ZWRPcHRpb25zLmluZGV4T2Yob3B0aW9uKSA+PSAwKSB7XHJcbiAgICAgICAgdGhpcy5lbGVtZW50Py5zZWxlY3RlZE9wdGlvbnMuc3BsaWNlKHRoaXMuZWxlbWVudC5zZWxlY3RlZE9wdGlvbnMuaW5kZXhPZihvcHRpb24pLCAxKTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmVsZW1lbnQuc2VsZWN0ZWRPcHRpb25zLnB1c2gob3B0aW9uKTtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5lbGVtZW50LnNlbGVjdGVkT3B0aW9ucyA9IFtdO1xyXG4gICAgICB0aGlzLmVsZW1lbnQuc2VsZWN0ZWRPcHRpb25zLnB1c2gob3B0aW9uKTtcclxuICAgIH1cclxuXHJcbiAgICB0aGlzLm1vZGVsLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiVmFsdWVDaGFuZ2VkXCIgfSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgaHRtbFN0eWxlRWxlbWVudCgpOiBTdGlIdG1sU3R5bGUge1xyXG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudCBhcyB1bmtub3duIGFzIFN0aUh0bWxTdHlsZTtcclxuICB9XHJcbn1cclxuIl19