import { Component, Input } from "@angular/core";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../sti-component";
import * as i3 from "../sti-editable-content.component";
export class StiLabelComponent {
    get borderInnerWidth() {
        return Number(this.element.width) + Number(this.element.border.pen.width);
    }
    get borderInnerHeight() {
        return Number(this.element.height) + Number(this.element.border.pen.width);
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get exceedMarginsLeft() {
        if (this.element.exceedMargins.drawLeft) {
            return -this.model.getElementPage(this.element)?.padding.left - this.element.geometry.x;
        }
        else {
            return 0;
        }
    }
    get exceedMarginsTop() {
        if (this.element.exceedMargins.drawTop) {
            return -this.model.getElementPage(this.element)?.padding.top - this.element.geometry.y;
        }
        else {
            return 0;
        }
    }
    get exceedMarginsWidth() {
        if (!this.element.exceedMargins.drawLeft && !this.element.exceedMargins.drawRight) {
            return this.element.width;
        }
        else if (this.element.exceedMargins.drawLeft && !this.element.exceedMargins.drawRight) {
            return (this.element.width -
                this.element.padding.right +
                this.model.getElementPage(this.element)?.padding.left +
                this.element.geometry.x);
        }
        else if (!this.element.exceedMargins.drawLeft && this.element.exceedMargins.drawRight) {
            return (this.model.getElementPage(this.element)?.width -
                this.model.getElementPage(this.element)?.padding.left -
                this.element.x -
                this.element.padding.left);
        }
        else {
            return this.model.getElementPage(this.element)?.width;
        }
    }
    get exceedMarginsHeight() {
        if (!this.element.exceedMargins.drawTop && !this.element.exceedMargins.drawBottom) {
            return this.element.height;
        }
        else if (this.element.exceedMargins.drawTop && !this.element.exceedMargins.drawBottom) {
            return (this.element.height -
                this.element.padding.bottom +
                this.model.getElementPage(this.element)?.padding.top +
                this.element.geometry.y);
        }
        else if (!this.element.exceedMargins.drawTop && this.element.exceedMargins.drawBottom) {
            return (this.model.getElementPage(this.element)?.height -
                this.model.getElementPage(this.element)?.padding.top -
                this.element.y -
                this.element.padding.top);
        }
        else {
            return this.model.getElementPage(this.element)?.height;
        }
    }
    get horizontalAlignment() {
        if (this.element.text.horizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else if (this.element.text.horizontalAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get verticalAlignment() {
        if (this.element.text.verticalAlignment == StiVerticalAlignment.Top) {
            return "start";
        }
        else if (this.element.text.verticalAlignment == StiVerticalAlignment.Bottom) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    openLink() {
        if (this.element.hyperlink.length > 0 && this.model.previewMode) {
            window.open(this.element.hyperlink, "_blank");
        }
    }
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLabelComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiLabelComponent, selector: "sti-label-component", inputs: { element: "element", isClone: "isClone" }, ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-label"
    [style.pointer-events]="model.previewMode ? 'none' : ''"
  >
    <div
      [style]="element.htmlStyle()"
      [style.justify-content]="horizontalAlignment"
      [style.align-items]="verticalAlignment"
      [style.overflow]="'hidden'"
    >
      <sti-editable-content-component
        [editableContent]="element?.text"
        [displayContent]="element?.displayValue"
        [style]="element.htmlStyle()"
        [hideEmpty]="false"
        [active]="selected"
        [disablePadding]="true"
        (click)="openLink()"
        [parentCursor]="element.hyperlink.length > 0 && model.previewMode ? 'pointer' : 'text'"
      >
      </sti-editable-content-component>
    </div>
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <div
      class="exceed-margins"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.left.px]="exceedMarginsLeft"
      [style.top.px]="exceedMarginsTop"
      [style.width.px]="exceedMarginsWidth"
      [style.height.px]="exceedMarginsHeight"
      [style.pointer-events]="'none'"
    ></div>
  </sti-component>`, isInline: true, styles: [".sti-label p{font-size:12px;font-weight:400;margin:0}div{display:flex;height:100%;width:100%}.exceed-margins{position:absolute;background-color:red;z-index:-1}\n"], dependencies: [{ kind: "component", type: i2.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i3.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLabelComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-label-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    class="sti-label"
    [style.pointer-events]="model.previewMode ? 'none' : ''"
  >
    <div
      [style]="element.htmlStyle()"
      [style.justify-content]="horizontalAlignment"
      [style.align-items]="verticalAlignment"
      [style.overflow]="'hidden'"
    >
      <sti-editable-content-component
        [editableContent]="element?.text"
        [displayContent]="element?.displayValue"
        [style]="element.htmlStyle()"
        [hideEmpty]="false"
        [active]="selected"
        [disablePadding]="true"
        (click)="openLink()"
        [parentCursor]="element.hyperlink.length > 0 && model.previewMode ? 'pointer' : 'text'"
      >
      </sti-editable-content-component>
    </div>
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <div
      class="exceed-margins"
      [style.background-color]="element?.text.backgroundColor.toHtmlColor()"
      [style.left.px]="exceedMarginsLeft"
      [style.top.px]="exceedMarginsTop"
      [style.width.px]="exceedMarginsWidth"
      [style.height.px]="exceedMarginsHeight"
      [style.pointer-events]="'none'"
    ></div>
  </sti-component>`, styles: [".sti-label p{font-size:12px;font-weight:400;margin:0}div{display:flex;height:100%;width:100%}.exceed-margins{position:absolute;background-color:red;z-index:-1}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }], propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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