import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-form-checker.service";
import * as i4 from "../../services/http-client.service";
export class StiFormCheckerItemComponent {
    constructor(model, loc, formCheckerService, httpService) {
        this.model = model;
        this.loc = loc;
        this.formCheckerService = formCheckerService;
        this.httpService = httpService;
    }
    save() {
        let currentForm = this.model.form.saveToReportJsonObject().serialize();
        if (this.model.isWebView) {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClickForDesigner", data: { form: currentForm } })
                .subscribe(() => { });
        }
        else {
            this.httpService
                .post("", { action: "InterfaceEvent", event: "SaveToCloudButtonClick", data: { form: currentForm } })
                .subscribe(() => { });
        }
        // this.model.showSaveDialogFromCloud = true;
    }
    edit() {
        this.formCheckerService.showFormCheckerWindow = false;
    }
    ignore() {
        // this.formCheckerService.formMessages.splice(this.index - 1, 1);
        this.formCheckerService.showFormCheckerWindow = false;
        this.model.formEvents.next({ name: this.formCheckerService.currentPressedButton });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerItemComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiFormCheckerService }, { token: i4.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFormCheckerItemComponent, selector: "sti-form-checker-item", inputs: { item: "item", index: "index" }, ngImport: i0, template: ` <div class="form-checker-item">
    <div class="item-container">
      <div class="item-icon">
        <img [src]="model.getImage('images.Form_Checker.Warning32.png')" />
      </div>
      <div class="item-content">
        <div class="item-label">{{ index + "." }}{{ item.label }}</div>
        <div class="item-message">{{ item.content.replace("{0}", formCheckerService.buttonNames) }}</div>
      </div>
    </div>
    <div class="item-navigation">
      <div class="button" (click)="save()">{{ "Save to cloud" }}</div>
      <!-- <div class="button" (click)="edit()">{{ loc.get2("MainMenu", "menuEditEdit") }}</div>
      <div class="button" (click)="ignore()">{{ loc.get2("PropertyEnum", "DialogResultIgnore") }}</div> -->
    </div>
  </div>`, isInline: true, styles: [".item-navigation{display:flex;justify-content:end;margin:5px 0}.form-checker-item{padding-top:10px;border-bottom:1px dashed lightgray;margin:0 10px;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.button{background-color:#ddd;height:24px;min-width:24px;padding:0 10px;border-radius:3px;color:#444;margin:5px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#d5d5d5}.item-icon{display:flex;align-items:center}.item-icon img{width:32px;height:32px;margin-right:12px}.item-container{display:flex}.item-content{font-family:Arial;color:#444;font-size:12px}.item-label{font-weight:700;margin-top:5px}.item-message{margin-top:15px}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormCheckerItemComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-form-checker-item", template: ` <div class="form-checker-item">
    <div class="item-container">
      <div class="item-icon">
        <img [src]="model.getImage('images.Form_Checker.Warning32.png')" />
      </div>
      <div class="item-content">
        <div class="item-label">{{ index + "." }}{{ item.label }}</div>
        <div class="item-message">{{ item.content.replace("{0}", formCheckerService.buttonNames) }}</div>
      </div>
    </div>
    <div class="item-navigation">
      <div class="button" (click)="save()">{{ "Save to cloud" }}</div>
      <!-- <div class="button" (click)="edit()">{{ loc.get2("MainMenu", "menuEditEdit") }}</div>
      <div class="button" (click)="ignore()">{{ loc.get2("PropertyEnum", "DialogResultIgnore") }}</div> -->
    </div>
  </div>`, styles: [".item-navigation{display:flex;justify-content:end;margin:5px 0}.form-checker-item{padding-top:10px;border-bottom:1px dashed lightgray;margin:0 10px;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;-webkit-touch-callout:none;-webkit-user-select:none}.button{background-color:#ddd;height:24px;min-width:24px;padding:0 10px;border-radius:3px;color:#444;margin:5px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:#d5d5d5}.item-icon{display:flex;align-items:center}.item-icon img{width:32px;height:32px;margin-right:12px}.item-container{display:flex}.item-content{font-family:Arial;color:#444;font-size:12px}.item-label{font-weight:700;margin-top:5px}.item-message{margin-top:15px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiFormCheckerService }, { type: i4.StiHttpClientService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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