import { Component, } from "@angular/core";
import { StiLocalizationService } from "../../services/sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "@angular/forms";
export class StiFileSaveContentComponent {
    constructor(model, helper, loc, cdr) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.cdr = cdr;
        this.name = StiLocalizationService.get("PropertyMain", "Name");
        this.save = StiLocalizationService.get("PropertyMain", "Save");
        this.cancel = StiLocalizationService.get("PropertyMain", "Cancel");
        this.browse = StiLocalizationService.get("ReportOpen", "Browse");
        this.isSmallWindow = false;
    }
    ngAfterViewInit() {
        let element = document.getElementsByClassName("file-save-container")[0];
        let isSmall = element ? element.clientWidth < 450 : window.innerWidth < 450 + 170;
        if (isSmall != this.isSmallWindow) {
            this.isSmallWindow = isSmall;
            this.cdr.detach();
            setTimeout(() => {
                this.cdr.reattach();
            });
        }
    }
    close() {
        this.model.ribbon = "Home";
    }
    saveFile() {
        this.model.saveLastFormState();
        this.model.ribbon = "Home";
        this.model.interfaceEvent.next({ name: "FormSaveAs", data: { form: this.model.form, name: this.model.fileName } });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileSaveContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFileSaveContentComponent, selector: "sti-file-save-content", ngImport: i0, template: `
    <div class="{{ isSmallWindow ? 'small-file-save-container' : 'file-save-container' }}">
      <div class="{{ isSmallWindow ? 'small-file-save-navigation' : 'file-save-navigation' }}">
        <div class="navigation-item">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
      <div class="content">
        <div class="{{ isSmallWindow ? 'small-save-container' : 'save-container' }}">
          <!-- <div class="save-container-navigation">
            <label>{{
              model.currentSelectedFileOption != "SaveAs"
                ? loc.getP(model.currentSelectedFileOption)
                : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
            }}</label>
            <div class="close-button" (click)="close()">
              <img [src]="model.getImage('images.Other.ClosePanel.png')" alt="" />
            </div>
          </div> -->
          <div class="save-input">
            <span>{{ name }}</span>
            <input type="text" spellcheck="false" [(ngModel)]="model.fileName" />
          </div>
          <div class="save-buttons-container">
            <div class="button accept" (click)="saveFile()">
              <span>{{ save }}</span>
            </div>
            <!-- <div class="button cancel" (click)="close()">
              <span>{{ cancel }}</span>
            </div> -->
          </div>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".content{width:100%}.file-save-container{height:100%;width:100%;display:flex;padding:10px 30px}.small-file-save-container{height:100%;width:100%;display:flex;padding:10px 30px;flex-direction:column;align-items:center;border-right:1px solid rgb(218,218,218)}.file-save-navigation{min-width:150px;width:50%;max-width:260px;padding-right:10px;border-right:1px solid rgb(218,218,218)}.small-file-save-navigation{min-width:150px;width:100%;max-width:260px}.navigation-item{display:flex;height:50px;min-width:130px;background-color:#e5e5e5;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}.save-container{max-width:500px;height:50px;background-color:#fff;margin-left:10px;display:flex;align-items:center}.small-save-container{max-width:500px;height:50px;background-color:#fff;margin-top:20px;display:flex;align-items:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}label{font-size:13px;font-weight:700;color:#19478a;font-family:Arial;flex:1;padding-left:15px}.save-container-navigation{height:30px;width:100%;display:flex;align-items:center}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{width:16px;height:16px}.save-input{display:flex;align-items:center;flex:1;padding:0 10px}.save-input input{width:100%;height:24px;border:1px solid rgb(171,171,171);background-color:#fff;color:#444;font-size:12px;border-radius:3px;padding:0 0 0 4px;outline:none}.save-buttons-container{height:58px;width:fit-content;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px}.button span{margin:0;padding:0}.accept{background-color:#19478a;color:#fff;margin-right:0}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileSaveContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-save-content", template: `
    <div class="{{ isSmallWindow ? 'small-file-save-container' : 'file-save-container' }}">
      <div class="{{ isSmallWindow ? 'small-file-save-navigation' : 'file-save-navigation' }}">
        <div class="navigation-item">
          <div class="navigation-icon">
            <img [src]="model.getImage('images.Other.FileMenu.Open.png')" alt="" />
          </div>
          <span>{{ browse }}</span>
        </div>
      </div>
      <div class="content">
        <div class="{{ isSmallWindow ? 'small-save-container' : 'save-container' }}">
          <!-- <div class="save-container-navigation">
            <label>{{
              model.currentSelectedFileOption != "SaveAs"
                ? loc.getP(model.currentSelectedFileOption)
                : loc.get2("MainMenu", "menuFileSaveAs").replace("...", "")
            }}</label>
            <div class="close-button" (click)="close()">
              <img [src]="model.getImage('images.Other.ClosePanel.png')" alt="" />
            </div>
          </div> -->
          <div class="save-input">
            <span>{{ name }}</span>
            <input type="text" spellcheck="false" [(ngModel)]="model.fileName" />
          </div>
          <div class="save-buttons-container">
            <div class="button accept" (click)="saveFile()">
              <span>{{ save }}</span>
            </div>
            <!-- <div class="button cancel" (click)="close()">
              <span>{{ cancel }}</span>
            </div> -->
          </div>
        </div>
      </div>
    </div>
  `, styles: [".content{width:100%}.file-save-container{height:100%;width:100%;display:flex;padding:10px 30px}.small-file-save-container{height:100%;width:100%;display:flex;padding:10px 30px;flex-direction:column;align-items:center;border-right:1px solid rgb(218,218,218)}.file-save-navigation{min-width:150px;width:50%;max-width:260px;padding-right:10px;border-right:1px solid rgb(218,218,218)}.small-file-save-navigation{min-width:150px;width:100%;max-width:260px}.navigation-item{display:flex;height:50px;min-width:130px;background-color:#e5e5e5;border-radius:3px}.navigation-item:hover{background-color:#dadada}.navigation-icon{padding:0 10px;display:flex;align-items:center;justify-content:center}.save-container{max-width:500px;height:50px;background-color:#fff;margin-left:10px;display:flex;align-items:center}.small-save-container{max-width:500px;height:50px;background-color:#fff;margin-top:20px;display:flex;align-items:center}img{width:32px;height:32px}span{height:100%;padding:0 20px 0 10px;display:flex;align-items:center;font-size:12px;font-family:Arial;cursor:default}label{font-size:13px;font-weight:700;color:#19478a;font-family:Arial;flex:1;padding-left:15px}.save-container-navigation{height:30px;width:100%;display:flex;align-items:center}.close-button{width:28px;height:28px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{width:16px;height:16px}.save-input{display:flex;align-items:center;flex:1;padding:0 10px}.save-input input{width:100%;height:24px;border:1px solid rgb(171,171,171);background-color:#fff;color:#444;font-size:12px;border-radius:3px;padding:0 0 0 4px;outline:none}.save-buttons-container{height:58px;width:fit-content;display:flex;align-items:center;justify-content:flex-end}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 10px}.button span{margin:0;padding:0}.accept{background-color:#19478a;color:#fff;margin-right:0}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i0.ChangeDetectorRef }] });
//# sourceMappingURL=data:application/json;base64,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