import { Component } from "@angular/core";
import { StiForm } from "../../elements/StiForm";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-undo-service";
export class StiFileNewContentComponent {
    constructor(model, undoService) {
        this.model = model;
        this.undoService = undoService;
        this.blankForm = "Blank Form";
    }
    createNew() {
        this.model.form.attachedFiles = [];
        this.model.ribbon = "Home";
        if (this.model.currentFormState &&
            this.model.currentFormState !== this.model.lastSavedFormState &&
            this.undoService.undos.length > 1) {
            this.model.showSaveDialog = true;
            this.model.saveDialogFromNew = true;
            this.model.saveDialogFromOpen = false;
        }
        else {
            let form = new StiForm();
            this.model.form = form;
        }
        this.model.formEvents.next({ name: "New" });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileNewContentComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiUndoService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFileNewContentComponent, selector: "sti-file-new-content", ngImport: i0, template: `
    <div class="file-new-container">
      <div class="file-new-navigation" (click)="createNew()">
        <div>
          <img [src]="model.getImage('images.Other.BlankReport.png')" alt="" />
        </div>
        <span>{{ blankForm }} </span>
      </div>
      <div class="divider"></div>
    </div>
  `, isInline: true, styles: [".file-new-container{width:100%;height:100%;padding-left:20px;background-color:#fff;-webkit-user-select:none}.file-new-navigation{height:250px;width:200px;display:flex;flex-direction:column;justify-content:center;align-items:center}.file-new-navigation:hover{background-color:#dadada}.file-new-navigation img{height:203px;width:144px}.divider{margin:20px 0;height:1px;width:calc(100% - 20px);background-color:#c6c6c6}img{margin:12px 12px 0}span{height:25px;font-family:Arial;font-size:12px;display:flex;align-items:flex-end}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileNewContentComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-new-content", template: `
    <div class="file-new-container">
      <div class="file-new-navigation" (click)="createNew()">
        <div>
          <img [src]="model.getImage('images.Other.BlankReport.png')" alt="" />
        </div>
        <span>{{ blankForm }} </span>
      </div>
      <div class="divider"></div>
    </div>
  `, styles: [".file-new-container{width:100%;height:100%;padding-left:20px;background-color:#fff;-webkit-user-select:none}.file-new-navigation{height:250px;width:200px;display:flex;flex-direction:column;justify-content:center;align-items:center}.file-new-navigation:hover{background-color:#dadada}.file-new-navigation img{height:203px;width:144px}.divider{margin:20px 0;height:1px;width:calc(100% - 20px);background-color:#c6c6c6}img{margin:12px 12px 0}span{height:25px;font-family:Arial;font-size:12px;display:flex;align-items:flex-end}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiUndoService }] });
//# sourceMappingURL=data:application/json;base64,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