import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-draggable-modal-window.service";
import * as i4 from "../../services/sti-signature.service";
import * as i5 from "../../services/mouse.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-embed-editors/sti-embed-text-editor.components";
import * as i8 from "../sti-embed-editors/sti-embed-image-editor.component";
export class StiDraggableModalWindowComponent {
    constructor(model, loc, modalWindowService, signatureService, mouseService) {
        this.model = model;
        this.loc = loc;
        this.modalWindowService = modalWindowService;
        this.signatureService = signatureService;
        this.mouseService = mouseService;
    }
    ngAfterViewInit() {
        const onResize = (event) => {
            this.modalWindowService.editorX = (window.innerWidth - this.modalWindowService.editorWidth) / 2;
            this.modalWindowService.editorY = (window.innerHeight - this.modalWindowService.editorHeight) / 2;
        };
        window.addEventListener("resize", onResize);
    }
    get header() {
        return this.modalWindowService.isTextEditor
            ? this.loc.get2("FormTitles", "TextEditorForm")
            : this.loc.get2("Components", "StiImage");
    }
    startDrag(event) {
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.startComponentX = this.modalWindowService.editorX;
        this.startComponentY = this.modalWindowService.editorY;
        this.isDragging = true;
    }
    accept() {
        this.modalWindowService.isTextEditor
            ? this.signatureService.getInsertedInformation.next({ eventName: "TextEditor" })
            : this.signatureService.getInsertedInformation.next({ eventName: "ImageEditor" });
        this.model.showDraggableModalWindow = false;
    }
    onMouseMove(event) {
        if (this.isDragging) {
            let deltaX = event.clientX - this.startX;
            let deltaY = event.clientY - this.startY;
            if (this.startComponentX + deltaX < 0) {
                this.modalWindowService.editorX = 0;
            }
            else if (this.startComponentX + deltaX > window.innerWidth - this.modalWindowService.editorWidth) {
                this.modalWindowService.editorX = window.innerWidth - this.modalWindowService.editorWidth;
            }
            else {
                this.modalWindowService.editorX = this.startComponentX + deltaX;
            }
            if (this.startComponentY + deltaY < 0) {
                this.modalWindowService.editorY = 0;
            }
            else if (this.startComponentY + deltaY > window.innerHeight - this.modalWindowService.editorHeight) {
                this.modalWindowService.editorY = window.innerHeight - this.modalWindowService.editorHeight;
            }
            else {
                this.modalWindowService.editorY = this.startComponentY + deltaY;
            }
        }
    }
    ngOnInit() {
        this.modalWindowService.editorX = (window.innerWidth - this.modalWindowService.editorWidth) / 2;
        this.modalWindowService.editorY = (window.innerHeight - this.modalWindowService.editorHeight) / 2;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.isDragging = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableModalWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiDraggableModalWindowService }, { token: i4.SignatureService }, { token: i5.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiDraggableModalWindowComponent, selector: "sti-draggable-modal-window", ngImport: i0, template: `<div
    class="draggable-modal-window-container"
    [style.left.px]="modalWindowService.editorX"
    [style.top.px]="modalWindowService.editorY"
  >
    <div class="draggable-modal-window-navbar" (mousedown)="startDrag($event)">
      <span [style.flex]="1">{{ header }}</span>
      <div class="close-button" (click)="model.showDraggableModalWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content-container">
      <embed-text-editor *ngIf="modalWindowService.isTextEditor"></embed-text-editor>
      <embed-image-editor *ngIf="modalWindowService.isImageEditor"></embed-image-editor>
    </div>
    <div class="setup-accept">
      <div class="accept button" (click)="accept()">
        <span [style.margin-left.px]="0">{{ loc.getP("Insert").replace("&amp", "").replace(";", "") }}</span>
      </div>
      <div class="cancel button" (click)="model.showDraggableModalWindow = false">
        <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div> `, isInline: true, styles: [".draggable-modal-window-container{background-color:var(--back-color);position:absolute;left:calc(50% - 400px);top:calc(50% - 255px);z-index:999;width:800px;height:510px;overflow:hidden;display:flex;flex-direction:column;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:12px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.draggable-modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.draggable-modal-window-navbar span{font-size:13px;margin-left:10px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content-container{height:100%;width:100%}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiEmbedTextEditorComponent, selector: "embed-text-editor" }, { kind: "component", type: i8.StiEmbedImageEditorComponent, selector: "embed-image-editor" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDraggableModalWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-draggable-modal-window", template: `<div
    class="draggable-modal-window-container"
    [style.left.px]="modalWindowService.editorX"
    [style.top.px]="modalWindowService.editorY"
  >
    <div class="draggable-modal-window-navbar" (mousedown)="startDrag($event)">
      <span [style.flex]="1">{{ header }}</span>
      <div class="close-button" (click)="model.showDraggableModalWindow = false">
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="content-container">
      <embed-text-editor *ngIf="modalWindowService.isTextEditor"></embed-text-editor>
      <embed-image-editor *ngIf="modalWindowService.isImageEditor"></embed-image-editor>
    </div>
    <div class="setup-accept">
      <div class="accept button" (click)="accept()">
        <span [style.margin-left.px]="0">{{ loc.getP("Insert").replace("&amp", "").replace(";", "") }}</span>
      </div>
      <div class="cancel button" (click)="model.showDraggableModalWindow = false">
        <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
      </div>
    </div>
  </div> `, styles: [".draggable-modal-window-container{background-color:var(--back-color);position:absolute;left:calc(50% - 400px);top:calc(50% - 255px);z-index:999;width:800px;height:510px;overflow:hidden;display:flex;flex-direction:column;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:12px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.draggable-modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.draggable-modal-window-navbar span{font-size:13px;margin-left:10px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.content-container{height:100%;width:100%}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiDraggableModalWindowService }, { type: i4.SignatureService }, { type: i5.StiMouseService }] });
//# sourceMappingURL=data:application/json;base64,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