import { Component, Input } from "@angular/core";
import { Subject } from "rxjs";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiDraggableService } from "../services/sti-draggable.service";
import { StiLabelAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-draggable.service";
import * as i3 from "../services/mouse.service";
import * as i4 from "../services/sti-helper.service";
import * as i5 from "../services/sti-name.service";
import * as i6 from "../services/sti-component-resizer.service";
import * as i7 from "../services/sti-signature.service";
import * as i8 from "@angular/common";
import * as i9 from "./sti-component-resizer.component";
import * as i10 from "./sti-corner-radius.component";
export class StiComponent {
    constructor(model, draggableService, mouseService, helper, nameService, resizer, signatureService) {
        this.model = model;
        this.draggableService = draggableService;
        this.mouseService = mouseService;
        this.helper = helper;
        this.nameService = nameService;
        this.resizer = resizer;
        this.signatureService = signatureService;
        this.isClone = false;
        this.subject = new Subject();
        this.hover = false;
        this.canDrag = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
        this.needToSelectedSubscription?.unsubscribe();
    }
    get borderInnerWidth() {
        return (Number(this.borderArea?.width) +
            Number(this.borderArea?.border?.pen.width) +
            (this.element.label.alignment == StiLabelAlignment.Top ? this.element.padding.left : 0) +
            this.element.padding.right);
    }
    get borderInnerHeight() {
        return (Number(this.borderArea?.height) +
            Number(this.borderArea?.border?.pen.width) +
            (this.element.label.alignment != StiLabelAlignment.Top
                ? this.element.padding.bottom + this.element.padding.top
                : 0));
    }
    haveAreaContainer() {
        return this.borderArea && (this.element instanceof StiPanelElement || this.element instanceof StiImageElement)
            ? this.element instanceof StiPanelElement && !this.element.isAdded
                ? false
                : true
            : false;
    }
    get overflow() {
        return this.element instanceof StiTableElement ||
            this.element instanceof StiLabelElement ||
            this.element instanceof StiTextElement ||
            this.element instanceof StiImageElement ||
            this.element instanceof StiPanelElement
            ? ""
            : "hidden";
    }
    get className() {
        return "sti-component " + this.class;
    }
    get direction() {
        return this.element?.label?.alignment == StiLabelAlignment.Top || this.element instanceof StiButtonElement
            ? "column"
            : "row";
    }
    get computedX() {
        if (this.isClone) {
            return 0;
        }
        else {
            return (this.element.x +
                (this.model.getElementPage(this.element) ? this.model.getElementPage(this.element).padding.left : 0));
        }
    }
    get cursor() {
        return !this.model.previewMode ? this.model.cursor : "default";
    }
    get computedY() {
        if (this.isClone) {
            return 0;
        }
        else {
            return Number((this.element.y +
                (this.model.getElementPage(this.element) ? this.model.getElementPage(this.element).padding.top : 0)).toFixed(3));
        }
    }
    get width() {
        if (this.isClone) {
            return "auto";
        }
        else {
            return Number(this.element.width) + "px";
        }
    }
    get height() {
        //
        if (this.isClone || (this.model.draggingElement == this.element && this.draggableService.newElement)) {
            return "auto";
        }
        else {
            return Number(this.element.height) + "px";
        }
    }
    get position() {
        if (this.isClone) {
            return "relative";
        }
        else {
            return this.element?.position;
        }
    }
    get align() {
        return this.element instanceof StiButtonElement ? "center" : "normal";
    }
    getMessage() {
        return this.subject.asObservable();
    }
    withoutBorder() {
        if (this.model.selectedComponent?.element["border"] &&
            !(this.model.selectedComponent?.element instanceof StiTableElement) &&
            (this.model.selectedComponent?.element["border"]["drawLeft"] ||
                this.model.selectedComponent?.element["border"]["drawTop"] ||
                this.model.selectedComponent?.element["border"]["drawRight"] ||
                this.model.selectedComponent?.element["border"]["drawBottom"]) &&
            this.model.selectedComponent?.element["border"]["pen"]["color"]["a"] > 0) {
            return false;
        }
        else {
            return true;
        }
    }
    onMouseMove(event) {
        if (this.model.draggingElement) {
            return;
        }
        if (event.ctrlKey &&
            this.canDrag &&
            this.model.canDrag &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            let copy = this.helper.clone(this.element);
            copy.name = this.nameService.getElementName(copy);
            this.draggableService.startDrag(event, copy, false, true);
            this.canDrag = false;
        }
        else if (this.canDrag &&
            this.model.canDrag &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            this.draggableService.startDrag(event, this.element, false, false, this.layerX, this.layerY, this.elementPage);
            this.canDrag = false;
        }
    }
    onMouseDown(event) {
        this.signatureService.drawingMode = false;
        event.stopPropagation();
        if (!this.model.previewMode && event.button == 0) {
            let form = document.querySelector("stimulsoft-forms");
            form?.classList.add("unselectable");
            if (!event["fromEditableContent"]) {
                this.mouseDownX = event.clientX;
                this.mouseDownY = event.clientY;
                this.canDrag = true;
            }
            else {
            }
            this.model.lastFormState = this.model.form.saveToJsonObject().serialize();
            if (this.model.selectedComponent != this) {
                this.model.previousSelectedComponent = this.model.selectedComponent;
                this.model.selectedComponent = this;
            }
            this.elementPage = this.model.getElementPage(this.element);
            let pos = this.model.getMouseOverPagePosition(event);
            let geometry = this.element.getOverPageGeometry(this.model.form);
            this.layerY = pos?.y - geometry.y * this.model.zoom;
            this.layerX = pos?.x - geometry.x * this.model.zoom;
        }
        else if (!this.model.previewMode && event.button != 0) {
            if (this.model.selectedComponent != this) {
                this.model.previousSelectedComponent = this.model.selectedComponent;
                this.model.selectedComponent = this;
            }
        }
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.canDrag = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
        this.needToSelectedSubscription = this.model.needToSelectedComponent.subscribe((element) => {
            if (!this.isClone && element == this.element) {
                this.model.selectedComponent = this;
            }
        });
        setTimeout(() => {
            if (!this.isClone) {
                if (this.element.needToSelectComponent) {
                    this.model.selectedComponent = this;
                    this.element.needToSelectComponent = false;
                }
            }
        }, 0);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiDraggableService }, { token: i3.StiMouseService }, { token: i4.StiHelperService }, { token: i5.StiNameService }, { token: i6.StiComponentResizerService }, { token: i7.SignatureService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiComponent, selector: "sti-component", inputs: { element: "element", class: "class", isClone: "isClone", borderArea: "borderArea" }, ngImport: i0, template: `
    <div
      draggable="false"
      [id]="element?.guid"
      [class]="className"
      [style.left.px]="computedX"
      [style.top.px]="computedY"
      [style.width]="width"
      [style.height]="height"
      [style.position]="position"
      [style.overflow]="overflow"
      [style.display]="'flex'"
      [style.flex-direction]="direction"
      [style.align-items]="align"
      [style.cursor]="cursor"
      [style.transition]="
        element?.position == 'absolute' && resizer.element != element
          ? 'top 0.1s ease 0s,left 0.1s ease 0s,border-color 0.1s ease 0s'
          : ''
      "
      [style.padding-left.px]="element?.padding.left"
      [style.padding-right.px]="element?.padding.right"
      [style.padding-top.px]="element?.padding.top"
      [style.padding-bottom.px]="element?.padding.bottom"
      [style.visibility]="!element?.visible && this.model.previewMode ? 'hidden' : 'visible'"
      (mousedown)="onMouseDown($event)"
      (mouseenter)="this.hover = true; this.model.cursor = 'move'"
      (mouseleave)="this.hover = false; this.model.cursor = 'default'"
      (dragstart)="$event.preventDefault()"
    >
      <ng-content></ng-content>
      <sti-corner-radius-component
        [style.position]="'absolute'"
        [style.pointer-events]="'none'"
        [style.width]="width"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        *ngIf="model.showCornerRadius && !model.previewMode && element != model.draggingElement"
      ></sti-corner-radius-component>
      <div
        *ngIf="withoutBorder()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width]="width"
        [style.transition]="'opacity 0.2s ease, border-color 0.2s ease'"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        [style.border-color]="
          model.selectedComponent == this && !model.previewMode && element?.position == 'absolute'
            ? 'rgb(146, 146, 146, 0.35)'
            : 'rgba(213, 213, 213, 0.35)'
        "
        [style.opacity]="
          (model.selectedComponent == this && !model.previewMode && element?.position == 'absolute') ||
          (hover && !model.previewMode && element?.position == 'absolute')
            ? 1
            : 0
        "
      ></div>
      <div
        *ngIf="haveAreaContainer()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width.px]="borderInnerWidth"
        [style.height.px]="borderInnerHeight"
        [style.left.px]="borderArea?.left - borderArea?.border?.pen.width / 2"
        [style.top.px]="borderArea?.top - borderArea?.border?.pen.width / 2"
        [style.border-top]="borderArea?.border.drawTop ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-left]="borderArea?.border.drawLeft ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-right]="borderArea?.border.drawRight ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-bottom]="borderArea?.border.drawBottom ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
      ></div>
      <i *ngIf="!element?.visible" class="pi pi-eye-slash" style="opacity: 0.3;"></i>
    </div>
    <sti-component-resizer
      [component]="this"
      [left]="computedX + element.width"
      [top]="computedY + element.height"
    ></sti-component-resizer>
    <style>
      .sti-component {
        width: 100%;
        font-size: 1px;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        position: relative;
        padding: 10px;
        z-index: 11;
      }

      .sti-component i {
        position: absolute;
        right: 5px;
        top: 5px;
      }
    </style>
  `, isInline: true, styles: ["\n      .sti-component {\n        width: 100%;\n        font-size: 1px;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        position: relative;\n        padding: 10px;\n        z-index: 11;\n      }\n\n      .sti-component i {\n        position: absolute;\n        right: 5px;\n        top: 5px;\n      }\n    "], dependencies: [{ kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.StiComponentResizerComponent, selector: "sti-component-resizer", inputs: ["left", "top", "size", "component"] }, { kind: "component", type: i10.StiCornerRadiusComponent, selector: "sti-corner-radius-component" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-component",
                    template: `
    <div
      draggable="false"
      [id]="element?.guid"
      [class]="className"
      [style.left.px]="computedX"
      [style.top.px]="computedY"
      [style.width]="width"
      [style.height]="height"
      [style.position]="position"
      [style.overflow]="overflow"
      [style.display]="'flex'"
      [style.flex-direction]="direction"
      [style.align-items]="align"
      [style.cursor]="cursor"
      [style.transition]="
        element?.position == 'absolute' && resizer.element != element
          ? 'top 0.1s ease 0s,left 0.1s ease 0s,border-color 0.1s ease 0s'
          : ''
      "
      [style.padding-left.px]="element?.padding.left"
      [style.padding-right.px]="element?.padding.right"
      [style.padding-top.px]="element?.padding.top"
      [style.padding-bottom.px]="element?.padding.bottom"
      [style.visibility]="!element?.visible && this.model.previewMode ? 'hidden' : 'visible'"
      (mousedown)="onMouseDown($event)"
      (mouseenter)="this.hover = true; this.model.cursor = 'move'"
      (mouseleave)="this.hover = false; this.model.cursor = 'default'"
      (dragstart)="$event.preventDefault()"
    >
      <ng-content></ng-content>
      <sti-corner-radius-component
        [style.position]="'absolute'"
        [style.pointer-events]="'none'"
        [style.width]="width"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        *ngIf="model.showCornerRadius && !model.previewMode && element != model.draggingElement"
      ></sti-corner-radius-component>
      <div
        *ngIf="withoutBorder()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width]="width"
        [style.transition]="'opacity 0.2s ease, border-color 0.2s ease'"
        [style.height]="height"
        [style.left.px]="0"
        [style.top.px]="0"
        [style.border-color]="
          model.selectedComponent == this && !model.previewMode && element?.position == 'absolute'
            ? 'rgb(146, 146, 146, 0.35)'
            : 'rgba(213, 213, 213, 0.35)'
        "
        [style.opacity]="
          (model.selectedComponent == this && !model.previewMode && element?.position == 'absolute') ||
          (hover && !model.previewMode && element?.position == 'absolute')
            ? 1
            : 0
        "
      ></div>
      <div
        *ngIf="haveAreaContainer()"
        style="position: absolute; border: 1px solid rgb(126, 180, 234); pointer-events: none"
        [style.width.px]="borderInnerWidth"
        [style.height.px]="borderInnerHeight"
        [style.left.px]="borderArea?.left - borderArea?.border?.pen.width / 2"
        [style.top.px]="borderArea?.top - borderArea?.border?.pen.width / 2"
        [style.border-top]="borderArea?.border.drawTop ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-left]="borderArea?.border.drawLeft ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-right]="borderArea?.border.drawRight ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
        [style.border-bottom]="borderArea?.border.drawBottom ? borderArea?.border.pen.toHtmlBorder() : 'transparent'"
      ></div>
      <i *ngIf="!element?.visible" class="pi pi-eye-slash" style="opacity: 0.3;"></i>
    </div>
    <sti-component-resizer
      [component]="this"
      [left]="computedX + element.width"
      [top]="computedY + element.height"
    ></sti-component-resizer>
    <style>
      .sti-component {
        width: 100%;
        font-size: 1px;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        position: relative;
        padding: 10px;
        z-index: 11;
      }

      .sti-component i {
        position: absolute;
        right: 5px;
        top: 5px;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiDraggableService }, { type: i3.StiMouseService }, { type: i4.StiHelperService }, { type: i5.StiNameService }, { type: i6.StiComponentResizerService }, { type: i7.SignatureService }], propDecorators: { element: [{
                type: Input
            }], class: [{
                type: Input
            }], isClone: [{
                type: Input
            }], borderArea: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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