import { Component } from "@angular/core";
import { StiTableElement } from "../../../../../elements/StiTableElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/sti-localization.service";
import * as i2 from "../../../../../services/model.service";
export class TableNavigationComponent {
    constructor(loc, model) {
        this.loc = loc;
        this.model = model;
        model.currentTablePropertyHeader.subscribe((header) => {
            this.model.currentTableHeader = header;
        });
    }
    setTablePropertyHeader(header) {
        this.model.currentTableHeader = header;
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            if (header == "Columns") {
                this.model.selectedComponent.element.showColumnsEditor = true;
            }
            else if (header == "Rows") {
                this.model.selectedComponent.element.showRowsEditor = true;
            }
            else if (header == "Totals") {
                this.model.selectedComponent.element.showTotalsEditor = true;
            }
            else {
                this.model.selectedComponent.element.showHeaderEditor = true;
            }
        }
        this.model.needToRefresh.next(true);
    }
    getClass(header) {
        return this.model.currentTableHeader == header ? "current" : "other";
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TableNavigationComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: TableNavigationComponent, selector: "table-navigation", ngImport: i0, template: `
    <div class="table-property-header">
      <a (click)="setTablePropertyHeader('Main')"
        ><span [class]="getClass('Main')">{{ loc.get2("FormOptions", "Main") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Columns')"
        ><span [class]="getClass('Columns')">{{ loc.getP("Columns") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Rows')"
        ><span [class]="getClass('Rows')">{{ loc.getP("Rows") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Totals')"
        ><span [class]="getClass('Totals')" (click)="setTablePropertyHeader('Totals')">{{
          loc.getP("Totals")
        }}</span></a
      >
    </div>
  `, isInline: true, styles: [".table-property-header{display:flex;height:30px;align-items:center;background-color:var(--back-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;font-family:Segoe UI;font-size:13px}a span{height:100%;padding:6px 3px 3px;align-items:center;justify-items:center}.table-property-header a{height:100%;width:100%;text-decoration:none;text-align:center;font-size:13px;cursor:default;display:flex;align-items:center;justify-content:center}.table-property-header a:hover{background-color:var(--hover-color)}a:hover span{width:100%}.current{color:var(--text-color);font-weight:700;border-bottom:2px solid rgb(42,115,197)}.other{color:var(--text-color)}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TableNavigationComponent, decorators: [{
            type: Component,
            args: [{ selector: "table-navigation", template: `
    <div class="table-property-header">
      <a (click)="setTablePropertyHeader('Main')"
        ><span [class]="getClass('Main')">{{ loc.get2("FormOptions", "Main") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Columns')"
        ><span [class]="getClass('Columns')">{{ loc.getP("Columns") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Rows')"
        ><span [class]="getClass('Rows')">{{ loc.getP("Rows") }}</span></a
      >
      <a (click)="setTablePropertyHeader('Totals')"
        ><span [class]="getClass('Totals')" (click)="setTablePropertyHeader('Totals')">{{
          loc.getP("Totals")
        }}</span></a
      >
    </div>
  `, styles: [".table-property-header{display:flex;height:30px;align-items:center;background-color:var(--back-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;font-family:Segoe UI;font-size:13px}a span{height:100%;padding:6px 3px 3px;align-items:center;justify-items:center}.table-property-header a{height:100%;width:100%;text-decoration:none;text-align:center;font-size:13px;cursor:default;display:flex;align-items:center;justify-content:center}.table-property-header a:hover{background-color:var(--hover-color)}a:hover span{width:100%}.current{color:var(--text-color);font-weight:700;border-bottom:2px solid rgb(42,115,197)}.other{color:var(--text-color)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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