import { Component, Input } from "@angular/core";
import StiInnerBorder from "../../../../../properties/StiInnerBorder";
import { StiBorder } from "../../../../../properties/StiBorder";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../../../sti-tooltip/sti-tooltip.directive";
export class StiBorderSidesEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
    }
    get borderAlignments() {
        let alignments = this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
        return alignments.values;
    }
    set borderAlignments(value) {
        this.helper.getProperty(this.model.selectedComponent.element, this.property.property).addValues(value);
    }
    setAll() {
        if (this.object instanceof StiBorder) {
            this.object.drawTop = true;
            this.object.drawLeft = true;
            this.object.drawBottom = true;
            this.object.drawRight = true;
        }
        else if (this.object instanceof StiInnerBorder) {
            this.object.drawHorizontal = true;
            this.object.drawVertical = true;
        }
    }
    setNone() {
        if (this.object instanceof StiBorder) {
            this.object.drawTop = false;
            this.object.drawLeft = false;
            this.object.drawBottom = false;
            this.object.drawRight = false;
        }
        else if (this.object instanceof StiInnerBorder) {
            this.object.drawHorizontal = false;
            this.object.drawVertical = false;
        }
    }
    changeState(value) {
        this.object[value] = !this.object[value];
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBorderSidesEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiBorderSidesEditorComponent, selector: "sti-border-sides-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                object.drawTop && object.drawLeft && object.drawBottom && object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !object.drawTop && !object.drawLeft && !object.drawBottom && !object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ object.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ object.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ object.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ object.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
        <td colspan="7" *ngIf="property.property == 'gridLines'">
          <div class="button-group">
            <div
              class="button {{ object.drawHorizontal && object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('GridAll')" alt="" />
            </div>
            <div
              class="button {{ !object.drawHorizontal && !object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('GridNone')" alt="" />
            </div>
            <div
              class="button {{ object.drawHorizontal ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationHorizontal')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawHorizontal')"
            >
              <img [src]="theme.getIcon('Horizontal')" alt="" />
            </div>
            <div
              class="button {{ object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationVertical')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawVertical')"
            >
              <img [src]="theme.getIcon('Vertical')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
      .draw-grid-all {
        background: var(--gridAll-icon);
      }
      .draw-grid-none {
        background: var(--gridNone-icon);
      }
      .draw-horizontal {
        background: var(--gridHorizontal-icon);
      }
      .draw-vertical {
        background: var(--gridVertical-icon);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        text-align: end;\n      }\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .active {\n        background-color: var(--active-color) !important;\n      }\n      .active:hover {\n        background-color: var(--active-color) !important;\n      }\n      .button-group {\n        display: flex;\n        width: 100%;\n        flex-direction: row;\n        justify-content: start;\n      }\n      .button {\n        height: 22px;\n        width: 28px;\n        background-color: var(--back-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n      .button img {\n        height: 16px;\n        width: 16px;\n      }\n      .button:hover {\n        background-color: var(--hover-color);\n      }\n      .button:active {\n        background-color: var(--active-color);\n      }\n      .draw-grid-all {\n        background: var(--gridAll-icon);\n      }\n      .draw-grid-none {\n        background: var(--gridNone-icon);\n      }\n      .draw-horizontal {\n        background: var(--gridHorizontal-icon);\n      }\n      .draw-vertical {\n        background: var(--gridVertical-icon);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBorderSidesEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-border-sides-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                object.drawTop && object.drawLeft && object.drawBottom && object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !object.drawTop && !object.drawLeft && !object.drawBottom && !object.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ object.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ object.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ object.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ object.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
        <td colspan="7" *ngIf="property.property == 'gridLines'">
          <div class="button-group">
            <div
              class="button {{ object.drawHorizontal && object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('GridAll')" alt="" />
            </div>
            <div
              class="button {{ !object.drawHorizontal && !object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('GridNone')" alt="" />
            </div>
            <div
              class="button {{ object.drawHorizontal ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationHorizontal')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawHorizontal')"
            >
              <img [src]="theme.getIcon('Horizontal')" alt="" />
            </div>
            <div
              class="button {{ object.drawVertical ? 'active' : '' }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'StiOrientationVertical')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawVertical')"
            >
              <img [src]="theme.getIcon('Vertical')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
      .draw-grid-all {
        background: var(--gridAll-icon);
      }
      .draw-grid-none {
        background: var(--gridNone-icon);
      }
      .draw-horizontal {
        background: var(--gridHorizontal-icon);
      }
      .draw-vertical {
        background: var(--gridVertical-icon);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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