import { Component, Input } from "@angular/core";
import { StiLabelElement } from "../../../../elements/StiLabelElement";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiTotalsFieldItem } from "../../../../elements/table/StiTotalsFieldItem";
import { StiSingleSelectionElement } from "../../../../elements/StiSingleSelectionElement";
import { StiMultipleSelectionElement } from "../../../../elements/StiMultipleSelectionElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-expression.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
import * as i7 from "../../../../directives/sti-input-text.directive";
import * as i8 from "../../../sti-tooltip/sti-tooltip.directive";
export class StiTextEditorComponent {
    constructor(model, helper, theme, expressionService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.expressionService = expressionService;
    }
    ngOnInit() { }
    get haveExpression() {
        return (this.model.selectedComponent?.element instanceof StiLabelElement &&
            this.property.property == "text.value") ||
            (this.model.selectedComponent?.element instanceof StiTableElement && this.property.property == "expression")
            ? true
            : false;
    }
    setInfo() {
        if (this.object instanceof StiLabelElement) {
            this.model.currentExpressionInfo = 3;
        }
        else if (this.object instanceof StiTotalsFieldItem) {
            this.model.currentExpressionInfo = 2;
        }
        else {
            this.model.currentExpressionInfo = 1;
        }
        this.expressionService.currentSelectedObject = this.object;
        this.model.showExpressionEditor = true;
    }
    get content() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    set content(value) {
        if (this.property.property == "customOptionText") {
            if (this.object instanceof StiSingleSelectionElement) {
                if (this.object.selectedOption == this.object.customOptionText) {
                    this.object.selectedOption = value;
                }
            }
            else if (this.object instanceof StiMultipleSelectionElement) {
                if (this.object.selectedOptions.indexOf(this.object?.customOptionText) >= 0) {
                    this.object.selectedOptions?.forEach((option) => {
                        if (this.object.options?.indexOf(option) == -1) {
                            this.object.selectedOptions?.splice(this.object.selectedOptions.indexOf(option), 1);
                        }
                    });
                    this.object.selectedOptions.push(value);
                }
            }
        }
        this.helper.setProperty(this.object, this.property.property, value);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTextEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiExpressionService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTextEditorComponent, selector: "sti-text-editor", inputs: { property: "property", object: "object", disabled: "disabled" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property != 'font' && content?.length >= 0">
        <td colspan="7" [style.width]="'100%'">
          <input
            type="text"
            stiInputText
            [stiTooltip]="property.tooltip"
            [(ngModel)]="content"
            class="{{ disabled ? 'disabled' : '' }}"
            spellcheck="false"
            [style]="{ width: '100%' }"
            [attr.maxLength]="
              property.property == 'this' && this.model.selectedComponent.element.maximum
                ? this.model.selectedComponent.element.maximum
                : null
            "
          />
        </td>
        <td *ngIf="haveExpression">
          <div class="expression-image" (click)="setInfo()">
            <img [src]="model.getImage('images.Properties.Expression.png')" />
          </div>
        </td>
      </tr>
    </table>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      td {
        padding: 0;
      }
      .disabled {
        background-color: lightgray;
        pointer-events: none;
      }
      .expression-image {
        height: 23.6px;
        width: 23.6px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        margin-left: 3px;
        margin-right: 0px;
        float: right;
      }
      img {
        height: 16px;
        width: 16px;
      }
      .expression-image:hover {
        background-color: var(--hover-color);
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      td {\n        padding: 0;\n      }\n      .disabled {\n        background-color: lightgray;\n        pointer-events: none;\n      }\n      .expression-image {\n        height: 23.6px;\n        width: 23.6px;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        border: 1px solid var(--inputBorder-color);\n        border-radius: 3px;\n        margin-left: 3px;\n        margin-right: 0px;\n        float: right;\n      }\n      img {\n        height: 16px;\n        width: 16px;\n      }\n      .expression-image:hover {\n        background-color: var(--hover-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i7.StiInputTextDirective, selector: "[stiInputText]" }, { kind: "directive", type: i8.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTextEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-text-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property != 'font' && content?.length >= 0">
        <td colspan="7" [style.width]="'100%'">
          <input
            type="text"
            stiInputText
            [stiTooltip]="property.tooltip"
            [(ngModel)]="content"
            class="{{ disabled ? 'disabled' : '' }}"
            spellcheck="false"
            [style]="{ width: '100%' }"
            [attr.maxLength]="
              property.property == 'this' && this.model.selectedComponent.element.maximum
                ? this.model.selectedComponent.element.maximum
                : null
            "
          />
        </td>
        <td *ngIf="haveExpression">
          <div class="expression-image" (click)="setInfo()">
            <img [src]="model.getImage('images.Properties.Expression.png')" />
          </div>
        </td>
      </tr>
    </table>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      td {
        padding: 0;
      }
      .disabled {
        background-color: lightgray;
        pointer-events: none;
      }
      .expression-image {
        height: 23.6px;
        width: 23.6px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        margin-left: 3px;
        margin-right: 0px;
        float: right;
      }
      img {
        height: 16px;
        width: 16px;
      }
      .expression-image:hover {
        background-color: var(--hover-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiExpressionService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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