import { Component, Input } from "@angular/core";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiColumnItem } from "../../../../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../../../../elements/table/StiTotalsFieldItem";
import { StiLocalizationService } from "../../../../services/sti-localization.service";
import { Enum } from "../../../../system/Enum";
import { HatchStyle, StiAlgorithmExpression, StiBarcodeType, StiButtonSendType, StiButtonType, StiDateTimeBoxType, StiDateTimeBoxValueChoise, StiLineWeight, StiNumberType, StiNumberRangeFormat, StiPenStyle, StiSignatureType, StiThousandSeparator, StiUnitAlignment, } from "../../../../system/enums";
import { StiStaticHelperService } from "../../../../services/sti-static-helper.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../sti-dropdown-editor/sti-dropdown-editor.component";
export class StiEnumEditorComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        this.items = [];
        this.today = new Date();
    }
    get columns() {
        let items = [];
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            this.model.selectedComponent.element.columns.forEach((column, index) => {
                items.push({ name: column.label, value: index + 1 });
            });
        }
        if (this.items.length != items.length || !this.items.every((val, index) => val.name === items[index].name)) {
            this.items = items;
        }
        return this.items;
    }
    mouseOver(target) {
        if (this.property.property == "dateFormat" ||
            this.property.property == "timeFormat" ||
            this.property.property == "dateTimeFormat") {
            target.style.backgroundColor = "var(--input-color)";
            target.parentElement.style.backgroundColor = "var(--input-color)";
        }
    }
    formattedDateTime() {
        return StiStaticHelperService.formatDate(this.today, this.type, this.model.form.settings.culture);
    }
    get columnIndex() {
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            return this.object.calculationAlgorithm.columntIndex;
        }
        return 0;
    }
    set columnIndex(value) {
        this.object.calculationAlgorithm.columntIndex = value;
    }
    get type() {
        if (this.property.property === "valueType") {
            return StiDateTimeBoxType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "signatureType") {
            return StiSignatureType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "initialState") {
            return StiDateTimeBoxValueChoise[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "rangeFormat") {
            return StiNumberRangeFormat[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "numberType") {
            return StiNumberType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "buttonType") {
            return StiButtonType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "buttonSendType") {
            return StiButtonSendType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "thousandSeparator") {
            return StiThousandSeparator[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "barcodeType") {
            return StiBarcodeType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "style") {
            return StiPenStyle[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "type") {
            return this.object.type.split("").reverse().slice(6, this.object.type.length).reverse().join("");
        }
        else if (this.property.property === "currency") {
            return (this.helper.getProperty(this.object, this.property.property) ??
                this.helper.getProperty(this.model.form.settings, this.property.property));
        }
        else if (this.property.property === "currentSignatureMode" || this.property.property === "specialFont") {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            return StiAlgorithmExpression[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "dateFormat" || this.property.property === "timeFormat" || this.property.property === "culture") {
            return this.helper.getProperty(this.object ?? this.model.form.settings, this.property.property);
        }
        else if (this.property.property === "dateTimeFormat") {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else if (this.property.property === "innerText.borderWeight") {
            return StiLineWeight[this.model.form.settings.innerText.borderWeight];
        }
        else if (this.property.property === "unitAlignment") {
            return this.helper.getProperty(this.object, this.property.property) ?? this.model.form.settings.unitAlignment;
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else {
            return StiLineWeight[this.model.selectedComponent.element[this.property.property]];
        }
    }
    set type(value) {
        if (this.property.property === "valueType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiDateTimeBoxType, value);
        }
        else if (this.property.property === "signatureType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiSignatureType, value);
        }
        else if (this.property.property === "initialState") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiDateTimeBoxValueChoise, value);
        }
        else if (this.property.property === "rangeFormat") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiNumberRangeFormat, value));
        }
        else if (this.property.property === "numberType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiNumberType, value));
            if (this.object instanceof StiColumnItem) {
                this.model.needToRefreshInnerProperties.next(true);
            }
            else {
                this.model.needToRefresh.next(true);
            }
        }
        else if (this.property.property === "buttonType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiButtonType, value);
        }
        else if (this.property.property === "buttonSendType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiButtonSendType, value);
        }
        else if (this.property.property === "thousandSeparator") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiThousandSeparator, value));
        }
        else if (this.property.property === "barcodeType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiBarcodeType, value);
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(HatchStyle, value));
            this.model.needToRefreshInnerProperties.next(true);
        }
        else if (this.property.property === "style") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiPenStyle, value));
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            if (this.type != value && this.model.selectedComponent.element instanceof StiTableElement) {
                let slicedField = this.model.selectedComponent.element.totalsFields.splice(this.index, 1);
                this.model.selectedComponent.element.totalsFields.splice(this.index, 0, new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "New Field"), "", this.model.form));
                this.setProperties(this.model.selectedComponent.element.totalsFields[this.index], slicedField[0], value);
            }
        }
        else if (this.property.property === "currency") {
            if (this.model.selectedComponent) {
                this.helper.setProperty(this.object, this.property.property, value);
            }
            else {
                this.model.form.settings.currency = value;
            }
        }
        else if (this.property.property === "currentSignatureMode" || this.property.property === "specialFont") {
            this.helper.setProperty(this.object, this.property.property, value);
        }
        else if (this.property.property === "type") {
            if (this.type != value && this.model.selectedComponent.element instanceof StiTableElement) {
                let table = this.model.selectedComponent.element;
                let slicedColumn = table.columns.splice(this.index, 1)[0];
                table.columns.splice(this.index, 0, table.createColumn(value, slicedColumn.label, slicedColumn));
            }
        }
        else if (this.property.property === "dateFormat" || this.property.property === "timeFormat" || this.property.property === "culture") {
            this.helper.setProperty(this.object ?? this.model.form.settings, this.property.property, value);
            this.model.formEvents.next({ name: "ValueChanged" });
        }
        else if (this.property.property === "dateTimeFormat") {
            this.helper.setProperty(this.object, this.property.property, value);
            this.model.formEvents.next({ name: "ValueChanged" });
        }
        else if (this.property.property === "innerText.borderWeight") {
            this.model.form.settings.innerText.borderWeight = Enum.parse(StiLineWeight, value);
        }
        else if (this.property.property === "unitAlignment") {
            if (this.object) {
                this.helper.setProperty(this.object, this.property.property, Enum.parse(StiUnitAlignment, value));
            }
            else {
                this.model.form.settings.unitAlignment = Enum.parse(StiUnitAlignment, value);
            }
            if (!(this.object instanceof StiColumnItem)) {
                this.model.needToRefresh.next(true);
            }
        }
        else {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiLineWeight, value);
        }
        if (this.property.property != "type" &&
            this.property.property != "calculationAlgorithm.expression" &&
            this.property.property != "dateTimeFormat" &&
            this.property.property != "dateFormat" &&
            this.property.property != "timeFormat" &&
            this.property.property != "thousandSeparator" &&
            this.property.property != "numberType" &&
            this.property.property != "unitAlignment" &&
            this.property.property != "currency") {
            this.model.needToRefresh.next(true);
            this.model.needToRefreshInnerProperties.next(true);
        }
    }
    get enum() {
        if (this.property.property === "valueType") {
            return this.helper.dateTimeTypes;
        }
        else if (this.property.property === "signatureType") {
            return this.helper.signatureTypes;
        }
        else if (this.property.property === "initialState") {
            return this.helper.dateTimeValues;
        }
        else if (this.property.property === "numberType") {
            return this.helper.numberTypes;
        }
        else if (this.property.property === "rangeFormat") {
            return this.helper.rangeFormats;
        }
        else if (this.property.property === "buttonType") {
            return this.helper.buttonTypes;
        }
        else if (this.property.property === "buttonSendType") {
            return this.helper.buttonSendTypes;
        }
        else if (this.property.property === "thousandSeparator") {
            return this.helper.thousandSeparators;
        }
        else if (this.property.property === "barcodeType") {
            return this.helper.barcodeTypes;
        }
        else if (this.property.property === "style") {
            return this.helper.penStyles;
        }
        else if (this.property.property === "type") {
            return this.helper.columnTypes;
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            return this.helper.algorithmExpressions;
        }
        else if (this.property.property === "currency") {
            return this.helper.currencyInfo;
        }
        else if (this.property.property === "currentSignatureMode") {
            return this.helper.signatureEditorModes;
        }
        else if (this.property.property === "specialFont") {
            return this.helper.signatureSpecialFonts;
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            return this.helper.hatchStyle;
        }
        else if (this.property.property === "dateTimeFormat") {
            return this.helper.dateTimeFormats;
        }
        else if (this.property.property === "dateFormat") {
            return this.helper.dateFormats;
        }
        else if (this.property.property === "timeFormat") {
            return this.helper.timeFormats;
        }
        else if (this.property.property === "culture") {
            return this.helper.cultures;
        }
        else if (this.property.property === "unitAlignment") {
            return this.helper.unitAlignment;
        }
        else {
            return this.helper.borderWeights;
        }
    }
    setProperties(newColumn, changedColumn, expression) {
        if ((newColumn && changedColumn) instanceof StiTotalsFieldItem) {
            newColumn.header = changedColumn.header;
            newColumn.headerAlignment = changedColumn.headerAlignment;
            newColumn.headerColor = changedColumn.headerColor;
            newColumn.expression = "0";
        }
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEnumEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiEnumEditorComponent, selector: "sti-enum-editor", inputs: { property: "property", object: "object", index: "index" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" *ngIf="property.property != 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            optionLabel="{{ property.property == 'currency' ? 'englishName' : 'name' }}"
            optionValue="{{ property.property == 'currency' ? 'code' : 'value' }}"
            [editable]="
              property.property == 'dateFormat' ||
              property.property == 'timeFormat' ||
              property.property == 'dateTimeFormat'
            "
            (mouseover)="mouseOver($event.target)"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2" *ngIf="property.property == 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="columns"
            [(value)]="columnIndex"
            optionLabel="name"
            optionValue="value"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property == 'dateFormat' ||
                 property.property == 'timeFormat' ||
                 property.property == 'dateTimeFormat'">
        <span>{{formattedDateTime()}}</span>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      span {\n        margin-left: 2px;\n        color: var(--text-color);\n        font-weight: normal;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n    "], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiEnumEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-enum-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" *ngIf="property.property != 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            optionLabel="{{ property.property == 'currency' ? 'englishName' : 'name' }}"
            optionValue="{{ property.property == 'currency' ? 'code' : 'value' }}"
            [editable]="
              property.property == 'dateFormat' ||
              property.property == 'timeFormat' ||
              property.property == 'dateTimeFormat'
            "
            (mouseover)="mouseOver($event.target)"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2" *ngIf="property.property == 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="columns"
            [(value)]="columnIndex"
            optionLabel="name"
            optionValue="value"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property == 'dateFormat' ||
                 property.property == 'timeFormat' ||
                 property.property == 'dateTimeFormat'">
        <span>{{formattedDateTime()}}</span>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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