import { Component } from "@angular/core";
import { StiBarcodeElement } from "../../../../elements/StiBarcodeElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/sti-barcode.service";
import * as i2 from "../../../../services/model.service";
import * as i3 from "@angular/common";
import * as i4 from "./sti-svg-image.component";
export class StiBarcodeStylesPreviewComponent {
    get items() {
        return this.barcodeService.barcodeStyles;
    }
    get itemsInRows() {
        let items = new Array(Math.floor((this.barcodeService.previewWidth - 10) / this.itemWidth)).fill(1);
        return items.length >= 1 ? items : new Array(1).fill(1);
    }
    get rows() {
        return new Array(Math.ceil(this.items.length / this.itemsInRows.length)).fill(2);
    }
    get currentItem() {
        return this.model.selectedComponent?.element && this.model.selectedComponent?.element instanceof StiBarcodeElement
            ? this.model.selectedComponent?.element
            : null;
    }
    constructor(barcodeService, model) {
        this.barcodeService = barcodeService;
        this.model = model;
        this.itemWidth = 57;
    }
    selectStyle(index) {
        this.currentItem.style = index;
        this.barcodeService.showBarcodePreview = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeStylesPreviewComponent, deps: [{ token: i1.StiBarcodeService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiBarcodeStylesPreviewComponent, selector: "sti-barcode-styles-preview", ngImport: i0, template: `
    <div
      #element
      class="container"
      [style.visibility]="barcodeService.showBarcodePreview ? 'visible' : 'hidden'"
      [style.left.px]="barcodeService.previewX"
      [style.top.px]="barcodeService.previewY"
      [style.width.px]="barcodeService.previewWidth ? barcodeService.previewWidth : 192"
    >
      <table class="sti-clear" [style.width]="'100%'">
        <tr *ngFor="let row of rows; index as i" class="row-container">
          <td
            *ngFor="let item of itemsInRows; index as ind"
            class="{{ items[i * itemsInRows.length + ind] ? '' : 'disabled' }} {{
              currentItem && i * itemsInRows.length + ind + 1 == currentItem.style ? 'active' : ''
            }}"
            (click)="selectStyle(i * itemsInRows.length + ind + 1)"
          >
            <sti-svg-image
              *ngIf="items[i * itemsInRows.length + ind]"
              [svg]="items[i * itemsInRows.length + ind].innerHtml"
            ></sti-svg-image>
          </td>
        </tr>
      </table>
    </div>
    <style>
      .container {
        position: absolute;
        z-index: 999;
        background-color: var(--back-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        width: 192px;
        height: 233px;
        border: 1px solid lightgray;
        border-radius: 3px;
        overflow-y: scroll;
        overflow-x: hidden;
        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);
      }
      .row-container {
        display: flex;
        width: 100%;
      }

      td {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 3px 3px 0 3px;
      }
      td:hover {
        background-color: var(--hover-color);
      }
      td:active {
        background-color: var(--active-color);
      }
      .active {
        background-color: rgb(190, 230, 253);
      }
      .disabled {
        pointer-events: none;
      }
    </style>
  `, isInline: true, styles: ["\n      .container {\n        position: absolute;\n        z-index: 999;\n        background-color: var(--back-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        width: 192px;\n        height: 233px;\n        border: 1px solid lightgray;\n        border-radius: 3px;\n        overflow-y: scroll;\n        overflow-x: hidden;\n        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);\n      }\n      .row-container {\n        display: flex;\n        width: 100%;\n      }\n\n      td {\n        flex: 1;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        padding: 3px 3px 0 3px;\n      }\n      td:hover {\n        background-color: var(--hover-color);\n      }\n      td:active {\n        background-color: var(--active-color);\n      }\n      .active {\n        background-color: rgb(190, 230, 253);\n      }\n      .disabled {\n        pointer-events: none;\n      }\n    "], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiSvgImageComponent, selector: "sti-svg-image", inputs: ["svg"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeStylesPreviewComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-barcode-styles-preview",
                    template: `
    <div
      #element
      class="container"
      [style.visibility]="barcodeService.showBarcodePreview ? 'visible' : 'hidden'"
      [style.left.px]="barcodeService.previewX"
      [style.top.px]="barcodeService.previewY"
      [style.width.px]="barcodeService.previewWidth ? barcodeService.previewWidth : 192"
    >
      <table class="sti-clear" [style.width]="'100%'">
        <tr *ngFor="let row of rows; index as i" class="row-container">
          <td
            *ngFor="let item of itemsInRows; index as ind"
            class="{{ items[i * itemsInRows.length + ind] ? '' : 'disabled' }} {{
              currentItem && i * itemsInRows.length + ind + 1 == currentItem.style ? 'active' : ''
            }}"
            (click)="selectStyle(i * itemsInRows.length + ind + 1)"
          >
            <sti-svg-image
              *ngIf="items[i * itemsInRows.length + ind]"
              [svg]="items[i * itemsInRows.length + ind].innerHtml"
            ></sti-svg-image>
          </td>
        </tr>
      </table>
    </div>
    <style>
      .container {
        position: absolute;
        z-index: 999;
        background-color: var(--back-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        width: 192px;
        height: 233px;
        border: 1px solid lightgray;
        border-radius: 3px;
        overflow-y: scroll;
        overflow-x: hidden;
        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);
      }
      .row-container {
        display: flex;
        width: 100%;
      }

      td {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 3px 3px 0 3px;
      }
      td:hover {
        background-color: var(--hover-color);
      }
      td:active {
        background-color: var(--active-color);
      }
      .active {
        background-color: rgb(190, 230, 253);
      }
      .disabled {
        pointer-events: none;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiBarcodeService }, { type: i2.StiModelService }] });
//# sourceMappingURL=data:application/json;base64,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