import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../sti-autocomplete/sti-autocomplete.component";
export class AutoCompleteEditorComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    get items() {
        return this.model.enteredUrls;
    }
    get value() {
        return this.helper.getProperty(this.obj, this.property.property);
    }
    set value(val) {
        let endValue;
        if (val.indexOf(",") != -1) {
            endValue = val.replace(/[\s,]/g, "");
        }
        this.helper.setProperty(this.obj, this.property.property, endValue ?? val);
    }
    ngOnInit() {
        if (this.value && !this.items.find((item) => item == this.value)) {
            this.model.enteredUrls.push(this.value);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AutoCompleteEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: AutoCompleteEditorComponent, selector: "auto-complete-editor", inputs: { property: "property", obj: "obj" }, viewQueries: [{ propertyName: "autoComplete", first: true, predicate: ["autoComplete"], descendants: true }], ngImport: i0, template: `<table class="sti-clear" [style]="{ width: '100%' }">
    <tr>
      <td colspan="2">
        <sti-autoComplete [(value)]="value" [items]="items"></sti-autoComplete>
      </td>
    </tr>

    <tr></tr>
  </table>`, isInline: true, styles: ["td{padding:0}\n"], dependencies: [{ kind: "component", type: i3.StiAutoCompleteComponent, selector: "sti-autoComplete", inputs: ["value", "items"], outputs: ["valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AutoCompleteEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "auto-complete-editor", template: `<table class="sti-clear" [style]="{ width: '100%' }">
    <tr>
      <td colspan="2">
        <sti-autoComplete [(value)]="value" [items]="items"></sti-autoComplete>
      </td>
    </tr>

    <tr></tr>
  </table>`, styles: ["td{padding:0}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }], propDecorators: { autoComplete: [{
                type: ViewChild,
                args: ["autoComplete"]
            }], property: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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