import { Component } from "@angular/core";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import { StiFormElement } from "../../../elements/base/StiFormElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-localization.service";
import * as i3 from "./sti-forms-tree-item.component";
export class StiFormsTreeComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
        this.value = "";
    }
    inputEvent(value) {
        this.value = value;
    }
    findElement() {
        document.activeElement.blur();
        let names = this.getAllNames();
        let resultNames = [];
        names.forEach((item) => {
            if (item.name.toLowerCase().indexOf(this.value.toLowerCase()) != -1) {
                resultNames.push(item);
            }
        });
        if (resultNames) {
            if (resultNames.findIndex((item) => item.name == this.lastFindedItem?.name) != -1) {
                let index = -1;
                if (this.lastFindedValue == this.value) {
                    index = resultNames.findIndex((item) => item.name == this.lastFindedItem?.name);
                }
                if (index + 1 < resultNames.length) {
                    this.selectItem(resultNames[index + 1]);
                    this.lastFindedItem = resultNames[index + 1];
                    this.lastFindedValue = this.value;
                }
                else {
                    this.model.showFormTreeWarningWindow = true;
                    this.model.formTreeWarningMessage = this.value;
                }
            }
            else {
                this.selectItem(resultNames[0]);
                this.lastFindedItem = resultNames[0];
                this.lastFindedValue = this.value;
            }
        }
    }
    selectItem(item) {
        if (item?.name == "Form") {
            this.model.selectedPage = null;
            this.model.selectedComponent = null;
        }
        else if (item?.element instanceof StiFormPageElement) {
            this.model.selectedPage = item.element;
        }
        else if (item?.element instanceof StiFormElement) {
            this.model.needToSelectedComponent.next(item?.element);
        }
        else {
            this.model.showFormTreeWarningWindow = true;
            this.model.formTreeWarningMessage = this.value;
        }
    }
    getAllNames() {
        let names = [];
        names.push({ name: "Form" });
        this.model.form?.pages?.forEach((page) => {
            names.push({ name: page.name, element: page });
            page.allElements.forEach((elem) => {
                names.push({ name: elem.name, element: elem });
            });
        });
        return names;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormsTreeComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFormsTreeComponent, selector: "forms-tree", ngImport: i0, template: `
    <div class="form-tree-container">
      <div class="search-container">
        <div class="search-component">
          <span class="input"
            ><input
              type="text"
              [placeholder]="loc.get2('Editor', 'Search')"
              [value]="value"
              (input)="inputEvent($event.target.value)"
              (keyup.enter)="findElement()"
            />
          </span>
          <div class="search-button" (click)="findElement()">
            <img [src]="model.getImage('images.Other.Search.png')" />
          </div>
        </div>
        <div
          class="show-components-button {{ model.showComponentsTab ? 'selected' : '' }}"
          (click)="model.showComponentsTab = !model.showComponentsTab"
        >
          <img [src]="model.getImage('images.Other.ComponentsTab.png')" />
        </div>
      </div>
      <div class="tree-items-container">
        <sti-forms-tree-item [item]="model?.form"></sti-forms-tree-item>
      </div>
    </div>
  `, isInline: true, styles: [".input{z-index:99999}input{height:22px;font-size:12px;width:100%;outline:none;border:0}.search-button{border-radius:3px;display:flex;align-items:center;justify-content:center;height:100%}.search-button:hover{cursor:pointer;background-color:var(--hover-color)}.disabled{pointer-events:none;opacity:.5}.selected{background-color:var(--hover-color)}.tree-items-container{position:relative;width:fit-content}.container-label{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:4.5px;-webkit-touch-callout:none;-webkit-user-select:none}.search-component{border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;width:100%;align-items:center;margin-left:5px;min-width:300px;position:relative}.search-component span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;padding-left:5px;font-weight:500;color:var(--text-color);flex:1}.search-container{display:flex;height:24px;width:100%;margin:5px 0}.form-tree-container{min-width:100%;display:flex;flex-direction:column}.show-components-button{height:100%;margin:0 5px;border-radius:3px}.show-components-button:hover{background-color:var(--hover-color);cursor:pointer}img{height:16px;width:16px;margin:0 4px}\n"], dependencies: [{ kind: "component", type: i3.StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: ["item", "index", "showTree"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormsTreeComponent, decorators: [{
            type: Component,
            args: [{ selector: "forms-tree", template: `
    <div class="form-tree-container">
      <div class="search-container">
        <div class="search-component">
          <span class="input"
            ><input
              type="text"
              [placeholder]="loc.get2('Editor', 'Search')"
              [value]="value"
              (input)="inputEvent($event.target.value)"
              (keyup.enter)="findElement()"
            />
          </span>
          <div class="search-button" (click)="findElement()">
            <img [src]="model.getImage('images.Other.Search.png')" />
          </div>
        </div>
        <div
          class="show-components-button {{ model.showComponentsTab ? 'selected' : '' }}"
          (click)="model.showComponentsTab = !model.showComponentsTab"
        >
          <img [src]="model.getImage('images.Other.ComponentsTab.png')" />
        </div>
      </div>
      <div class="tree-items-container">
        <sti-forms-tree-item [item]="model?.form"></sti-forms-tree-item>
      </div>
    </div>
  `, styles: [".input{z-index:99999}input{height:22px;font-size:12px;width:100%;outline:none;border:0}.search-button{border-radius:3px;display:flex;align-items:center;justify-content:center;height:100%}.search-button:hover{cursor:pointer;background-color:var(--hover-color)}.disabled{pointer-events:none;opacity:.5}.selected{background-color:var(--hover-color)}.tree-items-container{position:relative;width:fit-content}.container-label{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:4.5px;-webkit-touch-callout:none;-webkit-user-select:none}.search-component{border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;width:100%;align-items:center;margin-left:5px;min-width:300px;position:relative}.search-component span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;padding-left:5px;font-weight:500;color:var(--text-color);flex:1}.search-container{display:flex;height:24px;width:100%;margin:5px 0}.form-tree-container{min-width:100%;display:flex;flex-direction:column}.show-components-button{height:100%;margin:0 5px;border-radius:3px}.show-components-button:hover{background-color:var(--hover-color);cursor:pointer}img{height:16px;width:16px;margin:0 4px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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