import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-helper.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-property-grid-navigation/sti-property-grid-navigation.component";
import * as i7 from "./sti-forms-tree/sti-forms-tree.component";
import * as i8 from "./sti-property-grid/sti-property-grid.component";
export class PropertiesComponent {
    constructor(model, mouseService, helper, loc) {
        this.model = model;
        this.mouseService = mouseService;
        this.helper = helper;
        this.loc = loc;
        this.isDrag = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.drag(event);
        });
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag(event);
        });
    }
    onMouseDown(event) {
        event.preventDefault();
        this.startWidth = this.model.propertyGridWidth;
        this.startX = event.clientX;
        this.isDrag = true;
    }
    drag(event) {
        if (this.isDrag) {
            let delta = event.clientX - this.startX;
            if (this.startWidth - delta >= 500) {
                this.model.propertyGridWidth = 500;
            }
            else if (this.startWidth - delta <= 220) {
                this.model.propertyGridWidth = 220;
            }
            else {
                this.model.propertyGridWidth = this.startWidth - delta;
            }
        }
    }
    endDrag(event) {
        this.isDrag = false;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PropertiesComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiHelperService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: PropertiesComponent, selector: "app-properties", ngImport: i0, template: `
    <div class="property-grid-resizer" (mousedown)="onMouseDown($event)"></div>
    <div class="property-grid-container">
      <div class="property-grid-components">
        <forms-tree *ngIf="model.currentPropertyGridMode == 'Tree'"></forms-tree>
        <property-grid *ngIf="model.currentPropertyGridMode == 'Properties'"></property-grid>
      </div>
      <div class="property-grid-navigation">
        <property-grid-navigation></property-grid-navigation>
      </div>
    </div>
  `, isInline: true, styles: [".property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}.property-grid-container{display:flex;flex-direction:column;width:100%}.property-grid-components{flex:1;overflow-y:scroll;scroll-behavior:smooth}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiPropertyGridNavigationComponent, selector: "property-grid-navigation" }, { kind: "component", type: i7.StiFormsTreeComponent, selector: "forms-tree" }, { kind: "component", type: i8.StiPropertyGridComponent, selector: "property-grid" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PropertiesComponent, decorators: [{
            type: Component,
            args: [{ selector: "app-properties", template: `
    <div class="property-grid-resizer" (mousedown)="onMouseDown($event)"></div>
    <div class="property-grid-container">
      <div class="property-grid-components">
        <forms-tree *ngIf="model.currentPropertyGridMode == 'Tree'"></forms-tree>
        <property-grid *ngIf="model.currentPropertyGridMode == 'Properties'"></property-grid>
      </div>
      <div class="property-grid-navigation">
        <property-grid-navigation></property-grid-navigation>
      </div>
    </div>
  `, styles: [".property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}.property-grid-container{display:flex;flex-direction:column;width:100%}.property-grid-components{flex:1;overflow-y:scroll;scroll-behavior:smooth}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiHelperService }, { type: i4.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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