import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiTableCreator extends StiElementCreator {
    static createPropertyEditors(properties, element, model) {
        properties.push({ type: "divider" });
        properties.push({ type: "tableNavigations" });
        properties.push({ type: "divider" });
        if (element.showHeaderEditor) {
            model?.currentTablePropertyHeader.next("Main");
            properties.push({
                type: "TextEditor",
                property: "tableHeaderText",
                label: StiLocalizationService.get("PropertyMain", "Header"),
            });
            properties.push({
                type: "horizontalAlignment",
                property: "tableHeaderAlignment",
                label: "",
            });
            properties.push({
                type: "checkbox",
                property: "useWordWrap",
                checkbox: StiLocalizationService.get("PropertyEnum", "StiTextSizeModeWordWrap"),
            });
            properties.push({
                type: "color",
                property: "tableHeaderBackgroundColor",
                label: StiLocalizationService.get("PropertyMain", "BackColor"),
            });
            properties.push({
                type: "color",
                property: "tableHeaderColor",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "FontEditor",
                property: "font",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "backgroundColor",
                label: StiLocalizationService.get("PropertyMain", "BackColor"),
            });
            properties.push({ type: "BooleanWithArrowEditor", property: "showBorderEditor", label: "" });
            properties.push({ type: "BooleanWithArrowEditor", property: "showGridLinesEditor", label: "" });
            properties.push({ type: "divider" });
            properties.push({
                type: "nameEditor",
                property: "name",
                label: StiLocalizationService.get("PropertyMain", "Name"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "componentHeight",
                property: "height",
                label: StiLocalizationService.get("PropertyMain", "Height"),
            });
            properties.push({
                type: "PaddingEditor",
                property: "padding",
                label: StiLocalizationService.get("PropertyMain", "Padding"),
            });
            properties.push({
                type: "checkbox",
                property: "readOnly",
                checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
            });
            /* if (!element.readOnly) {
              properties.push({
                type: "checkbox",
                property: "dynamicRows",
                checkbox: StiLocalizationService.get("PropertyMain", "DynamicRows"),
              });
            } */
            properties.push({
                type: "checkbox",
                property: "visible",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "label.value",
                label: StiLocalizationService.get("PropertyMain", "Label"),
            });
            properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
            if (element.label.alignment != StiLabelAlignment.Top) {
                properties.push({
                    type: "Number",
                    property: "label.width",
                    label: StiLocalizationService.get("PropertyMain", "Width"),
                });
            }
            properties.push({
                type: "FontEditor",
                property: "label",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "label.color",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "description.value",
                label: StiLocalizationService.get("PropertyMain", "Description"),
            });
            properties.push({
                type: "FontEditor",
                property: "description",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "description.color",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
        }
        else if (element.showColumnsEditor) {
            model?.currentTablePropertyHeader.next("Columns");
            properties.push({ type: "BooleanWithArrowEditor", property: "showColumnsBorderEditor", label: "" });
            properties.push({ type: "divider" });
            properties.push({ type: "TableColumnsEditor", property: "columns", label: "" });
        }
        else if (element.showRowsEditor) {
            model?.currentTablePropertyHeader.next("Rows");
            properties.push({
                type: "checkbox",
                property: "showRowLabels",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "MultilineEditor",
                property: "rowLabels",
                label: StiLocalizationService.get("PropertyMain", "Labels"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "horizontalAlignment",
                property: "rowLabelsHorizontalAlignment",
                label: StiLocalizationService.get("PropertyMain", "Alignment"),
            });
            properties.push({
                type: "checkbox",
                property: "alternateRowColors",
                checkbox: StiLocalizationService.get("PropertyMain", "AlternateRowColors"),
            });
            if (!element.alternateRowColors) {
                properties.push({
                    type: "color",
                    property: "rowHeadersBackground",
                    label: StiLocalizationService.get("PropertyMain", "BackColor"),
                });
                properties.push({
                    type: "color",
                    property: "rowHeadersColor",
                    label: StiLocalizationService.get("PropertyMain", "ForeColor"),
                });
            }
            else {
                properties.push({
                    type: "color",
                    property: "evenRowsStyle",
                    label: StiLocalizationService.get("PropertyMain", "EvenRowsStyle"),
                });
                properties.push({ type: "color", property: "evenRowsTextColor", label: "" });
                properties.push({
                    type: "color",
                    property: "oddRowsStyle",
                    label: StiLocalizationService.get("PropertyMain", "OddRowsStyle"),
                });
                properties.push({ type: "color", property: "oddRowsTextColor", label: "" });
            }
            properties.push({ type: "BooleanWithArrowEditor", property: "showRowsBorderEditor", label: "" });
        }
        else if (element.showTotalsEditor) {
            model?.currentTablePropertyHeader.next("Totals");
            properties.push({
                type: "checkbox",
                property: "useTotals",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "totalsRowHeader",
                label: StiLocalizationService.get("PropertyMain", "Header"),
            });
            properties.push({ type: "horizontalAlignment", property: "totalsRowHeaderHorizontalAlignment", label: "" });
            properties.push({ type: "verticalAlignment", property: "totalsRowHeaderVerticalAlignment", label: "" });
            properties.push({ type: "color", property: "totalsRowHeaderColor", label: "" });
            properties.push({ type: "divider" });
            properties.push({ type: "TableColumnsEditor", property: "totalsFields", label: "" });
        }
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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