import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiButtonType } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiButtonCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "text.value",
            label: StiLocalizationService.get("PropertyMain", "Text"),
        });
        properties.push({
            type: "enum",
            property: "buttonType",
            label: StiLocalizationService.get("PropertyMain", "Type"),
        });
        if (element.buttonType == StiButtonType.SendForm) {
            properties.push({
                type: "autoCompleteEditor",
                property: "formSendURL",
                label: StiLocalizationService.get("PropertyMain", "URL"),
            });
            properties.push({
                type: "TextEditor",
                property: "submissionMessage",
                label: StiLocalizationService.get("PropertyMain", "SubmissionMessage"),
            });
            properties.push({
                type: "enum",
                property: "buttonSendType",
                label: StiLocalizationService.get("PropertyMain", "SendType"),
            });
        }
        properties.push({
            type: "FontEditor",
            property: "text",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "text.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({
            type: "color",
            property: "text.backgroundColor",
            label: StiLocalizationService.get("PropertyMain", "BackColor"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "nameEditor",
            property: "name",
            label: StiLocalizationService.get("PropertyMain", "Name"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "componentHeight",
            property: "height",
            label: StiLocalizationService.get("PropertyMain", "Height"),
        });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "tooltip",
            label: StiLocalizationService.get("PropertyMain", "ToolTip"),
        });
        properties.push({
            type: "checkbox",
            property: "readOnly",
            checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
        });
        properties.push({
            type: "checkbox",
            property: "visible",
            checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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