import { Component, Input, ViewChild } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-editable-content.service";
import * as i5 from "@angular/common";
import * as i6 from "../sti-page-grid-overlay.component";
import * as i7 from "../sti-pages-navigation.component";
import * as i8 from "../sti-components-holder.component";
export class PageComponent {
    get width() {
        return this.page.width + this.BORDER_WIDTH;
    }
    get height() {
        return this.page.height + this.BORDER_WIDTH;
    }
    get id() {
        return this.page.guid;
    }
    get elements() {
        return this.page.elements;
    }
    get className() {
        return ("page " +
            (this.model.selectedPage == this.page && !this.model.previewMode ? "active" : "") +
            " " +
            StiModelService.PAGE_CLASS +
            (this.componentResizerService.isResizing ? " disable-text-selection" : ""));
    }
    get backgroundImage() {
        return this.page.backgroundImage ? "url(" + this.page.backgroundImage + ")" : null;
    }
    onContainerMouseDown(event) {
        if (event.target === this.pageContainerEl.nativeElement) {
            this.model.selectedComponent = null;
        }
    }
    onMouseDown(event) {
        this.model.selectedPage = this.page;
        this.editableContent.editableContent = null;
    }
    getPageIndex() {
        return this.model.form.pages.indexOf(this.page);
    }
    get zoom() {
        return this.model.zoom;
    }
    getLeftMargin() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        if (!this.isInitialized) {
            return 0;
        }
        if (!this.previewModeIsInitialized && this.model.previewMode) {
            return 0;
        }
        let pageContainerWidth = this.page.width + (this.model.previewMode ? 0 : this.PANEL_NAVIGATION_WIDTH + this.INNER_MARGIN);
        let freeHorizontalSpace = workspace.clientWidth -
            (workspace.clientHeight < workspace.scrollHeight || this.model.previewMode
                ? 0
                : this.model.zoom < 0.5 && this.model.zoom > 0.3
                    ? window.devicePixelRatio == 1.25
                        ? 8
                        : 10
                    : 10) -
            40 -
            pageContainerWidth * this.zoom;
        let leftMargin = Math.round(freeHorizontalSpace / 2);
        return freeHorizontalSpace > 0 ? Number((leftMargin / this.zoom).toFixed(2)) : 0;
    }
    constructor(model, loc, componentResizerService, editableContent) {
        this.model = model;
        this.loc = loc;
        this.componentResizerService = componentResizerService;
        this.editableContent = editableContent;
        this.BORDER_WIDTH = 2;
        this.isInitialized = false;
        this.PANEL_NAVIGATION_WIDTH = 40;
        this.INNER_MARGIN = 10;
        this.previewModeIsInitialized = false;
    }
    ngOnDestroy() {
        this.previewModeChangesObserver?.unsubscribe();
    }
    ngDoCheck() {
        if (this.pageEl && this.page.element != this.pageEl) {
            this.page.element = this.pageEl;
        }
    }
    ngAfterViewInit() {
        this.page.element = this.pageEl;
        setTimeout(() => {
            this.isInitialized = true;
        });
    }
    ngOnInit() {
        if (this.model.previewMode && !this.previewModeIsInitialized) {
            this.previewModeIsInitialized = true;
        }
        this.previewModeChangesObserver = this.model.interfaceEvent.subscribe((event) => {
            if (event.name == "setRibbon" && event.data?.ribbon === "Preview") {
                setTimeout(() => {
                    this.previewModeIsInitialized = true;
                });
            }
            else if (event.name == "setRibbon" && event.data?.oldRibbon === "Preview") {
                this.previewModeIsInitialized = false;
            }
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiComponentResizerService }, { token: i4.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: PageComponent, selector: "app-page", inputs: { page: "page" }, viewQueries: [{ propertyName: "pageEl", first: true, predicate: ["element"], descendants: true }, { propertyName: "pageContainerEl", first: true, predicate: ["pageContainerEl"], descendants: true }], ngImport: i0, template: "<div\r\n  #pageContainerEl\r\n  class=\"page-container\"\r\n  *ngIf=\"((!page.visible || page.visible) && !model.previewMode) || (page.visible && model.previewMode)\"\r\n  [style.width.px]=\"width + (model.viewerMode || model.previewMode ? 0 : 51)\"\r\n  [style.margin-left.px]=\"getLeftMargin()\"\r\n  (mousedown)=\"onContainerMouseDown($event)\"\r\n  [style.opacity]=\"isInitialized ? 1 : 0\"\r\n>\r\n  <div\r\n    #element\r\n    class=\"page\"\r\n    id=\"Page\"\r\n    [id]=\"id\"\r\n    [style.padding-left.px]=\"page?.padding.left\"\r\n    [style.padding-right.px]=\"page?.padding.right\"\r\n    [style.padding-top.px]=\"page?.padding.top\"\r\n    [style.padding-bottom.px]=\"page?.padding.bottom\"\r\n    [style.background-color]=\"page.backgroundColor.toHtmlColor()\"\r\n    [style.overflow]=\"'hidden'\"\r\n    [style.width.px]=\"width\"\r\n    [style.height.px]=\"height\"\r\n    [class]=\"className\"\r\n    [style.background-image]=\"backgroundImage\"\r\n    [style.background-position]=\"'center'\"\r\n    [style.background-size]=\"'cover'\"\r\n    [style.background-repeat]=\"'no-repeat'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n    (mousedown)=\"onMouseDown($event)\"\r\n  >\r\n    <div *ngFor=\"let element of elements\">\r\n      <sti-component-holder [element]=\"element\"></sti-component-holder>\r\n    </div>\r\n    <sti-page-grid-overlay\r\n      *ngIf=\"model.pageWithGrid == page || (model.lastUsedPage == page && componentResizerService.isResizing)\"\r\n    ></sti-page-grid-overlay>\r\n    <div class=\"trial-title\" [style.zIndex]=\"model.previewMode ? 99999 : 0\" *ngIf=\"model.showTrialTitle\">\r\n      <span>{{ loc.getP(\"Trial\") }}</span>\r\n    </div>\r\n    <div\r\n      class=\"inline-border\"\r\n      *ngIf=\"!model.viewerMode && !model.previewMode\"\r\n      [style.left.px]=\"page.padding.left\"\r\n      [style.top.px]=\"page.padding.top\"\r\n      [style.width.px]=\"page.contentAreaWidth\"\r\n      [style.height.px]=\"page.contentAreaHeight\"\r\n    ></div>\r\n    <i *ngIf=\"!page?.visible\" class=\"pi pi-eye-slash\" style=\"opacity: 0.3\"></i>\r\n  </div>\r\n  <sti-page-navigation\r\n    *ngIf=\"page === model.selectedPage && !model.previewMode\"\r\n    [currentPage]=\"page\"\r\n    [style.visibility]=\"model.previewMode ? 'hidden' : ''\"\r\n    [style.height]=\"'100%'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n  ></sti-page-navigation>\r\n</div>\r\n<style>\r\n  .page-container {\r\n    position: relative;\r\n    display: flex;\r\n  }\r\n  .page {\r\n    position: relative;\r\n    display: block;\r\n    background: white;\r\n    font-size: 2.5rem;\r\n    color: black;\r\n    border: 1px solid #c6c6c6;\r\n    margin-right: 10px;\r\n    margin-top: 10px;\r\n    margin-bottom: 10px;\r\n  }\r\n  .inline-border {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    border: 1px solid rgb(234, 234, 234);\r\n    opacity: 0.5;\r\n  }\r\n  .trial-title {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    opacity: 0.3;\r\n    font-family: \"Segoe UI\";\r\n    font-weight: bold;\r\n    font-size: 100pt;\r\n    left: calc(50% - 135px);\r\n    top: calc(50% - 88px);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .trial-title span {\r\n    transform: rotate(-45deg);\r\n  }\r\n  .hovered {\r\n    border-color: rgb(73, 108, 159);\r\n  }\r\n\r\n  .active {\r\n    border-color: rgb(146, 146, 146);\r\n  }\r\n  i {\r\n    position: absolute;\r\n    right: 5px;\r\n    top: 5px;\r\n  }\r\n\r\n  .disable-text-selection {\r\n    -webkit-touch-callout: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n  }\r\n</style>\r\n", styles: ["\n  .page-container {\n    position: relative;\n    display: flex;\n  }\n  .page {\n    position: relative;\n    display: block;\n    background: white;\n    font-size: 2.5rem;\n    color: black;\n    border: 1px solid #c6c6c6;\n    margin-right: 10px;\n    margin-top: 10px;\n    margin-bottom: 10px;\n  }\n  .inline-border {\n    position: absolute;\n    pointer-events: none;\n    border: 1px solid rgb(234, 234, 234);\n    opacity: 0.5;\n  }\n  .trial-title {\n    position: absolute;\n    pointer-events: none;\n    user-select: none;\n    opacity: 0.3;\n    font-family: \"Segoe UI\";\n    font-weight: bold;\n    font-size: 100pt;\n    left: calc(50% - 135px);\n    top: calc(50% - 88px);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n  .trial-title span {\n    transform: rotate(-45deg);\n  }\n  .hovered {\n    border-color: rgb(73, 108, 159);\n  }\n\n  .active {\n    border-color: rgb(146, 146, 146);\n  }\n  i {\n    position: absolute;\n    right: 5px;\n    top: 5px;\n  }\n\n  .disable-text-selection {\n    -webkit-touch-callout: none;\n    -khtml-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n  }\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiPageGridOverlayComponent, selector: "sti-page-grid-overlay" }, { kind: "component", type: i7.StiPageNavigationComponent, selector: "sti-page-navigation", inputs: ["currentPage"] }, { kind: "component", type: i8.StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageComponent, decorators: [{
            type: Component,
            args: [{ selector: "app-page", template: "<div\r\n  #pageContainerEl\r\n  class=\"page-container\"\r\n  *ngIf=\"((!page.visible || page.visible) && !model.previewMode) || (page.visible && model.previewMode)\"\r\n  [style.width.px]=\"width + (model.viewerMode || model.previewMode ? 0 : 51)\"\r\n  [style.margin-left.px]=\"getLeftMargin()\"\r\n  (mousedown)=\"onContainerMouseDown($event)\"\r\n  [style.opacity]=\"isInitialized ? 1 : 0\"\r\n>\r\n  <div\r\n    #element\r\n    class=\"page\"\r\n    id=\"Page\"\r\n    [id]=\"id\"\r\n    [style.padding-left.px]=\"page?.padding.left\"\r\n    [style.padding-right.px]=\"page?.padding.right\"\r\n    [style.padding-top.px]=\"page?.padding.top\"\r\n    [style.padding-bottom.px]=\"page?.padding.bottom\"\r\n    [style.background-color]=\"page.backgroundColor.toHtmlColor()\"\r\n    [style.overflow]=\"'hidden'\"\r\n    [style.width.px]=\"width\"\r\n    [style.height.px]=\"height\"\r\n    [class]=\"className\"\r\n    [style.background-image]=\"backgroundImage\"\r\n    [style.background-position]=\"'center'\"\r\n    [style.background-size]=\"'cover'\"\r\n    [style.background-repeat]=\"'no-repeat'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n    (mousedown)=\"onMouseDown($event)\"\r\n  >\r\n    <div *ngFor=\"let element of elements\">\r\n      <sti-component-holder [element]=\"element\"></sti-component-holder>\r\n    </div>\r\n    <sti-page-grid-overlay\r\n      *ngIf=\"model.pageWithGrid == page || (model.lastUsedPage == page && componentResizerService.isResizing)\"\r\n    ></sti-page-grid-overlay>\r\n    <div class=\"trial-title\" [style.zIndex]=\"model.previewMode ? 99999 : 0\" *ngIf=\"model.showTrialTitle\">\r\n      <span>{{ loc.getP(\"Trial\") }}</span>\r\n    </div>\r\n    <div\r\n      class=\"inline-border\"\r\n      *ngIf=\"!model.viewerMode && !model.previewMode\"\r\n      [style.left.px]=\"page.padding.left\"\r\n      [style.top.px]=\"page.padding.top\"\r\n      [style.width.px]=\"page.contentAreaWidth\"\r\n      [style.height.px]=\"page.contentAreaHeight\"\r\n    ></div>\r\n    <i *ngIf=\"!page?.visible\" class=\"pi pi-eye-slash\" style=\"opacity: 0.3\"></i>\r\n  </div>\r\n  <sti-page-navigation\r\n    *ngIf=\"page === model.selectedPage && !model.previewMode\"\r\n    [currentPage]=\"page\"\r\n    [style.visibility]=\"model.previewMode ? 'hidden' : ''\"\r\n    [style.height]=\"'100%'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n  ></sti-page-navigation>\r\n</div>\r\n<style>\r\n  .page-container {\r\n    position: relative;\r\n    display: flex;\r\n  }\r\n  .page {\r\n    position: relative;\r\n    display: block;\r\n    background: white;\r\n    font-size: 2.5rem;\r\n    color: black;\r\n    border: 1px solid #c6c6c6;\r\n    margin-right: 10px;\r\n    margin-top: 10px;\r\n    margin-bottom: 10px;\r\n  }\r\n  .inline-border {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    border: 1px solid rgb(234, 234, 234);\r\n    opacity: 0.5;\r\n  }\r\n  .trial-title {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    opacity: 0.3;\r\n    font-family: \"Segoe UI\";\r\n    font-weight: bold;\r\n    font-size: 100pt;\r\n    left: calc(50% - 135px);\r\n    top: calc(50% - 88px);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .trial-title span {\r\n    transform: rotate(-45deg);\r\n  }\r\n  .hovered {\r\n    border-color: rgb(73, 108, 159);\r\n  }\r\n\r\n  .active {\r\n    border-color: rgb(146, 146, 146);\r\n  }\r\n  i {\r\n    position: absolute;\r\n    right: 5px;\r\n    top: 5px;\r\n  }\r\n\r\n  .disable-text-selection {\r\n    -webkit-touch-callout: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiComponentResizerService }, { type: i4.StiEditableContentService }], propDecorators: { pageEl: [{
                type: ViewChild,
                args: ["element"]
            }], pageContainerEl: [{
                type: ViewChild,
                args: ["pageContainerEl"]
            }], page: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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