import { Component } from "@angular/core";
import StiRectangleGeometryLayout from "../../computed/StiRectangleGeometryLayout";
import { StiTextElement } from "../../elements/StiTextElement";
import { UsedFont } from "../../services/objects";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-draggable.service";
import * as i4 from "../../services/theme.service";
import * as i5 from "../../services/sti-form-events-service";
import * as i6 from "../../services/sti-editable-content.service";
import * as i7 from "../../services/sti-localization.service";
import * as i8 from "../../services/sti-rich-text.service";
import * as i9 from "../../services/sti-undo-service";
import * as i10 from "../../services/sti-name.service";
import * as i11 from "../../services/sti-color-dialog.service";
import * as i12 from "../../services/sti-clipboard-sevice";
import * as i13 from "@angular/common";
import * as i14 from "../sti-dropdown-component/sti-dropdown-component";
import * as i15 from "../sti-tooltip/sti-tooltip.directive";
import * as i16 from "../sti-select-button/sti-select-button.component";
export class StiHomeRibbonComponent {
    constructor(model, helper, draggableService, theme, render, formEvents, editableContentService, loc, richTextService, undoService, nameService, colorService, clipboardService) {
        this.model = model;
        this.helper = helper;
        this.draggableService = draggableService;
        this.theme = theme;
        this.render = render;
        this.formEvents = formEvents;
        this.editableContentService = editableContentService;
        this.loc = loc;
        this.richTextService = richTextService;
        this.undoService = undoService;
        this.nameService = nameService;
        this.colorService = colorService;
        this.clipboardService = clipboardService;
    }
    get alignment() {
        return this.editableContentService.editableContent["horizontalAlignment"]
            ? this.editableContentService.editableContent["horizontalAlignment"]
            : null;
    }
    haveBackgroundColor() {
        return (this.editableContentService.editableContent != null &&
            this.editableContentService.editableContent.haveBackgoundColor());
    }
    haveContentAlignment() {
        return (this.editableContentService.editableContent != null &&
            this.editableContentService.editableContent.haveContentAlignment());
    }
    haveVerticalAlignment() {
        return (this.editableContentService.editableContent != null &&
            this.editableContentService.editableContent.haveVerticalAlignment());
    }
    showColorPicker(element, object, isRichText = false) {
        this.colorService.openDialog(element, object, isRichText);
    }
    changeEvent() {
        let currentChangableFont = new UsedFont(this.editableContentService.editableContent.eFont.family, this.model.arrayOfStylesToString(this.editableContentService.editableContent.eFont.style), this.editableContentService.editableContent.eFont.size);
        this.model.form.formEvents.next({ name: "UpdateFonts", value: currentChangableFont });
    }
    setStyle(value) {
        if (value == "Bold") {
            this.richTextService.insertBold();
        }
        else if (value == "Italic") {
            this.richTextService.insertItalic();
        }
        else {
            this.richTextService.insertUnderline();
        }
    }
    setAlignment(value) {
        if (value == 1) {
            this.richTextService.setLeftAlignment();
        }
        else if (value == 2) {
            this.richTextService.setCenterAlignment();
        }
        else {
            this.richTextService.setRightAlignment();
        }
    }
    get fontSize() {
        return this.editableContentService.editableContent?.eFont.size;
    }
    set fontSize(value) {
        if (this.editableContentService.editableContent) {
            this.editableContentService.editableContent.eFont.size = value;
        }
    }
    get fontFamily() {
        return this.editableContentService.editableContent?.eFont.family;
    }
    set fontFamily(value) {
        if (this.editableContentService.editableContent) {
            this.editableContentService.editableContent.eFont.family = value;
        }
    }
    get fontStyle() {
        return this.editableContentService.editableContent?.eFont.style;
    }
    set fontStyle(value) {
        if (this.editableContentService.editableContent) {
            this.editableContentService.editableContent.eFont.style = value;
        }
    }
    get foreColor() {
        return this.editableContentService.editableContent?.eColor;
    }
    get backColor() {
        return this.editableContentService.editableContent.eBackgroundColor;
    }
    get canDelete() {
        return this.model.selectedComponent ? true : false;
    }
    get isRichText() {
        return this.model.selectedComponent?.element instanceof StiTextElement ? true : false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHomeRibbonComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiDraggableService }, { token: i4.StiThemeService }, { token: StiRectangleGeometryLayout }, { token: i5.FormEventsService }, { token: i6.StiEditableContentService }, { token: i7.StiLocalizationService }, { token: i8.StiRichTextService }, { token: i9.StiUndoService }, { token: i10.StiNameService }, { token: i11.StiColorDialogService }, { token: i12.StiClipboardService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiHomeRibbonComponent, selector: "sti-home-ribbon-component", ngImport: i0, template: `<div
    class="home"
    style="-moz-user-select: none;-webkit-touch-callout: none;-webkit-user-select: none;-ms-user-select: none;user-select: none"
  >
    <div
      [style.margin-left]="'10px'"
      class="container {{ undoService?.undos?.length < 2 ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('HelpDesigner', 'Undo').replace('.', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="undoService.undo()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Undo.png')" alt="" /></div>
    </div>
    <div
      class="container {{ undoService?.redos?.length < 1 ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('HelpDesigner', 'Redo').replace('.', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="undoService.redo()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Redo.png')" alt="" /></div>
    </div>
    <!-- <div
      *ngIf="isRichText"
      [style.margin-left]="'10px'"
      class="container"
      [stiTooltip]="loc.getP('Undo')"
      tooltipPosition="bottom" showDelay="500"
      (click)="richTextService.useUndo()"
    >
      <div class="button"><img [src]="getIcon('Undo')" alt="" /></div>
    </div>
    <div
      *ngIf="isRichText"
      class="container"
      [stiTooltip]="loc.getP('Redo')"
      tooltipPosition="bottom" showDelay="500"
      (click)="richTextService.useRedo()"
    >
      <div class="button"><img [src]="getIcon('Redo')" alt="" /></div>
    </div> -->
    <div class="vertical-line"></div>
    <div
      class="container {{ !clipboardService.hasCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditPaste').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.pasteElement($event)"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Paste.png')" alt="" /></div>
    </div>
    <div
      class="container {{ clipboardService.canCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditCopy').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.copyElement()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Copy.png')" alt="" /></div>
    </div>
    <div
      class="container {{ clipboardService.canCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditCut').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.cutElement()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Cut.png')" alt="" /></div>
    </div>
    <div
      class="container {{ !canDelete ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('Buttons', 'Delete')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="formEvents.deleteComponent()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Delete.png')" alt="" /></div>
    </div>
    <div class="vertical-line"></div>
    <sti-dropdown-component
      *ngIf="!isRichText"
      [id]="0"
      [options]="model.fontFamilies"
      [(value)]="fontFamily"
      [disabled]="editableContentService.editableContent == null"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      [optionLabel]="'name'"
      [optionValue]="'name'"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="changeEvent()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="!isRichText"
      [options]="model.fontFamilies"
      [(ngModel)]="fontFamily"
      optionLabel="name"
      optionValue="name"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      [disabled]="editableContentService.editableContent == null"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (onChange)="changeEvent()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="isRichText"
      [id]="1"
      [options]="model.fontFamilies"
      [(value)]="richTextService.activeFontFamily"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      [optionLabel]="'name'"
      [optionValue]="'name'"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="richTextService.insertFontFamily(richTextService.activeFontFamily)"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="isRichText"
      [options]="model.fontFamilies"
      [(ngModel)]="richTextService.activeFontFamily"
      optionLabel="name"
      optionValue="name"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (onChange)="richTextService.insertFontFamily(richTextService.activeFontFamily)"
      (mouseup)="editableContentService.startEdit()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="!isRichText"
      [id]="2"
      [options]="helper.fontSizes"
      [(value)]="fontSize"
      [tooltip]="loc.getP('FontSize')"
      [style]="{
        width: '60px',
        height: '32px',
        alignItems: 'center',
        margin: '10px 10px 1px 2px',
        fontSize: '12px'
      }"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="changeEvent()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="!isRichText"
      [options]="helper.fontSizes"
      [(ngModel)]="fontSize"
      [style]="{ width: '60px', height: '32px', alignItems: 'center', margin: '10px 10px 1px 2px', fontSize: '12px' }"
      [tooltip]="loc.getP('FontSize')"
      tooltipPosition="bottom"
      showDelay="500"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (onChange)="changeEvent()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="isRichText"
      [id]="3"
      [options]="helper.richTextFontSizes"
      [(value)]="richTextService.activeFontSize"
      [tooltip]="loc.getP('FontSize')"
      [optionLabel]="'name'"
      [optionValue]="'value'"
      [style]="{
        width: '60px',
        height: '32px',
        alignItems: 'center',
        margin: '10px 10px 1px 2px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="richTextService.insertFontSize()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="isRichText"
      [options]="helper.richTextFontSizes"
      [(ngModel)]="richTextService.activeFontSize"
      optionLabel="name"
      optionValue="value"
      [style]="{ width: '60px', height: '32px', alignItems: 'center', margin: '10px 10px 1px 2px', fontSize: '12px' }"
      [tooltip]="loc.getP('FontSize')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (onChange)="richTextService.insertFontSize()"
      (mouseup)="editableContentService.startEdit()"
    ></p-dropdown> -->
    <sti-selectButton
      *ngIf="!isRichText"
      [options]="helper.styleOptions"
      [(value)]="fontStyle"
      [multiple]="true"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (onChange)="changeEvent()"
      ><ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.value)"
          tooltipPosition="bottom"
          showDelay="500"
        /> </ng-template
    ></sti-selectButton>
    <sti-selectButton
      *ngIf="isRichText"
      [options]="helper.styleOptions"
      [(value)]="richTextService.activeTextStyles"
      [multiple]="true"
      optionValue="value"
      (onOptionClick)="setStyle($event.option.value)"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      ><ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.value)"
          tooltipPosition="bottom"
          showDelay="500"
        /> </ng-template
    ></sti-selectButton>
    <div class="vertical-line"></div>
    <div
      *ngIf="!isRichText"
      class="button-container"
      [stiTooltip]="loc.getP('ForeColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="editableContentService.editableContent != null ? '1' : '0.5'"
      [class]="editableContentService.editableContent != null ? 'enabled' : 'disabled'"
      (click)="showColorPicker(fontColorEditor, foreColor)"
      (mousedown)="$event.preventDefault()"
      #fontColorEditor
    >
      <div class="prev">
        <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Brush.png')" alt="" />
        </div>
        <span
          class="color-preview"
          [style.background-color]="
            editableContentService.editableContent != null
              ? editableContentService.editableContent?.eColor?.toHtmlColor()
              : 'rgb(182, 181, 180)'
          "
        ></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <div
      *ngIf="isRichText"
      class="button-container"
      [stiTooltip]="loc.getP('ForeColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="1"
      [class]="'enabled'"
      (click)="showColorPicker(richTextColorEditor, richTextService.activeColor, true)"
      (mousedown)="$event.preventDefault()"
      #richTextColorEditor
    >
      <div class="prev">
        <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Brush.png')" alt="" />
        </div>
        <span class="color-preview" [style.background-color]="richTextService.activeColor.toHtmlColor()"></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <div
      class="button-container"
      [stiTooltip]="loc.getP('BackColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="haveBackgroundColor() ? '1' : '0.5'"
      [class]="haveBackgroundColor() ? 'enabled' : 'disabled'"
      (click)="showColorPicker(backColorEditor, backColor)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      #backColorEditor
    >
      <div class="prev">
        <div class="background" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Fill.png')" alt="" />
        </div>
        <span
          class="color-preview"
          [style.background-color]="
            editableContentService.editableContent != null
              ? editableContentService.editableContent?.eBackgroundColor?.toHtmlColor()
              : 'rgb(182, 181, 180)'
          "
        ></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <sti-selectButton
      *ngIf="haveContentAlignment()"
      [options]="helper.justifyOptions"
      [(value)]="editableContentService.editableContent.eContentAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (mousedown)="editableContentService.startEdit()"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="!haveContentAlignment() && !isRichText"
      [options]="helper.justifyOptions"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      [disabled]="true"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="isRichText"
      [options]="helper.justifyOptions"
      [(value)]="richTextService.activeAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (onOptionClick)="setAlignment($event.option.value)"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="haveVerticalAlignment()"
      [options]="helper.verticalAlignment"
      [(value)]="editableContentService.editableContent.eVerticalAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (mousedown)="editableContentService.startEdit()"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="!haveVerticalAlignment()"
      [options]="helper.verticalAlignment"
      optionValue="value"
      [disabled]="true"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '90px' }"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <!-- <div class="vertical-line"></div>
    <div
      class="container"
      [stiTooltip]="loc.getP('ToggleElementCorners')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="model.showCornerRadius = !model.showCornerRadius"
    >
      <div class="button {{ model.showCornerRadius ? 'active' : '' }}"><img [src]="getIcon('Corners')" alt="" /></div>
    </div> -->
  </div>`, isInline: true, styles: [".active{background-color:var(--active-color)!important}.disabled{opacity:.5;pointer-events:none}.container{width:40px;display:flex;align-items:center;justify-content:center}.button{height:32px;width:32px;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}img{max-width:18px}.prev{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;margin-top:11px;height:32px;width:48px;position:relative;margin-right:10px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:6px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}i:hover{color:#fff}.home{height:55px;color:var(--text-color);width:100%;display:flex;border-bottom:1px solid var(--formBorder-color);vertical-align:-webkit-baseline-middle;background-color:var(--back-color);font-family:Segoe UI;overflow-x:auto;overflow-y:hidden}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.home input{margin-top:12.5px;vertical-align:-webkit-baseline-middle}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px}.Bold{background:var(--navbarBold-icon)}.Italic{background:var(--navbarItalic-icon)}.Underline{background:var(--navbarUnder-icon)}.foreground{margin-left:10px;margin-top:5px;width:16px;height:18px}.background{margin-left:8px;margin-top:5px;width:16px;height:18px}\n"], dependencies: [{ kind: "directive", type: i13.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i14.StiDropdownComponent, selector: "sti-dropdown-component", inputs: ["id", "options", "value", "disabled", "optionLabel", "optionValue", "isMinVersion", "tooltip"], outputs: ["valueChange"] }, { kind: "directive", type: i15.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i16.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHomeRibbonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-home-ribbon-component", template: `<div
    class="home"
    style="-moz-user-select: none;-webkit-touch-callout: none;-webkit-user-select: none;-ms-user-select: none;user-select: none"
  >
    <div
      [style.margin-left]="'10px'"
      class="container {{ undoService?.undos?.length < 2 ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('HelpDesigner', 'Undo').replace('.', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="undoService.undo()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Undo.png')" alt="" /></div>
    </div>
    <div
      class="container {{ undoService?.redos?.length < 1 ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('HelpDesigner', 'Redo').replace('.', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="undoService.redo()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Redo.png')" alt="" /></div>
    </div>
    <!-- <div
      *ngIf="isRichText"
      [style.margin-left]="'10px'"
      class="container"
      [stiTooltip]="loc.getP('Undo')"
      tooltipPosition="bottom" showDelay="500"
      (click)="richTextService.useUndo()"
    >
      <div class="button"><img [src]="getIcon('Undo')" alt="" /></div>
    </div>
    <div
      *ngIf="isRichText"
      class="container"
      [stiTooltip]="loc.getP('Redo')"
      tooltipPosition="bottom" showDelay="500"
      (click)="richTextService.useRedo()"
    >
      <div class="button"><img [src]="getIcon('Redo')" alt="" /></div>
    </div> -->
    <div class="vertical-line"></div>
    <div
      class="container {{ !clipboardService.hasCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditPaste').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.pasteElement($event)"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Paste.png')" alt="" /></div>
    </div>
    <div
      class="container {{ clipboardService.canCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditCopy').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.copyElement()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Copy.png')" alt="" /></div>
    </div>
    <div
      class="container {{ clipboardService.canCopy ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('MainMenu', 'menuEditCut').replace('&amp', '').replace(';', '')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="clipboardService.cutElement()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Cut.png')" alt="" /></div>
    </div>
    <div
      class="container {{ !canDelete ? 'disabled' : '' }}"
      [stiTooltip]="loc.get2('Buttons', 'Delete')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="formEvents.deleteComponent()"
    >
      <div class="button"><img [src]="model.getImage('images.Ribbon.Delete.png')" alt="" /></div>
    </div>
    <div class="vertical-line"></div>
    <sti-dropdown-component
      *ngIf="!isRichText"
      [id]="0"
      [options]="model.fontFamilies"
      [(value)]="fontFamily"
      [disabled]="editableContentService.editableContent == null"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      [optionLabel]="'name'"
      [optionValue]="'name'"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="changeEvent()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="!isRichText"
      [options]="model.fontFamilies"
      [(ngModel)]="fontFamily"
      optionLabel="name"
      optionValue="name"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      [disabled]="editableContentService.editableContent == null"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (onChange)="changeEvent()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="isRichText"
      [id]="1"
      [options]="model.fontFamilies"
      [(value)]="richTextService.activeFontFamily"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      [optionLabel]="'name'"
      [optionValue]="'name'"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="richTextService.insertFontFamily(richTextService.activeFontFamily)"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="isRichText"
      [options]="model.fontFamilies"
      [(ngModel)]="richTextService.activeFontFamily"
      optionLabel="name"
      optionValue="name"
      [style]="{
        width: '150px',
        height: '32px',
        alignItems: 'center',
        margin: '1px 2px',
        marginTop: '10px',
        fontSize: '12px'
      }"
      [tooltip]="loc.get2('HelpDesigner', 'FontName')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (onChange)="richTextService.insertFontFamily(richTextService.activeFontFamily)"
      (mouseup)="editableContentService.startEdit()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="!isRichText"
      [id]="2"
      [options]="helper.fontSizes"
      [(value)]="fontSize"
      [tooltip]="loc.getP('FontSize')"
      [style]="{
        width: '60px',
        height: '32px',
        alignItems: 'center',
        margin: '10px 10px 1px 2px',
        fontSize: '12px'
      }"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="changeEvent()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="!isRichText"
      [options]="helper.fontSizes"
      [(ngModel)]="fontSize"
      [style]="{ width: '60px', height: '32px', alignItems: 'center', margin: '10px 10px 1px 2px', fontSize: '12px' }"
      [tooltip]="loc.getP('FontSize')"
      tooltipPosition="bottom"
      showDelay="500"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (onChange)="changeEvent()"
    ></p-dropdown> -->
    <sti-dropdown-component
      *ngIf="isRichText"
      [id]="3"
      [options]="helper.richTextFontSizes"
      [(value)]="richTextService.activeFontSize"
      [tooltip]="loc.getP('FontSize')"
      [optionLabel]="'name'"
      [optionValue]="'value'"
      [style]="{
        width: '60px',
        height: '32px',
        alignItems: 'center',
        margin: '10px 10px 1px 2px',
        fontSize: '12px'
      }"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      (valueChange)="richTextService.insertFontSize()"
    ></sti-dropdown-component>
    <!-- <p-dropdown
      *ngIf="isRichText"
      [options]="helper.richTextFontSizes"
      [(ngModel)]="richTextService.activeFontSize"
      optionLabel="name"
      optionValue="value"
      [style]="{ width: '60px', height: '32px', alignItems: 'center', margin: '10px 10px 1px 2px', fontSize: '12px' }"
      [tooltip]="loc.getP('FontSize')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="$event.preventDefault()"
      (onChange)="richTextService.insertFontSize()"
      (mouseup)="editableContentService.startEdit()"
    ></p-dropdown> -->
    <sti-selectButton
      *ngIf="!isRichText"
      [options]="helper.styleOptions"
      [(value)]="fontStyle"
      [multiple]="true"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      [disabled]="editableContentService.editableContent == null"
      (mousedown)="$event.preventDefault()"
      (onChange)="changeEvent()"
      ><ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.value)"
          tooltipPosition="bottom"
          showDelay="500"
        /> </ng-template
    ></sti-selectButton>
    <sti-selectButton
      *ngIf="isRichText"
      [options]="helper.styleOptions"
      [(value)]="richTextService.activeTextStyles"
      [multiple]="true"
      optionValue="value"
      (onOptionClick)="setStyle($event.option.value)"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      ><ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.value)"
          tooltipPosition="bottom"
          showDelay="500"
        /> </ng-template
    ></sti-selectButton>
    <div class="vertical-line"></div>
    <div
      *ngIf="!isRichText"
      class="button-container"
      [stiTooltip]="loc.getP('ForeColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="editableContentService.editableContent != null ? '1' : '0.5'"
      [class]="editableContentService.editableContent != null ? 'enabled' : 'disabled'"
      (click)="showColorPicker(fontColorEditor, foreColor)"
      (mousedown)="$event.preventDefault()"
      #fontColorEditor
    >
      <div class="prev">
        <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Brush.png')" alt="" />
        </div>
        <span
          class="color-preview"
          [style.background-color]="
            editableContentService.editableContent != null
              ? editableContentService.editableContent?.eColor?.toHtmlColor()
              : 'rgb(182, 181, 180)'
          "
        ></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <div
      *ngIf="isRichText"
      class="button-container"
      [stiTooltip]="loc.getP('ForeColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="1"
      [class]="'enabled'"
      (click)="showColorPicker(richTextColorEditor, richTextService.activeColor, true)"
      (mousedown)="$event.preventDefault()"
      #richTextColorEditor
    >
      <div class="prev">
        <div class="foreground" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Brush.png')" alt="" />
        </div>
        <span class="color-preview" [style.background-color]="richTextService.activeColor.toHtmlColor()"></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <div
      class="button-container"
      [stiTooltip]="loc.getP('BackColor')"
      tooltipPosition="bottom"
      showDelay="500"
      [style.opacity]="haveBackgroundColor() ? '1' : '0.5'"
      [class]="haveBackgroundColor() ? 'enabled' : 'disabled'"
      (click)="showColorPicker(backColorEditor, backColor)"
      (mousedown)="$event.preventDefault()"
      (mouseup)="editableContentService.startEdit()"
      #backColorEditor
    >
      <div class="prev">
        <div class="background" [style]="{ backgroundPosition: 'center', backgroundRepeat: 'no-repeat' }">
          <img [src]="model.getImage('images.Fill.png')" alt="" />
        </div>
        <span
          class="color-preview"
          [style.background-color]="
            editableContentService.editableContent != null
              ? editableContentService.editableContent?.eBackgroundColor?.toHtmlColor()
              : 'rgb(182, 181, 180)'
          "
        ></span>
      </div>
      <div [style]="{ position: 'relative', alignSelf: 'center' }">
        <i class="pi pi-chevron-down"></i>
      </div>
    </div>
    <sti-selectButton
      *ngIf="haveContentAlignment()"
      [options]="helper.justifyOptions"
      [(value)]="editableContentService.editableContent.eContentAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (mousedown)="editableContentService.startEdit()"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="!haveContentAlignment() && !isRichText"
      [options]="helper.justifyOptions"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      [disabled]="true"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="isRichText"
      [options]="helper.justifyOptions"
      [(value)]="richTextService.activeAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (onOptionClick)="setAlignment($event.option.value)"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="haveVerticalAlignment()"
      [options]="helper.verticalAlignment"
      [(value)]="editableContentService.editableContent.eVerticalAlignment"
      optionValue="value"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '94px' }"
      (mousedown)="editableContentService.startEdit()"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <sti-selectButton
      *ngIf="!haveVerticalAlignment()"
      [options]="helper.verticalAlignment"
      optionValue="value"
      [disabled]="true"
      [style]="{ margin: '11px 10px 1px 1px', height: '32px', minWidth: '90px' }"
    >
      <ng-template let-item>
        <img
          [src]="model.getImage(item.image)"
          [stiTooltip]="loc.getP(item.name)"
          tooltipPosition="bottom"
          showDelay="500"
          [style]="{ height: '16px', width: '16px' }"
        />
      </ng-template>
    </sti-selectButton>
    <!-- <div class="vertical-line"></div>
    <div
      class="container"
      [stiTooltip]="loc.getP('ToggleElementCorners')"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="model.showCornerRadius = !model.showCornerRadius"
    >
      <div class="button {{ model.showCornerRadius ? 'active' : '' }}"><img [src]="getIcon('Corners')" alt="" /></div>
    </div> -->
  </div>`, styles: [".active{background-color:var(--active-color)!important}.disabled{opacity:.5;pointer-events:none}.container{width:40px;display:flex;align-items:center;justify-content:center}.button{height:32px;width:32px;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}img{max-width:18px}.prev{display:flex;width:100%;position:relative;flex-direction:column}.button-container{display:flex;margin-top:11px;height:32px;width:48px;position:relative;margin-right:10px;border-radius:3px}.button-container:hover{background-color:var(--hover-color)}.button-container:active{background-color:var(--columnDeleteHover-color)}.color-preview{width:20px;height:5px;margin-left:6px}i{height:12px;width:12px;right:3px;top:50%;vertical-align:middle;color:var(--text-color)}i:hover{color:#fff}.home{height:55px;color:var(--text-color);width:100%;display:flex;border-bottom:1px solid var(--formBorder-color);vertical-align:-webkit-baseline-middle;background-color:var(--back-color);font-family:Segoe UI;overflow-x:auto;overflow-y:hidden}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.home input{margin-top:12.5px;vertical-align:-webkit-baseline-middle}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px}.Bold{background:var(--navbarBold-icon)}.Italic{background:var(--navbarItalic-icon)}.Underline{background:var(--navbarUnder-icon)}.foreground{margin-left:10px;margin-top:5px;width:16px;height:18px}.background{margin-left:8px;margin-top:5px;width:16px;height:18px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiDraggableService }, { type: i4.StiThemeService }, { type: StiRectangleGeometryLayout }, { type: i5.FormEventsService }, { type: i6.StiEditableContentService }, { type: i7.StiLocalizationService }, { type: i8.StiRichTextService }, { type: i9.StiUndoService }, { type: i10.StiNameService }, { type: i11.StiColorDialogService }, { type: i12.StiClipboardService }] });
//# sourceMappingURL=data:application/json;base64,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