import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
export class StiFileRibbonComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
    }
    saveAs() { }
    open() {
        let input = document.createElement("input");
        input.type = "file";
        let model = this.model;
        input.onchange = (_) => {
            // you can use this method to get file and perform respective operations
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsText(file, "UTF-8");
            reader.onload = function (evt) {
                model.setFormFromString(evt.target.result);
            };
        };
        input.click();
    }
    importFromPdf() {
        //TODO
    }
    showAboutWindow() {
        this.model.showAboutWindow = true;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileRibbonComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFileRibbonComponent, selector: "sti-file-ribbon-component", ngImport: i0, template: `<div class="saving">
    <button style="margin-left: 20px">{{ loc.getP("New") }}</button>
    <button (click)="open()">{{ loc.getP("Open") }}</button>
    <button (click)="saveAs()">{{ loc.getP("SaveAs") }}</button>
    <button (click)="importFromPdf()">{{ loc.getP("ImportFromPdf") }}</button>
    <button (click)="showAboutWindow()">{{ loc.getP("About") }}</button>
  </div>`, isInline: true, styles: [".saving{height:55px;color:var(--text-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;border-bottom:1px solid var(--formBorder-color);background-color:var(--back-color);font-family:Segoe UI}.saving button{margin-top:15px;padding:3px 12px;text-decoration:none;margin-right:5px;text-align:center;justify-content:center;font-size:12px;color:var(--text-color);font-weight:600;cursor:default;background-color:var(--input-color);border-top:2px solid var(--toolbarResizerBorder-color);border-left:1px solid var(--toolbarResizerBorder-color);border-right:1px solid var(--toolbarResizerBorder-color);border-bottom:1px solid var(--toolbarResizerBorder-color);vertical-align:-webkit-baseline-middle;border-radius:3px}.saving button:hover{background-color:var(--hover-color)}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFileRibbonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-file-ribbon-component", template: `<div class="saving">
    <button style="margin-left: 20px">{{ loc.getP("New") }}</button>
    <button (click)="open()">{{ loc.getP("Open") }}</button>
    <button (click)="saveAs()">{{ loc.getP("SaveAs") }}</button>
    <button (click)="importFromPdf()">{{ loc.getP("ImportFromPdf") }}</button>
    <button (click)="showAboutWindow()">{{ loc.getP("About") }}</button>
  </div>`, styles: [".saving{height:55px;color:var(--text-color);width:100%;-webkit-touch-callout:none;-webkit-user-select:none;border-bottom:1px solid var(--formBorder-color);background-color:var(--back-color);font-family:Segoe UI}.saving button{margin-top:15px;padding:3px 12px;text-decoration:none;margin-right:5px;text-align:center;justify-content:center;font-size:12px;color:var(--text-color);font-weight:600;cursor:default;background-color:var(--input-color);border-top:2px solid var(--toolbarResizerBorder-color);border-left:1px solid var(--toolbarResizerBorder-color);border-right:1px solid var(--toolbarResizerBorder-color);border-bottom:1px solid var(--toolbarResizerBorder-color);vertical-align:-webkit-baseline-middle;border-radius:3px}.saving button:hover{background-color:var(--hover-color)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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