import { Component, ViewChild } from "@angular/core";
import StiRectangleGeometryLayout from "../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-draggable.service";
import * as i4 from "../../services/sti-export.service";
import * as i5 from "../../services/theme.service";
import * as i6 from "../../services/sti-localization.service";
import * as i7 from "../../services/sti-toolbox.service";
import * as i8 from "../../services/http-client.service";
import * as i9 from "../../services/sti-user-service";
import * as i10 from "../../services/sti-form-checker.service";
import * as i11 from "@angular/common";
import * as i12 from "./navbar.home-ribbon.component";
import * as i13 from "./navbar.file-ribbon.component";
import * as i14 from "./navbar.insert-ribbon.component";
import * as i15 from "../sti-tooltip/sti-tooltip.directive";
export class NavbarComponent {
    get editButtonRight() {
        return (this.saveButton?.nativeElement.offsetWidth ?? 0) + 20;
    }
    get componentHeight() {
        if (this.model.viewerMode) {
            return 0;
        }
        else if (this.model.pdfPreviewMode || this.model.previewMode) {
            return 38;
        }
        else
            return 93;
    }
    getClass(ribbon) {
        return this.model.ribbon == ribbon ? "current" : "other";
    }
    setEvent(event) {
        if (event == "Share") {
            this.httpService.post("", { action: "InterfaceEvent", event: "ShareButtonClick" }).subscribe(() => { });
        }
        else if (event == "Publish") {
            this.httpService.post("", { action: "InterfaceEvent", event: "PublishButtonClick" }).subscribe(() => { });
        }
        else if (event == "Login") {
            this.httpService.post("", { action: "InterfaceEvent", event: "LoginButtonClick" }).subscribe(() => { });
        }
        else if (event == "Signup") {
            this.httpService.post("", { action: "InterfaceEvent", event: "SignUpButtonClick" }).subscribe(() => { });
        }
    }
    setRibbon(ribbon) {
        this.model.ribbon = ribbon;
    }
    onSetRibbon(ribbon, oldRibbon) {
        if (ribbon == "PDFPreview" || ribbon == "File") {
            this.model.currentFormState = this.model.form.saveToReportJsonObject().serialize();
        }
        if ((this.model.isWebView || this.model.embeddedMode) && ribbon == "File") {
            this.httpService.post("", { action: "InterfaceEvent", event: "RibbonFileClick" }).subscribe(() => { });
            this.model.ribbon = oldRibbon;
        }
        else {
            if (ribbon == "File") {
                this.model.currentSelectedFileOption = "Open";
            }
        }
        this.model.showTrialLog();
    }
    save() {
        if (this.model.isWebView || this.model.embeddedMode || this.model.isCloudMode) {
            let form = this.model.form.saveToJsonObject().serialize();
            this.httpService.post("", { action: "InterfaceEvent", event: "SaveButtonClick", form: form }).subscribe(() => { });
        }
        else {
            this.setRibbon("File");
            this.model.currentSelectedFileOption = "SaveAs";
        }
    }
    showInfo(event, type) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let element = elements.find((element) => element?.classList.contains("localization")) ||
            elements.find((element) => element?.classList.contains("user-info"));
        let elementRect = this.model.getPositionRelativeToForm(element);
        this.userService.previewY = elementRect.bottom;
        if (type == "Localization") {
            this.userService.showLocalizationPreview = true;
            this.userService.previewX = elementRect.right - (this.loc.localizationList?.length > 0 ? 465 : 155);
        }
        else {
            this.userService.showUserInfo = true;
            this.userService.previewX = elementRect.right - 351;
        }
    }
    sendExportEvent() {
        if (this.model.isWebView) {
            this.httpService.post("", { action: "InterfaceEvent", event: "ExportButtonClick" }).subscribe(() => { });
        }
        else if (this.model.isCloudMode && !this.model.viewerMode) {
            this.model.showSaveDialogFromCloud = true;
        }
        else {
            this.showPdfOption();
        }
    }
    constructor(model, helper, draggableService, exportService, render, theme, loc, toolboxService, httpService, userService, formCheckerService) {
        this.model = model;
        this.helper = helper;
        this.draggableService = draggableService;
        this.exportService = exportService;
        this.render = render;
        this.theme = theme;
        this.loc = loc;
        this.toolboxService = toolboxService;
        this.httpService = httpService;
        this.userService = userService;
        this.formCheckerService = formCheckerService;
        this.disabled = true;
    }
    ngOnDestroy() {
        this.startPdfEventSubscription?.unsubscribe();
        this.setFormEventSubscription?.unsubscribe();
    }
    editForm() {
        let cloudParams = {
            demomode: true,
            localizationName: "en",
            themeName: "Office2022WhiteBlue",
            isForm: true,
            reportName: this.helper.base64Encode(this.model.form.formName),
        };
        let win_ = window.open("about:blank");
        let doc = win_ ? win_.document : document;
        this.httpService.postForm("https://designer.stimulsoft.com/", {
            designerParams: this.helper.base64Encode(JSON.stringify(cloudParams)),
        }, doc, true);
    }
    showPdfOption() {
        this.exportService.showModalWindow = !this.exportService.showModalWindow;
    }
    ngOnInit() {
        this.model.form?.pages.length == 1 ? (this.disabled = true) : (this.disabled = false);
        this.setFormEventSubscription = this.model.formEvents.subscribe((e) => {
            if (e.name == "SetForm") {
                this.setDefaultTab();
            }
            else if (e.name == "ShowFileMenu") {
                this.setRibbon("File");
            }
            else if (e.name == "ShowSaveMenu") {
                this.setRibbon("File");
                this.model.currentSelectedFileOption = "SaveAs";
            }
            else if (e.name == "ShowTab") {
                this.setRibbon(e.value);
            }
        });
        this.model.interfaceEvent.subscribe((e) => {
            if (e.name == "setRibbon") {
                this.onSetRibbon(e.data.ribbon, e.data.oldRibbon);
            }
        });
        this.startPdfEventSubscription = this.model.startPdfExportEvent.subscribe(() => {
            this.setRibbon("Preview");
            this.showPdfOption();
        });
    }
    setDefaultTab() {
        let defaultSettingsTab = this.model.settings?.defaultTab;
        let tab = defaultSettingsTab == "Home" || defaultSettingsTab == "Insert" || defaultSettingsTab == "Preview" || defaultSettingsTab == "PDFPreview" ?
            defaultSettingsTab : "Home";
        this.model.ribbon = tab;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: NavbarComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiDraggableService }, { token: i4.StiExportService }, { token: StiRectangleGeometryLayout }, { token: i5.StiThemeService }, { token: i6.StiLocalizationService }, { token: i7.StiToolboxService }, { token: i8.StiHttpClientService }, { token: i9.StiUserService }, { token: i10.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: NavbarComponent, selector: "sti-navbar", viewQueries: [{ propertyName: "saveButton", first: true, predicate: ["saveButton"], descendants: true }], ngImport: i0, template: "<div class=\"navbar\" [style.visibility]=\"model.viewerMode ? 'hidden' : 'visible'\" [style.height.px]=\"componentHeight\">\r\n  <div\r\n    class=\"navigation\"\r\n    [style.border-bottom]=\"\r\n      model.previewMode && !model.viewerMode ? '1px solid rgb(224,224,224)' : '1px solid transparent'\r\n    \"\r\n  >\r\n    <div\r\n      class=\"image-container\"\r\n      *ngIf=\"model.previewMode && model.showEditButton\"\r\n      [style.right.px]=\"editButtonRight\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      (click)=\"editForm()\"\r\n    >\r\n      <img [style.margin]=\"model.isMobile() ? '0px' : '0px 5px 0px 0px'\" [src]=\"model.getImage('images.Edit.png')\" />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"MainMenu\", \"menuEditEdit\") }}</span>\r\n    </div>\r\n    <div\r\n      #saveButton\r\n      class=\"image-container\"\r\n      *ngIf=\"(model.viewerMode || model.previewMode) && model.showSaveToPdfButton && !model.fileMenuMode\"\r\n      [style.right.px]=\"15\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      [stiTooltip]=\"loc.get2('A_WebViewer', 'SaveReport')\"\r\n      tooltipPosition=\"bottom\"\r\n      (click)=\"showPdfOption()\"\r\n    >\r\n      <img\r\n        [style.margin]=\"model.isMobile() ? '0px' : '1px 5px 0px 0px'\"\r\n        [src]=\"\r\n          model.isMobile() ? model.getImage('images.ReportSave.png') : model.getImage('images.Other.DownloadPDF.png')\r\n        \"\r\n      />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"Buttons\", \"Save\") }}</span>\r\n    </div>\r\n    <div class=\"save-button\" *ngIf=\"model.getBooleanSetting('showSaveButton')\" (click)=\"save()\">\r\n      <img [src]=\"model.getImage('images.Other.Save.png')\" />\r\n    </div>\r\n    <div class=\"file-menu-button\" *ngIf=\"model.getBooleanSetting('showFileButton')\" (click)=\"setRibbon('File')\">\r\n      <span>{{ loc.getP(\"File\") }}</span>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showHomeTab')\" (click)=\"setRibbon('Home')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"Toolbars\", \"TabHome\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Home') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.showInsertTab && model.getBooleanSetting('showInsertTab')\"\r\n      (click)=\"setRibbon('Insert')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"Insert\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Insert') }}\"></div>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showPreviewTab')\" (click)=\"setRibbon('Preview')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"FormDesigner\", \"Preview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Preview') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.getBooleanSetting('showPDFPreviewTab')\"\r\n      (click)=\"setRibbon('PDFPreview')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"PDFPreview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('PDFPreview') }}\"></div>\r\n    </div>\r\n    <div *ngIf=\"(userService.currentUser || model.embeddedMode) && model.userWasChecked\" class=\"user-interface\">\r\n      <div class=\"share button\" (click)=\"setEvent('Share')\">\r\n        <img [src]=\"model.getImage('images.Share.png')\" alt=\"\" />\r\n      </div>\r\n      <div class=\"publish button\" (click)=\"setEvent('Publish')\">\r\n        <span>{{ loc.get2(\"Buttons\", \"Publish\") }}</span>\r\n      </div>\r\n      <div class=\"localization button\" (click)=\"showInfo($event, 'Localization')\" [style.padding]=\"'3px 10px'\">\r\n        <span>{{ loc.currentLocalization ? loc.currentLocalization.cultureName.toUpperCase() : \"EN\" }}</span>\r\n      </div>\r\n      <div\r\n        *ngIf=\"!model.userIsAuthorized && !model.isWebView\"\r\n        class=\"login button\"\r\n        [style.padding]=\"'3px 10px'\"\r\n        (click)=\"setEvent('Login')\"\r\n      >\r\n        <span>{{ loc.get2(\"Cloud\", \"Login\") }}</span>\r\n      </div>\r\n      <div *ngIf=\"!model.userIsAuthorized && !model.isWebView\" class=\"signup button\" (click)=\"setEvent('Signup')\">\r\n        <span>{{ loc.get2(\"Cloud\", \"ButtonSignUp\") }}</span>\r\n      </div>\r\n      <div\r\n        class=\"user-info button\"\r\n        *ngIf=\"model.userIsAuthorized || model.isWebView\"\r\n        (click)=\"showInfo($event, 'User')\"\r\n      >\r\n        <span>{{\r\n          userService.currentUser\r\n            ? (userService.currentUser.firstName ? userService.currentUser.firstName : \"\") +\r\n              \" \" +\r\n              (userService.currentUser.lastName ? userService.currentUser.lastName : \"\")\r\n            : \"My1 Company\"\r\n        }}</span\r\n        ><img\r\n          *ngIf=\"userService?.currentUser?.picture\"\r\n          src=\"data:image/jpeg;base64,{{ userService?.currentUser?.picture }}\"\r\n          alt=\"\"\r\n        />\r\n        <div\r\n          *ngIf=\"!userService?.currentUser?.picture\"\r\n          class=\"custom-image\"\r\n          [style.background-color]=\"userService.getBackground(userService.currentUser)\"\r\n        >\r\n          <span [style.margin-top.px]=\"4\">{{\r\n            userService.currentUser\r\n              ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : \"\") +\r\n                (userService.currentUser.lastName ? userService.currentUser.lastName[0] : \"\")\r\n              : \"MC\"\r\n          }}</span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <sti-file-ribbon-component *ngIf=\"model.ribbon == 'File'\"></sti-file-ribbon-component>\r\n  <sti-home-ribbon-component *ngIf=\"model.ribbon == 'Home'\"></sti-home-ribbon-component>\r\n  <sti-insert-ribbon-component *ngIf=\"model.ribbon == 'Insert' && model.showInsertTab\"></sti-insert-ribbon-component>\r\n</div>\r\n\r\n<style>\r\n  .save-button img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .save-button {\r\n    height: 30px;\r\n    width: 30px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n    border-radius: 3px;\r\n  }\r\n  .save-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .label-container {\r\n    padding: 0px 12px;\r\n  }\r\n  .file-menu-button {\r\n    height: 30px;\r\n    margin-left: 3px;\r\n    min-width: 70px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    color: white;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    padding: 0px 10px;\r\n  }\r\n  .file-menu-button:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navigation-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .navigation-button {\r\n    height: 30px;\r\n    min-width: 60px;\r\n    margin-left: 3px;\r\n    display: flex;\r\n    flex-direction: column;\r\n    color: rgb(68, 68, 68);\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n  }\r\n  .navigation-label {\r\n    height: 27px;\r\n    width: 100%;\r\n    padding-top: 2px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    white-space: nowrap;\r\n  }\r\n  .current-indicator {\r\n    height: 3px;\r\n    margin: 0px 10px;\r\n  }\r\n  .navigation-button:hover .current-indicator {\r\n    margin: 0px;\r\n  }\r\n  .image-container {\r\n    position: absolute;\r\n    top: 43px;\r\n    height: 23px;\r\n    min-width: 83px;\r\n    border: 1px solid rgb(218, 218, 218);\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    justify-content: center;\r\n    background-color: white;\r\n    z-index: 99999999;\r\n  }\r\n  .image-container img {\r\n    height: 16px;\r\n    width: 16px;\r\n    margin: 5px 0px 0px 5px;\r\n  }\r\n  .image-container span {\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n  }\r\n  .image-container:hover {\r\n    background-color: rgb(226, 226, 226);\r\n  }\r\n  .image-container:active {\r\n    background-color: rgb(187, 187, 187);\r\n  }\r\n  .custom-image {\r\n    margin: 0px 5px;\r\n    height: 22px;\r\n    width: 22px;\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n    overflow: hidden;\r\n    border-radius: 40px;\r\n    color: White;\r\n    display: flex;\r\n    justify-content: center;\r\n  }\r\n  .user-info img {\r\n    width: 22px;\r\n    height: 22px;\r\n    margin: 0px 5px;\r\n    border-radius: 40px;\r\n  }\r\n  .button {\r\n    height: 30px;\r\n    min-width: 30px;\r\n    padding: 3px 5px;\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .share img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .user-interface {\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    align-items: center;\r\n    height: 30px;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    color: #444444;\r\n    flex: 1;\r\n  }\r\n  .signup {\r\n    background-color: #19478a;\r\n    color: #ffffff;\r\n    padding: 0px 17px;\r\n    margin-right: 3px;\r\n  }\r\n  .signup:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navbar {\r\n    height: 93px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    background-color: var(--back-color);\r\n    color: var(--text-color);\r\n  }\r\n  a span {\r\n    height: 100%;\r\n    padding: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-items: center;\r\n  }\r\n  .navigation {\r\n    position: relative;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n    height: 38px;\r\n    align-items: center;\r\n    background-color: var(--back-color);\r\n    width: 100%;\r\n    padding-top: 1px;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    font-family: \"Segoe UI\";\r\n  }\r\n\r\n  .navigation a {\r\n    padding: 0px 10px;\r\n    height: 100%;\r\n    text-decoration: none;\r\n    text-align: center;\r\n    font-size: 13px;\r\n    cursor: default;\r\n    margin-right: 5px;\r\n    margin-left: 5px;\r\n  }\r\n  .navigation a:hover {\r\n    padding: 0;\r\n    background-color: var(--hover-color);\r\n  }\r\n  a:hover span {\r\n    padding-left: 13px;\r\n    padding-right: 13px;\r\n    width: 100%;\r\n  }\r\n  .current {\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .other {\r\n    background-color: transparent;\r\n  }\r\n</style>\r\n", styles: ["\n  .save-button img {\n    height: 16px;\n    width: 16px;\n  }\n  .save-button {\n    height: 30px;\n    width: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    margin-left: 3px;\n    border-radius: 3px;\n  }\n  .save-button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .label-container {\n    padding: 0px 12px;\n  }\n  .file-menu-button {\n    height: 30px;\n    margin-left: 3px;\n    min-width: 70px;\n    background-color: rgb(25, 71, 138);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    color: white;\n    font-size: 12px;\n    font-family: Arial;\n    padding: 0px 10px;\n  }\n  .file-menu-button:hover {\n    background-color: rgb(61, 98, 152);\n  }\n  .navigation-button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .navigation-button {\n    height: 30px;\n    min-width: 60px;\n    margin-left: 3px;\n    display: flex;\n    flex-direction: column;\n    color: rgb(68, 68, 68);\n    font-size: 12px;\n    font-family: Arial;\n  }\n  .navigation-label {\n    height: 27px;\n    width: 100%;\n    padding-top: 2px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    white-space: nowrap;\n  }\n  .current-indicator {\n    height: 3px;\n    margin: 0px 10px;\n  }\n  .navigation-button:hover .current-indicator {\n    margin: 0px;\n  }\n  .image-container {\n    position: absolute;\n    top: 43px;\n    height: 23px;\n    min-width: 83px;\n    border: 1px solid rgb(218, 218, 218);\n    border-radius: 3px;\n    display: flex;\n    align-items: center;\n    padding: 0px 10px;\n    justify-content: center;\n    background-color: white;\n    z-index: 99999999;\n  }\n  .image-container img {\n    height: 16px;\n    width: 16px;\n    margin: 5px 0px 0px 5px;\n  }\n  .image-container span {\n    font-family: Arial;\n    font-size: 12px;\n  }\n  .image-container:hover {\n    background-color: rgb(226, 226, 226);\n  }\n  .image-container:active {\n    background-color: rgb(187, 187, 187);\n  }\n  .custom-image {\n    margin: 0px 5px;\n    height: 22px;\n    width: 22px;\n    font-family: Arial;\n    font-size: 12px;\n    overflow: hidden;\n    border-radius: 40px;\n    color: White;\n    display: flex;\n    justify-content: center;\n  }\n  .user-info img {\n    width: 22px;\n    height: 22px;\n    margin: 0px 5px;\n    border-radius: 40px;\n  }\n  .button {\n    height: 30px;\n    min-width: 30px;\n    padding: 3px 5px;\n    border-radius: 3px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    margin-left: 3px;\n  }\n  .button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .share img {\n    height: 16px;\n    width: 16px;\n  }\n  .user-interface {\n    display: flex;\n    justify-content: flex-end;\n    align-items: center;\n    height: 30px;\n    font-size: 12px;\n    font-family: Arial;\n    color: #444444;\n    flex: 1;\n  }\n  .signup {\n    background-color: #19478a;\n    color: #ffffff;\n    padding: 0px 17px;\n    margin-right: 3px;\n  }\n  .signup:hover {\n    background-color: rgb(61, 98, 152);\n  }\n  .navbar {\n    height: 93px;\n    width: 100%;\n    display: flex;\n    flex-direction: column;\n    background-color: var(--back-color);\n    color: var(--text-color);\n  }\n  a span {\n    height: 100%;\n    padding: 3px;\n    display: flex;\n    align-items: center;\n    justify-items: center;\n  }\n  .navigation {\n    position: relative;\n    display: flex;\n    justify-content: flex-start;\n    height: 38px;\n    align-items: center;\n    background-color: var(--back-color);\n    width: 100%;\n    padding-top: 1px;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    font-family: \"Segoe UI\";\n  }\n\n  .navigation a {\n    padding: 0px 10px;\n    height: 100%;\n    text-decoration: none;\n    text-align: center;\n    font-size: 13px;\n    cursor: default;\n    margin-right: 5px;\n    margin-left: 5px;\n  }\n  .navigation a:hover {\n    padding: 0;\n    background-color: var(--hover-color);\n  }\n  a:hover span {\n    padding-left: 13px;\n    padding-right: 13px;\n    width: 100%;\n  }\n  .current {\n    background-color: rgb(25, 71, 138);\n  }\n\n  .other {\n    background-color: transparent;\n  }\n"], dependencies: [{ kind: "directive", type: i11.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i12.StiHomeRibbonComponent, selector: "sti-home-ribbon-component" }, { kind: "component", type: i13.StiFileRibbonComponent, selector: "sti-file-ribbon-component" }, { kind: "component", type: i14.StiInsertRibbonComponent, selector: "sti-insert-ribbon-component" }, { kind: "directive", type: i15.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: NavbarComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-navbar", template: "<div class=\"navbar\" [style.visibility]=\"model.viewerMode ? 'hidden' : 'visible'\" [style.height.px]=\"componentHeight\">\r\n  <div\r\n    class=\"navigation\"\r\n    [style.border-bottom]=\"\r\n      model.previewMode && !model.viewerMode ? '1px solid rgb(224,224,224)' : '1px solid transparent'\r\n    \"\r\n  >\r\n    <div\r\n      class=\"image-container\"\r\n      *ngIf=\"model.previewMode && model.showEditButton\"\r\n      [style.right.px]=\"editButtonRight\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      (click)=\"editForm()\"\r\n    >\r\n      <img [style.margin]=\"model.isMobile() ? '0px' : '0px 5px 0px 0px'\" [src]=\"model.getImage('images.Edit.png')\" />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"MainMenu\", \"menuEditEdit\") }}</span>\r\n    </div>\r\n    <div\r\n      #saveButton\r\n      class=\"image-container\"\r\n      *ngIf=\"(model.viewerMode || model.previewMode) && model.showSaveToPdfButton && !model.fileMenuMode\"\r\n      [style.right.px]=\"15\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      [stiTooltip]=\"loc.get2('A_WebViewer', 'SaveReport')\"\r\n      tooltipPosition=\"bottom\"\r\n      (click)=\"showPdfOption()\"\r\n    >\r\n      <img\r\n        [style.margin]=\"model.isMobile() ? '0px' : '1px 5px 0px 0px'\"\r\n        [src]=\"\r\n          model.isMobile() ? model.getImage('images.ReportSave.png') : model.getImage('images.Other.DownloadPDF.png')\r\n        \"\r\n      />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"Buttons\", \"Save\") }}</span>\r\n    </div>\r\n    <div class=\"save-button\" *ngIf=\"model.getBooleanSetting('showSaveButton')\" (click)=\"save()\">\r\n      <img [src]=\"model.getImage('images.Other.Save.png')\" />\r\n    </div>\r\n    <div class=\"file-menu-button\" *ngIf=\"model.getBooleanSetting('showFileButton')\" (click)=\"setRibbon('File')\">\r\n      <span>{{ loc.getP(\"File\") }}</span>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showHomeTab')\" (click)=\"setRibbon('Home')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"Toolbars\", \"TabHome\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Home') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.showInsertTab && model.getBooleanSetting('showInsertTab')\"\r\n      (click)=\"setRibbon('Insert')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"Insert\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Insert') }}\"></div>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showPreviewTab')\" (click)=\"setRibbon('Preview')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"FormDesigner\", \"Preview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Preview') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.getBooleanSetting('showPDFPreviewTab')\"\r\n      (click)=\"setRibbon('PDFPreview')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"PDFPreview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('PDFPreview') }}\"></div>\r\n    </div>\r\n    <div *ngIf=\"(userService.currentUser || model.embeddedMode) && model.userWasChecked\" class=\"user-interface\">\r\n      <div class=\"share button\" (click)=\"setEvent('Share')\">\r\n        <img [src]=\"model.getImage('images.Share.png')\" alt=\"\" />\r\n      </div>\r\n      <div class=\"publish button\" (click)=\"setEvent('Publish')\">\r\n        <span>{{ loc.get2(\"Buttons\", \"Publish\") }}</span>\r\n      </div>\r\n      <div class=\"localization button\" (click)=\"showInfo($event, 'Localization')\" [style.padding]=\"'3px 10px'\">\r\n        <span>{{ loc.currentLocalization ? loc.currentLocalization.cultureName.toUpperCase() : \"EN\" }}</span>\r\n      </div>\r\n      <div\r\n        *ngIf=\"!model.userIsAuthorized && !model.isWebView\"\r\n        class=\"login button\"\r\n        [style.padding]=\"'3px 10px'\"\r\n        (click)=\"setEvent('Login')\"\r\n      >\r\n        <span>{{ loc.get2(\"Cloud\", \"Login\") }}</span>\r\n      </div>\r\n      <div *ngIf=\"!model.userIsAuthorized && !model.isWebView\" class=\"signup button\" (click)=\"setEvent('Signup')\">\r\n        <span>{{ loc.get2(\"Cloud\", \"ButtonSignUp\") }}</span>\r\n      </div>\r\n      <div\r\n        class=\"user-info button\"\r\n        *ngIf=\"model.userIsAuthorized || model.isWebView\"\r\n        (click)=\"showInfo($event, 'User')\"\r\n      >\r\n        <span>{{\r\n          userService.currentUser\r\n            ? (userService.currentUser.firstName ? userService.currentUser.firstName : \"\") +\r\n              \" \" +\r\n              (userService.currentUser.lastName ? userService.currentUser.lastName : \"\")\r\n            : \"My1 Company\"\r\n        }}</span\r\n        ><img\r\n          *ngIf=\"userService?.currentUser?.picture\"\r\n          src=\"data:image/jpeg;base64,{{ userService?.currentUser?.picture }}\"\r\n          alt=\"\"\r\n        />\r\n        <div\r\n          *ngIf=\"!userService?.currentUser?.picture\"\r\n          class=\"custom-image\"\r\n          [style.background-color]=\"userService.getBackground(userService.currentUser)\"\r\n        >\r\n          <span [style.margin-top.px]=\"4\">{{\r\n            userService.currentUser\r\n              ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : \"\") +\r\n                (userService.currentUser.lastName ? userService.currentUser.lastName[0] : \"\")\r\n              : \"MC\"\r\n          }}</span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <sti-file-ribbon-component *ngIf=\"model.ribbon == 'File'\"></sti-file-ribbon-component>\r\n  <sti-home-ribbon-component *ngIf=\"model.ribbon == 'Home'\"></sti-home-ribbon-component>\r\n  <sti-insert-ribbon-component *ngIf=\"model.ribbon == 'Insert' && model.showInsertTab\"></sti-insert-ribbon-component>\r\n</div>\r\n\r\n<style>\r\n  .save-button img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .save-button {\r\n    height: 30px;\r\n    width: 30px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n    border-radius: 3px;\r\n  }\r\n  .save-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .label-container {\r\n    padding: 0px 12px;\r\n  }\r\n  .file-menu-button {\r\n    height: 30px;\r\n    margin-left: 3px;\r\n    min-width: 70px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    color: white;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    padding: 0px 10px;\r\n  }\r\n  .file-menu-button:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navigation-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .navigation-button {\r\n    height: 30px;\r\n    min-width: 60px;\r\n    margin-left: 3px;\r\n    display: flex;\r\n    flex-direction: column;\r\n    color: rgb(68, 68, 68);\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n  }\r\n  .navigation-label {\r\n    height: 27px;\r\n    width: 100%;\r\n    padding-top: 2px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    white-space: nowrap;\r\n  }\r\n  .current-indicator {\r\n    height: 3px;\r\n    margin: 0px 10px;\r\n  }\r\n  .navigation-button:hover .current-indicator {\r\n    margin: 0px;\r\n  }\r\n  .image-container {\r\n    position: absolute;\r\n    top: 43px;\r\n    height: 23px;\r\n    min-width: 83px;\r\n    border: 1px solid rgb(218, 218, 218);\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    justify-content: center;\r\n    background-color: white;\r\n    z-index: 99999999;\r\n  }\r\n  .image-container img {\r\n    height: 16px;\r\n    width: 16px;\r\n    margin: 5px 0px 0px 5px;\r\n  }\r\n  .image-container span {\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n  }\r\n  .image-container:hover {\r\n    background-color: rgb(226, 226, 226);\r\n  }\r\n  .image-container:active {\r\n    background-color: rgb(187, 187, 187);\r\n  }\r\n  .custom-image {\r\n    margin: 0px 5px;\r\n    height: 22px;\r\n    width: 22px;\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n    overflow: hidden;\r\n    border-radius: 40px;\r\n    color: White;\r\n    display: flex;\r\n    justify-content: center;\r\n  }\r\n  .user-info img {\r\n    width: 22px;\r\n    height: 22px;\r\n    margin: 0px 5px;\r\n    border-radius: 40px;\r\n  }\r\n  .button {\r\n    height: 30px;\r\n    min-width: 30px;\r\n    padding: 3px 5px;\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .share img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .user-interface {\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    align-items: center;\r\n    height: 30px;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    color: #444444;\r\n    flex: 1;\r\n  }\r\n  .signup {\r\n    background-color: #19478a;\r\n    color: #ffffff;\r\n    padding: 0px 17px;\r\n    margin-right: 3px;\r\n  }\r\n  .signup:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navbar {\r\n    height: 93px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    background-color: var(--back-color);\r\n    color: var(--text-color);\r\n  }\r\n  a span {\r\n    height: 100%;\r\n    padding: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-items: center;\r\n  }\r\n  .navigation {\r\n    position: relative;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n    height: 38px;\r\n    align-items: center;\r\n    background-color: var(--back-color);\r\n    width: 100%;\r\n    padding-top: 1px;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    font-family: \"Segoe UI\";\r\n  }\r\n\r\n  .navigation a {\r\n    padding: 0px 10px;\r\n    height: 100%;\r\n    text-decoration: none;\r\n    text-align: center;\r\n    font-size: 13px;\r\n    cursor: default;\r\n    margin-right: 5px;\r\n    margin-left: 5px;\r\n  }\r\n  .navigation a:hover {\r\n    padding: 0;\r\n    background-color: var(--hover-color);\r\n  }\r\n  a:hover span {\r\n    padding-left: 13px;\r\n    padding-right: 13px;\r\n    width: 100%;\r\n  }\r\n  .current {\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .other {\r\n    background-color: transparent;\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiDraggableService }, { type: i4.StiExportService }, { type: StiRectangleGeometryLayout }, { type: i5.StiThemeService }, { type: i6.StiLocalizationService }, { type: i7.StiToolboxService }, { type: i8.StiHttpClientService }, { type: i9.StiUserService }, { type: i10.StiFormCheckerService }], propDecorators: { saveButton: [{
                type: ViewChild,
                args: ["saveButton"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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