import { Component } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/theme.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-form-checker.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiFooterComponent {
    get themes() {
        return StiModelService.THEMES;
    }
    get cloud() {
        return this.loc.getP("StimulsoftCloud");
    }
    get size() {
        return this.model.zoom <= 1
            ? (this.model.zoom * 100).toFixed(0)
            : (100 + ((this.model.zoom - 1) / 3) * 100).toFixed(0);
    }
    get calculatedSize() {
        return (this.model.zoom * 100).toFixed(0);
    }
    get isMobileViewer() {
        return this.model.isMobile() && this.model.viewerMode;
    }
    get step() {
        return this.model.zoom <= 1 ? 10 : 1;
    }
    setSize(value) {
        if (value <= 100) {
            (this.model.zoom = value / 100).toFixed(1);
        }
        else {
            setTimeout(() => {
                this.model.zoom = Number((1 + ((value - 100) / 100) * 3).toFixed(1));
            });
        }
    }
    constructor(model, helper, theme, loc, formCheckerService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.formCheckerService = formCheckerService;
        this.isIncrement = false;
        this.isDecrement = false;
        this.model.isMobileViewer.subscribe(() => {
            setTimeout(() => {
                this.zoomByWidth();
            });
        });
        this.model.formEvents.subscribe((e) => {
            if (e.name == "SetZoomByPageWidth") {
                this.zoomByWidth();
            }
            else if (e.name == "SetZoomByOnePage") {
                this.zoomByOnePage();
            }
            else if (e.name == "SetDefaultZoom") {
                this.setDefaultZoom();
            }
        });
    }
    zoomByWidth() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let width = workspace["offsetWidth"];
        let pageElem = document.querySelectorAll(".page-container")[0];
        let pagetWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        this.model.zoom = width / (pagetWithMaxWidth.width + 30);
        setTimeout(() => {
            let rect = this.model.getPositionRelativeToForm(pageElem);
            if (this.isMobileViewer) {
                if (workspace.scrollLeft != workspace.scrollWidth - rect.width - 6) {
                    workspace.scrollLeft = workspace.scrollWidth - rect.width - 6;
                }
            }
            else {
                if (workspace.scrollLeft != (workspace.scrollWidth - rect.width) / 2) {
                    workspace.scrollLeft = (workspace.scrollWidth - rect.width) / 2;
                }
            }
        }, 0);
    }
    setDefaultZoom() {
        this.model.zoom = 1;
    }
    zoomByOnePage() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let height = workspace["offsetHeight"];
        let elementWithMaxHeight = this.model.form.pages.reduce((acc, curr) => (acc.height > curr.height ? acc : curr));
        let width = workspace["offsetWidth"];
        let elementWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        let currentCoef = height / (elementWithMaxHeight.height + 25) >
            width / (elementWithMaxWidth.width + (this.model.previewMode ? 0 : 60))
            ? width / (elementWithMaxWidth.width + (this.model.previewMode ? 0 : 60))
            : height / (elementWithMaxHeight.height + 25);
        this.model.zoom = currentCoef;
    }
    changeTheme() {
        this.theme.currentTheme = this.currentTheme;
    }
    clearTimers() {
        this.isIncrement = false;
        this.isDecrement = false;
        clearTimeout(this.timeout);
        clearInterval(this.interval);
    }
    iterate() {
        if (this.isIncrement) {
            this.model.zoom += 0.1;
        }
        else if (this.isDecrement) {
            this.model.zoom -= 0.1;
        }
    }
    setIncrementInterval() {
        this.isIncrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    setDecrementInterval() {
        this.isDecrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFooterComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: i5.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFooterComponent, selector: "sti-footer", ngImport: i0, template: "<div class=\"sti-footer\">\r\n  <div class=\"cloud-content\">\r\n    <div\r\n      class=\"warnings-container\"\r\n      *ngIf=\"formCheckerService.hasIssue\"\r\n      (click)=\"formCheckerService.displayFormsChecker()\"\r\n    >\r\n      <div class=\"vertical-line\"></div>\r\n      <div class=\"warning-panel\">\r\n        <img [src]=\"model.getImage('images.Form_Checker.Warning.png')\" />\r\n        <span class=\"warnings-count\">{{ formCheckerService.issuesCount }}</span>\r\n      </div>\r\n    </div>\r\n    <a\r\n      *ngIf=\"model.isCloudMode && model.viewerMode && model.basePlanIsTrial\"\r\n      href=\"https://cloud.stimulsoft.com/\"\r\n      target=\"_blank\"\r\n      >{{ cloud }}</a\r\n    >\r\n  </div>\r\n  <div class=\"zoom-buttons\" *ngIf=\"model.getBooleanSetting('showZoomButtons')\">\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'PageWidth')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByWidth()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomWidth.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'OnePage')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByOnePage()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomSize.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'ZoomTo100')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"setDefaultZoom()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.Zoom100.png')\" alt=\"\" />\r\n    </div>\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <label *ngIf=\"!isMobileViewer\"> {{ calculatedSize }}%</label>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' -'\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setDecrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomMinus.png')\" alt=\"\" />\r\n    </div>\r\n    <input\r\n      *ngIf=\"!isMobileViewer\"\r\n      type=\"range\"\r\n      min=\"10\"\r\n      max=\"200\"\r\n      [step]=\"step\"\r\n      [value]=\"size\"\r\n      (input)=\"setSize($event.target.value)\"\r\n    />\r\n    <div *ngIf=\"!isMobileViewer\" class=\"slider-vertical-line\"></div>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' +'\"\r\n      tooltipPosition=\"left\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setIncrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomPlus.png')\" alt=\"\" />\r\n    </div>\r\n  </div>\r\n\r\n  <!-- <p-dropdown\r\n        [options]=\"helper.themes\"\r\n        [(ngModel)]=\"currentTheme\"\r\n        optionLabel=\"name\"\r\n        optionValue=\"name\"\r\n        [style]=\"{ width: '100px',marginTop:'3px',marginRight:'5px' }\"\r\n        (onChange)=\"changeTheme()\"\r\n      ></p-dropdown> -->\r\n</div>\r\n<style>\r\n  .zoom-buttons {\r\n    width: fit-content;\r\n    display: flex;\r\n    position: relative;\r\n  }\r\n  .warnings-count {\r\n    margin-left: 5px;\r\n    font-size: 12px;\r\n  }\r\n  .warning-panel {\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    border-radius: 3px;\r\n    height: 100%;\r\n  }\r\n  .warnings-container {\r\n    display: flex;\r\n    position: absolute;\r\n    align-items: center;\r\n    top: 0;\r\n    right: 0;\r\n    height: 100%;\r\n  }\r\n  .warning-panel:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .cloud-content {\r\n    flex: 1;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    position: relative;\r\n  }\r\n  .vertical-line {\r\n    height: 32px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    border-right: 1px solid rgb(149, 171, 205);\r\n  }\r\n  .slider-vertical-line {\r\n    position: absolute;\r\n    height: 11px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    top: 11px;\r\n    right: 84px;\r\n    background-color: white;\r\n    pointer-events: none;\r\n  }\r\n  a {\r\n    font-size: 16px;\r\n    font-family: Arial;\r\n    cursor: pointer;\r\n    color: white;\r\n    text-decoration: none;\r\n  }\r\n  span {\r\n    font-size: 18px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n  .button {\r\n    height: 31px;\r\n    width: 32px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  .button:active {\r\n    background-color: rgb(0, 32, 80);\r\n  }\r\n  .sti-footer {\r\n    width: 100%;\r\n    height: 32px;\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    border-top: 1px solid var(--formBorder-color);\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    background-color: rgb(25, 71, 138);\r\n    font-family: \"Segoe UI\";\r\n    position: relative;\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"] {\r\n    margin-top: 3px;\r\n    margin-right: 3px;\r\n    margin-left: 3px;\r\n    width: 100px;\r\n    -webkit-appearance: none;\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"]:focus {\r\n    outline: none;\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-runnable-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n  input[type=\"range\"]::-moz-range-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    z-index: 11;\r\n  }\r\n  input[type=\"range\"]::-moz-range-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    border: 0;\r\n    background-color: transparent;\r\n  }\r\n\r\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\r\n  }\r\n\r\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\r\n  }\r\n\r\n  .sti-footer label {\r\n    margin-top: 7px;\r\n    margin-left: 5px;\r\n    width: 35px;\r\n    vertical-align: sub;\r\n    font-size: 12px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n</style>\r\n", styles: ["\n  .zoom-buttons {\n    width: fit-content;\n    display: flex;\n    position: relative;\n  }\n  .warnings-count {\n    margin-left: 5px;\n    font-size: 12px;\n  }\n  .warning-panel {\n    display: flex;\n    align-items: center;\n    padding: 0px 10px;\n    border-radius: 3px;\n    height: 100%;\n  }\n  .warnings-container {\n    display: flex;\n    position: absolute;\n    align-items: center;\n    top: 0;\n    right: 0;\n    height: 100%;\n  }\n  .warning-panel:hover {\n    background-color: rgb(18, 64, 120);\n  }\n  img {\n    height: 16px;\n    width: 16px;\n  }\n  .cloud-content {\n    flex: 1;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    position: relative;\n  }\n  .vertical-line {\n    height: 32px;\n    width: 1px;\n    margin-left: 3px;\n    margin-right: 3px;\n    border-right: 1px solid rgb(149, 171, 205);\n  }\n  .slider-vertical-line {\n    position: absolute;\n    height: 11px;\n    width: 1px;\n    margin-left: 3px;\n    margin-right: 3px;\n    top: 11px;\n    right: 84px;\n    background-color: white;\n    pointer-events: none;\n  }\n  a {\n    font-size: 16px;\n    font-family: Arial;\n    cursor: pointer;\n    color: white;\n    text-decoration: none;\n  }\n  span {\n    font-size: 18px;\n    font-weight: bold;\n    color: rgb(255, 255, 255);\n  }\n  .button {\n    height: 31px;\n    width: 32px;\n    background-color: rgb(25, 71, 138);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n  .button:hover {\n    background-color: rgb(18, 64, 120);\n  }\n  .button:active {\n    background-color: rgb(0, 32, 80);\n  }\n  .sti-footer {\n    width: 100%;\n    height: 32px;\n    display: flex;\n    justify-content: flex-end;\n    border-top: 1px solid var(--formBorder-color);\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    background-color: rgb(25, 71, 138);\n    font-family: \"Segoe UI\";\n    position: relative;\n  }\n\n  .sti-footer input[type=\"range\"] {\n    margin-top: 3px;\n    margin-right: 3px;\n    margin-left: 3px;\n    width: 100px;\n    -webkit-appearance: none;\n    background-color: rgb(25, 71, 138);\n  }\n\n  .sti-footer input[type=\"range\"]:focus {\n    outline: none;\n  }\n\n  input[type=\"range\"]::-webkit-slider-runnable-track {\n    width: 100%;\n    height: 2px;\n    cursor: default;\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\n    border-radius: 0px;\n    border: 0px solid rgb(255, 255, 255);\n  }\n  input[type=\"range\"]::-moz-range-track {\n    width: 100%;\n    height: 2px;\n    cursor: default;\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\n    border-radius: 0px;\n    border: 0px solid rgb(255, 255, 255);\n  }\n\n  input[type=\"range\"]::-webkit-slider-thumb {\n    height: 15px;\n    width: 15px;\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\n    background-repeat: no-repeat;\n    background-position: center;\n    cursor: default;\n    -webkit-appearance: none;\n    margin-top: -6px;\n    z-index: 11;\n  }\n  input[type=\"range\"]::-moz-range-thumb {\n    height: 15px;\n    width: 15px;\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\n    background-repeat: no-repeat;\n    background-position: center;\n    cursor: default;\n    -webkit-appearance: none;\n    margin-top: -6px;\n    border: 0;\n    background-color: transparent;\n  }\n\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\n  }\n\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\n  }\n\n  .sti-footer label {\n    margin-top: 7px;\n    margin-left: 5px;\n    width: 35px;\n    vertical-align: sub;\n    font-size: 12px;\n    font-weight: bold;\n    color: rgb(255, 255, 255);\n  }\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFooterComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-footer", template: "<div class=\"sti-footer\">\r\n  <div class=\"cloud-content\">\r\n    <div\r\n      class=\"warnings-container\"\r\n      *ngIf=\"formCheckerService.hasIssue\"\r\n      (click)=\"formCheckerService.displayFormsChecker()\"\r\n    >\r\n      <div class=\"vertical-line\"></div>\r\n      <div class=\"warning-panel\">\r\n        <img [src]=\"model.getImage('images.Form_Checker.Warning.png')\" />\r\n        <span class=\"warnings-count\">{{ formCheckerService.issuesCount }}</span>\r\n      </div>\r\n    </div>\r\n    <a\r\n      *ngIf=\"model.isCloudMode && model.viewerMode && model.basePlanIsTrial\"\r\n      href=\"https://cloud.stimulsoft.com/\"\r\n      target=\"_blank\"\r\n      >{{ cloud }}</a\r\n    >\r\n  </div>\r\n  <div class=\"zoom-buttons\" *ngIf=\"model.getBooleanSetting('showZoomButtons')\">\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'PageWidth')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByWidth()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomWidth.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'OnePage')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByOnePage()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomSize.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'ZoomTo100')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"setDefaultZoom()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.Zoom100.png')\" alt=\"\" />\r\n    </div>\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <label *ngIf=\"!isMobileViewer\"> {{ calculatedSize }}%</label>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' -'\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setDecrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomMinus.png')\" alt=\"\" />\r\n    </div>\r\n    <input\r\n      *ngIf=\"!isMobileViewer\"\r\n      type=\"range\"\r\n      min=\"10\"\r\n      max=\"200\"\r\n      [step]=\"step\"\r\n      [value]=\"size\"\r\n      (input)=\"setSize($event.target.value)\"\r\n    />\r\n    <div *ngIf=\"!isMobileViewer\" class=\"slider-vertical-line\"></div>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' +'\"\r\n      tooltipPosition=\"left\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setIncrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomPlus.png')\" alt=\"\" />\r\n    </div>\r\n  </div>\r\n\r\n  <!-- <p-dropdown\r\n        [options]=\"helper.themes\"\r\n        [(ngModel)]=\"currentTheme\"\r\n        optionLabel=\"name\"\r\n        optionValue=\"name\"\r\n        [style]=\"{ width: '100px',marginTop:'3px',marginRight:'5px' }\"\r\n        (onChange)=\"changeTheme()\"\r\n      ></p-dropdown> -->\r\n</div>\r\n<style>\r\n  .zoom-buttons {\r\n    width: fit-content;\r\n    display: flex;\r\n    position: relative;\r\n  }\r\n  .warnings-count {\r\n    margin-left: 5px;\r\n    font-size: 12px;\r\n  }\r\n  .warning-panel {\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    border-radius: 3px;\r\n    height: 100%;\r\n  }\r\n  .warnings-container {\r\n    display: flex;\r\n    position: absolute;\r\n    align-items: center;\r\n    top: 0;\r\n    right: 0;\r\n    height: 100%;\r\n  }\r\n  .warning-panel:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .cloud-content {\r\n    flex: 1;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    position: relative;\r\n  }\r\n  .vertical-line {\r\n    height: 32px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    border-right: 1px solid rgb(149, 171, 205);\r\n  }\r\n  .slider-vertical-line {\r\n    position: absolute;\r\n    height: 11px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    top: 11px;\r\n    right: 84px;\r\n    background-color: white;\r\n    pointer-events: none;\r\n  }\r\n  a {\r\n    font-size: 16px;\r\n    font-family: Arial;\r\n    cursor: pointer;\r\n    color: white;\r\n    text-decoration: none;\r\n  }\r\n  span {\r\n    font-size: 18px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n  .button {\r\n    height: 31px;\r\n    width: 32px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  .button:active {\r\n    background-color: rgb(0, 32, 80);\r\n  }\r\n  .sti-footer {\r\n    width: 100%;\r\n    height: 32px;\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    border-top: 1px solid var(--formBorder-color);\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    background-color: rgb(25, 71, 138);\r\n    font-family: \"Segoe UI\";\r\n    position: relative;\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"] {\r\n    margin-top: 3px;\r\n    margin-right: 3px;\r\n    margin-left: 3px;\r\n    width: 100px;\r\n    -webkit-appearance: none;\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"]:focus {\r\n    outline: none;\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-runnable-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n  input[type=\"range\"]::-moz-range-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    z-index: 11;\r\n  }\r\n  input[type=\"range\"]::-moz-range-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    border: 0;\r\n    background-color: transparent;\r\n  }\r\n\r\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\r\n  }\r\n\r\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\r\n  }\r\n\r\n  .sti-footer label {\r\n    margin-top: 7px;\r\n    margin-left: 5px;\r\n    width: 35px;\r\n    vertical-align: sub;\r\n    font-size: 12px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: i5.StiFormCheckerService }] });
//# sourceMappingURL=data:application/json;base64,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