import { animate, group, state, style, transition, trigger } from "@angular/animations";
export const SlideInOutAnimation = [
    trigger("slideInOut", [
        state("in", style({
            "max-height": "600px",
            /* opacity: "1", */
            visibility: "visible",
            overflow: "initial",
        })),
        state("out", style({
            "max-height": "0px",
            /* opacity: "0", */
            visibility: "hidden",
            overflow: "hidden",
        })),
        transition("in => out", [
            group([
                /*  animate(
                  "500ms ease-in-out",
                  style({
                    opacity: "0",
                  })
                ), */
                animate("300ms ease-in-out", style({
                    "max-height": "0px",
                })),
                animate("200ms ease-in-out", style({
                    visibility: "hidden",
                    overflow: "hidden",
                })),
            ]),
        ]),
        transition("out => in", [
            group([
                animate("650ms ease-in-out", style({
                    visibility: "visible",
                    overflow: "initial",
                })),
                animate("450ms ease-in-out", style({
                    "max-height": 600,
                })),
                /* animate(
                  "500ms ease-in-out",
                  style({
                    opacity: "1",
                  })
                ), */
            ]),
        ]),
    ]),
];
export const RotateAnimation = [
    trigger("rotatedState", [
        state("default", style({ transform: "rotate(0)" })),
        state("rotated", style({ transform: "rotate(90deg)" })),
        transition("rotated => default", animate("300ms linear")),
        transition("default => rotated", animate("300ms linear")),
    ]),
];
export const fileNavigationAnimation = [
    trigger("fileNavigation", [
        state("in", style({
            width: "170px",
            visibility: "visible",
        })),
        state("out", style({
            width: "0px",
            visibility: "hidden",
        })),
        transition("* => in", [animate("100ms")]),
        transition("* => out", [animate("100ms")]),
    ]),
];
//# sourceMappingURL=data:application/json;base64,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