import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import { ProxyService } from './proxy.service';
import { EMPTY, catchError } from 'rxjs';
import { FileSaverService } from './file.saver.service';
import * as i0 from "@angular/core";
import * as i1 from "./proxy.service";
import * as i2 from "@angular/common/http";
export class StimulsoftDesignerComponent {
    constructor(proxy, httpClient) {
        this.proxy = proxy;
        this.httpClient = httpClient;
        /**
         * Occurs when designer loaded
         */
        this.designerLoaded = new EventEmitter();
        this.id = "";
        this.id2 = 'aDesigner' + (Math.random() * 10000000).toString();
        this.scriptLoading = false;
        this.loaded = false;
    }
    ngOnDestroy() {
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        let options = this.designerEl.nativeElement?.firstChild?.jsObject?.options;
        try {
            clearTimeout(options.timerAjax);
        }
        catch { }
        try {
            clearTimeout(options.timerUpdateCache);
        }
        catch { }
        try {
            clearTimeout(options.timerAutoSave);
        }
        catch { }
    }
    ngOnInit() {
        this.addScript();
    }
    ngOnChanges(changes) {
        this.addScript();
    }
    addScript() {
        if (this.scriptLoading)
            return;
        this.scriptLoading = true;
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        this.chartScripts = document.createElement('Script');
        this.chartScripts.setAttribute('type', 'text/javascript');
        this.head.appendChild(this.chartScripts);
        let observable = this.httpClient.get(this.requestUrl, { responseType: 'text' }).pipe(catchError((error) => {
            console.log(error);
            this.scriptLoading = false;
            return EMPTY;
        }));
        observable.subscribe(data => {
            if (!this.loaded) {
                try {
                    this.chartScripts.innerHTML = data;
                    const options = new Stimulsoft.Designer.StiDesignerOptions();
                    this.loaded = true;
                    setTimeout(() => {
                        this.scriptLoading = false;
                    });
                    this.showDesigner();
                    this.designerLoadedF();
                }
                catch {
                    this.scriptLoading = false;
                }
            }
        });
    }
    designerLoadedF() {
        let jsObject = this.designerEl.nativeElement?.firstChild?.jsObject;
        if (!jsObject) {
            setTimeout(() => {
                this.designerLoadedF();
            });
            return;
        }
        this.designerLoaded.next(null);
    }
    showDesigner() {
        const options = new Stimulsoft.Designer.StiDesignerOptions();
        let defaultOptions = Stimulsoft?.Designer?.defaultOptions;
        if (defaultOptions) {
            for (let k in defaultOptions)
                options[k] = defaultOptions[k];
            options.useAliasesDictionary = defaultOptions.dictionary.useAliases;
        }
        if (this.width) {
            options.width = this.width;
        }
        if (this.height) {
            options.height = this.height;
        }
        if (this.id == null || this.id == "") {
            this.id = Math.trunc(Math.random() * 10000000).toString();
        }
        this.designer = new Stimulsoft.Designer.StiDesigner(options, 'StiDesigner' + this.id, false);
        this.proxy.postParametersFunction_ = this.postParametersFunction;
        this.designerEl.nativeElement.proxy = this.proxy;
        this.designer.renderHtml(this.designerEl.nativeElement);
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftDesignerComponent, deps: [{ token: i1.ProxyService }, { token: i2.HttpClient }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StimulsoftDesignerComponent, selector: "stimulsoft-designer-angular", inputs: { requestUrl: "requestUrl", width: "width", height: "height", postParametersFunction: "postParametersFunction", id: "id" }, outputs: { designerLoaded: "designerLoaded" }, providers: [ProxyService, FileSaverService], viewQueries: [{ propertyName: "designerEl", first: true, predicate: ["designer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div #designer [attr.id]="id2">
      <ng-content></ng-content>
    </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftDesignerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'stimulsoft-designer-angular', template: `
    <div #designer [attr.id]="id2">
      <ng-content></ng-content>
    </div>
  `, providers: [ProxyService, FileSaverService] }]
        }], ctorParameters: () => [{ type: i1.ProxyService }, { type: i2.HttpClient }], propDecorators: { designerEl: [{
                type: ViewChild,
                args: ['designer']
            }], designerLoaded: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], postParametersFunction: [{
                type: Input
            }], id: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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