import { Injectable } from '@angular/core';
import { catchError, EMPTY } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./file.saver.service";
export class ProxyService {
    constructor(httpClient, fileSaver) {
        this.httpClient = httpClient;
        this.fileSaver = fileSaver;
        this.openReport = false;
    }
    createConnection() {
        let request = new Object();
        request.method = "POST";
        request.url = "";
        request.headers = {};
        request.responseType = "text";
        request.readyState = 1;
        request.status = 0;
        request.responseText = null;
        request.statusText = null;
        request.id = null;
        request.open = (method, url) => {
            request.method = method;
            request.url = url;
        };
        request.setRequestHeader = (key, value) => {
            request.headers[key] = value;
        };
        request.abort = () => {
        };
        request.onreadystatechange = () => { };
        request.send = (data) => {
            let formData;
            if (typeof data == 'object') {
                formData = new FormData();
                Object.keys(data).forEach(key => formData.append(key, data[key]));
            }
            let needGet = data && data["stiweb_action"] === "Resource";
            let observable;
            if (needGet) {
                observable = this.httpClient.get(request.url, formData ?? data).pipe(catchError((error) => {
                    return this.catchError(error, request);
                }));
            }
            else {
                observable = this.httpClient.post(request.url, formData ?? data, { responseType: request.responseType }).pipe(catchError((error) => {
                    return this.catchError(error, request);
                }));
            }
            let downloadFileName;
            try {
                let dataObj = JSON.parse(window["StiBase64"].decode(data.stiweb_parameters));
                downloadFileName = dataObj.command == "DownloadReport" ? dataObj.reportFile : null;
            }
            catch { }
            observable.subscribe(data => {
                request.readyState = 4;
                let resultData = needGet ? JSON.stringify(data) : data;
                if (request.responseType == "text")
                    request.responseText = resultData;
                else
                    request.response = resultData;
                request.status = 200;
                if (downloadFileName) {
                    let blob = new Blob([data], { type: "application/xml", });
                    this.fileSaver.saveAs(blob, downloadFileName);
                    request.responseText = "{\"command\":\"SaveReport\"}";
                }
                request.onreadystatechange();
            });
        };
        return request;
    }
    ;
    catchError(error, request) {
        alert(JSON.stringify(error));
        request.status = error.status;
        request.statusText = error.statusText;
        request.responseText = error.error;
        request.readyState = 4;
        request.onreadystatechange();
        return EMPTY;
    }
    error(message) {
    }
    export(data) {
    }
    email(data) {
    }
    print(data) {
    }
    design() {
    }
    postParametersFunction(data) {
        return this.postParametersFunction_ ? this.postParametersFunction_(data) : {};
    }
    getFormData(data) {
        const formData = new FormData();
        Object.keys(data).forEach(key => formData.append(key, data[key]));
        return formData;
    }
    getData2(url, data) {
        return this.httpClient.post(url, this.getFormData(data), { responseType: 'blob' }).pipe(catchError((error) => {
            console.error(error);
            return EMPTY;
        }));
    }
    saveData(url, params, newWindow, retrieveFileName) {
        if (retrieveFileName) {
            params.stiweb_onlyFileName = true;
            debugger;
            let observable = this.httpClient.post(url, this.getFormData(params), { responseType: 'json' }).pipe(catchError((error) => {
                console.error(error);
                return EMPTY;
            }));
            observable.subscribe(resp => {
                let fileName = resp.fileName;
                delete params.stiweb_onlyFileName;
                this.getData2(url, params).subscribe((data) => {
                    this.showData(data, fileName, newWindow);
                });
            });
        }
        else {
            this.getData2(url, params).subscribe((data) => {
                this.showData(data, null, newWindow);
            });
        }
    }
    showData(data, fileName, newWindow) {
        if (newWindow) {
            if (window.navigator && window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveOrOpenBlob(data);
            }
            else {
                var fileURL = URL.createObjectURL(data);
                window.open(fileURL, '_blank');
            }
        }
        else {
            this.fileSaver.saveAs(data, fileName);
        }
    }
    async getText(url) {
        return new Promise((resolve, reject) => {
            let observable = this.httpClient.get(url, { responseType: 'text' }).pipe(catchError((error) => {
                console.log(error);
                return EMPTY;
            }));
            observable.subscribe(data => {
                resolve(data);
            });
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ProxyService, deps: [{ token: i1.HttpClient }, { token: i2.FileSaverService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ProxyService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ProxyService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.HttpClient }, { type: i2.FileSaverService }] });
//# sourceMappingURL=data:application/json;base64,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