# **Angular designer component for reports and dashboards**

The Angular Designer component is developed to create reports and dashboards in web browser.

The designer is the cornerstone tool of our product. It is a powerful editor that enables users to create custom report and dashboard layouts. With the designer, you can connect to various data sources, including *SQL* databases like *MS SQL, MySQL, Firebird, MS Access*, as well as cloud-based platforms such as *MongoDB, Azure*, and *Google*. Additionally, you can work with file sources, such as *JSON, Excel, XML*, and many more. After connecting to the data sources, you can structure and manipulate the data by grouping and sorting it, and then apply a range of visual styles to create dynamic and informative documents. Once you are satisfied with the sample design, you can publish the report or analytical panel to your application.

More about [Stimulsoft Dashboards.ANGULAR](https://www.stimulsoft.com/en/products/dashboards-angular) and [Stimulsoft Reports.ANGULAR](https://www.stimulsoft.com/en/products/reports-angular).

# How to install

```
npm install stimulsoft-designer-angular
```

# Integration

The component is developed to work in an Angular application in conjunction with the ASP.NET MVC or .NET Core platforms. We have created a special functionality for rapid and simple integration of a report to a project - the  [Publish wizard](https://publish.stimulsoft.com/). It enables you to integrate a pre-built dashboard into any project with just a few clicks.

To integrate the product into a project, simply install the necessary packages from the NPM repository for an Angular project and one package from the server-side NuGet repository for the required platform - [ASP.NET MVC](https://www.nuget.org/packages/Stimulsoft.Dashboards.Angular) and [.NET Core MVC](https://www.nuget.org/packages/Stimulsoft.Dashboards.Angular.NetCore). If needed, all packages can be downloaded from our website to a computer, and libraries and scripts can be added to a project manually. No additional modules or special extensions are required; everything you need is already in the report and dashboard builder.

# Live Demo

We prepared many templates of reports and dashboards, that you can explore and edit in our online demo. Choose the template you need, connect your data and try to create rich reports and analytical dashboards - the solution is ready. Try the [**Live Demo**](http://demo.stimulsoft.com/#Js).

# Video and Documentation

We provide full User Manuals and Class References intended to give technical assistance to people using our reporting tools. More information in the [**Online Documentation**](https://www.stimulsoft.com/en/documentation/online/programming-manual/index.html?reports_js.htm)**.**

Also, we prepared many videos about working of our software. See video on our [**YouTube channel**](https://www.youtube.com/@StimulsoftVideos).

[**Download**](https://www.stimulsoft.com/en/downloads)

[**Online Store**](https://www.stimulsoft.com/en/online-store)

[**License Info**](https://github.com/stimulsoft/Reports.JS/blob/HEAD/LICENSE.md)
