﻿
StiMobileDesigner.prototype.InitializeRulers = function () {
    this.InitializeHorRuler();
    this.InitializeVertRuler();
}

StiMobileDesigner.prototype.InitializeBaseRuler = function () {
    var jsObject = this;
    var ruler = document.createElement("div");
    ruler.style.display = this.options.showRules ? "" : "none";
    this.options.paintPanel.appendChild(ruler);

    ruler.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
        this.compSelector = null;
    }

    ruler.getMarginsUnit = function (page) {
        var margins = page.properties.unitMargins ? page.properties.unitMargins.split("!") : ["0", "0", "0", "0"];
        for (var i = 0; i < margins.length; i++) {
            margins[i] = jsObject.StrToDouble(margins[i]);
        }
        return margins;
    }

    ruler.getScaleText = function (index) {
        var text = index;
        if (jsObject.options.report != null) {
            var unit = jsObject.options.report.properties.reportUnit;
            if (unit == "hi") text = index * 100;
            else if (unit == "mm") text = index * 10;
            if (jsObject.options.report.zoom < 0.5) text = "";
        }
        return text;
    }

    ruler.getScaleSizeUnit = function () {
        if (jsObject.options.report != null) {
            var unit = jsObject.options.report.properties.reportUnit;
            switch (unit) {
                case "cm":
                case "in": return 1;
                case "mm": return 10;
                case "hi": return 100;
            }
        }
        return 1;
    }

    ruler.createScaleTable = function (width, height, margin) {
        var scaleTable = jsObject.CreateHTMLTable();
        scaleTable.className = "stiDesignerRulerScaleTable";
        if (width) scaleTable.style.width = width + "px";
        if (height) scaleTable.style.height = height + "px";
        scaleTable.style.margin = margin;
        ruler.appendChild(scaleTable);

        return scaleTable;
    }

    ruler.createPageSelector = function (width, height) {
        var pageSelector = document.createElement("div");
        pageSelector.className = "stiDesignerRulerPageSelector";
        pageSelector.style.width = width + "px";
        pageSelector.style.height = height + "px";
        ruler.appendChild(pageSelector);

        return pageSelector;
    }

    ruler.createCompSelector = function (width, height) {
        var compSelector = this.compSelector = document.createElement("div");
        compSelector.className = "stiDesignerRulerComponentSelector";
        if (width) compSelector.style.width = width + "px";
        if (height) compSelector.style.height = height + "px";
        ruler.appendChild(compSelector);

        return compSelector;
    }
    
    return ruler;
}

StiMobileDesigner.prototype.InitializeHorRuler = function () {
    var jsObject = this;
    var horRuler = this.options.horRuler = this.InitializeBaseRuler();
    horRuler.className = "stiDesignerRuler stiDesignerHorRuler";
    horRuler.style.height = this.options.rulerSize + "px";
    horRuler.style.left = (this.options.paintPanelPadding + this.options.rulerSize) + "px";
        
    horRuler.repaintScales = function () {
        var currPage = jsObject.options.currentPage;
        if (currPage) {
            horRuler.clear();

            var pageWidthPx = parseInt(currPage.getAttribute("width"));
            var pageWidthUnit = jsObject.StrToDouble(currPage.properties.unitWidth);
            var marginsUnit = horRuler.getMarginsUnit(currPage);
            var scaleSizeUnit = horRuler.getScaleSizeUnit();
            var scaleSizePx = jsObject.ConvertUnitToPixel(scaleSizeUnit) * jsObject.options.report.zoom;
            var scaleCount = parseInt((pageWidthUnit - marginsUnit[0] - marginsUnit[2]) / scaleSizeUnit) + 1;
            var rulerWidthPx = parseInt(scaleCount * scaleSizePx);
            var marginLeftPx = jsObject.ConvertUnitToPixel(marginsUnit[0]) * jsObject.options.report.zoom;
            var marginRightPx = jsObject.ConvertUnitToPixel(marginsUnit[2]) * jsObject.options.report.zoom;

            var pageSelector = horRuler.createPageSelector(pageWidthPx - marginLeftPx - marginRightPx, jsObject.options.rulerSize);
            pageSelector.style.left = marginLeftPx + "px";

            var scaleTable = horRuler.createScaleTable(rulerWidthPx, jsObject.options.rulerSize, "0 0 0 " + parseInt(marginLeftPx - scaleSizePx / 2) + "px");

            for (var i = 0; i < scaleCount; i++) {
                var text = horRuler.getScaleText(i);
                var cell = scaleTable.addTextCell(text);
                cell.style.height = (jsObject.options.rulerSize - 4) + "px";
                cell.className = "stiDesignerRulerScaleText";
                if (i < scaleCount - 1) cell.className += " stiDesignerHorRulerScaleLine";
            }

            horRuler.style.width = pageWidthPx + "px";
        }
    }

    horRuler.repaintCompSelector = function (compRect) {
        var compSelector = horRuler.compSelector || horRuler.createCompSelector(null, jsObject.options.rulerSize);
        compSelector.style.display = compRect ? "" : "none";

        if (compRect) {
            compSelector.style.left = compRect.left + "px";
            compSelector.style.width = (compRect.right - compRect.left) + "px";
        }
    }

    return horRuler;
}

StiMobileDesigner.prototype.InitializeVertRuler = function () {
    var jsObject = this;
    var vertRuler = this.options.vertRuler = this.InitializeBaseRuler();
    vertRuler.className = "stiDesignerRuler stiDesignerVertRuler";
    vertRuler.style.width = this.options.rulerSize + "px";
    vertRuler.style.top = (this.options.paintPanelPadding + this.options.rulerSize) + "px";

    vertRuler.repaintScales = function () {
        var currPage = jsObject.options.currentPage;
        if (currPage) {
            vertRuler.clear();

            var pageHeightPx = parseInt(currPage.getAttribute("height"));
            var pageHeightUnit = jsObject.StrToDouble(currPage.properties.unitHeight);
            var marginsUnit = vertRuler.getMarginsUnit(currPage);
            var scaleSizeUnit = vertRuler.getScaleSizeUnit();
            var scaleSizePx = jsObject.ConvertUnitToPixel(scaleSizeUnit) * jsObject.options.report.zoom;
            var scaleCount = parseInt((pageHeightUnit - marginsUnit[1] - marginsUnit[3]) / scaleSizeUnit) + 1;
            var rulerHeightPx = parseInt(scaleCount * scaleSizePx);
            var marginTopPx = jsObject.ConvertUnitToPixel(marginsUnit[1]) * jsObject.options.report.zoom;
            var marginBottomPx = jsObject.ConvertUnitToPixel(marginsUnit[3]) * jsObject.options.report.zoom;

            var pageSelector = vertRuler.createPageSelector(jsObject.options.rulerSize, pageHeightPx - marginTopPx - marginBottomPx);
            pageSelector.style.top = marginTopPx + "px";

            var scaleTable = vertRuler.createScaleTable(jsObject.options.rulerSize, rulerHeightPx, parseInt(marginTopPx - scaleSizePx / 2) + "px 0 0 0");

            for (var i = 0; i < scaleCount; i++) {
                var text = vertRuler.getScaleText(i);
                var cell = scaleTable.addTextCellInNextRow(text);
                cell.style.width = (jsObject.options.rulerSize - 4) + "px";
                cell.className = "stiDesignerRulerScaleText";
                if (i < scaleCount - 1) cell.className += " stiDesignerVertRulerScaleLine";
            }

            vertRuler.style.height = pageHeightPx + "px";
        }
    }

    vertRuler.repaintCompSelector = function (compRect) {
        var compSelector = vertRuler.compSelector || vertRuler.createCompSelector(jsObject.options.rulerSize, null);
        compSelector.style.display = compRect ? "" : "none";

        if (compRect) {
            compSelector.style.top = compRect.top + "px";
            compSelector.style.height = (compRect.bottom - compRect.top) + "px";
        }
    }

    return vertRuler;
}

StiMobileDesigner.prototype.RepaintRulers = function (scaleFactor) {
    var currentPage = this.options.currentPage;
    var showRulers = this.options.showRulers && currentPage && !currentPage.isDashboard;
    var horRuler = this.options.horRuler;
    var vertRuler = this.options.vertRuler;

    horRuler.style.display = vertRuler.style.display = showRulers ? "" : "none";

    if (!this.options.basePaintPanelPadding) {
        this.options.basePaintPanelPadding = this.options.paintPanelPadding;
    }

    this.options.paintPanelPadding = showRulers ? this.options.basePaintPanelPadding + this.options.rulerSize : this.options.basePaintPanelPadding;
    if (currentPage) currentPage.style.margin = this.options.paintPanelPadding + "px";

    if (showRulers) {
        if (!horRuler.parentElement && !vertRuler.parentElement) {
            this.options.paintPanel.appendChild(horRuler);
            this.options.paintPanel.appendChild(vertRuler);
        }
        horRuler.repaintScales();
        vertRuler.repaintScales();
        this.RepaintRulersSelectors(scaleFactor);
    }
}

StiMobileDesigner.prototype.RepaintRulersSelectors = function (scale, comps) {
    var currentPage = this.options.currentPage;
    var showRulers = this.options.showRulers && currentPage && !currentPage.isDashboard;
    if (showRulers) {
        var horRuler = this.options.horRuler;
        var vertRuler = this.options.vertRuler;

        var compsRect = this.GetRectForRulersSelectors(comps);

        if (compsRect && scale) {
            compsRect.left *= scale.scaleX;
            compsRect.right *= scale.scaleX;
            compsRect.top *= scale.scaleY;
            compsRect.bottom *= scale.scaleY;
        }

        horRuler.repaintCompSelector(compsRect);
        vertRuler.repaintCompSelector(compsRect);
    }
}

StiMobileDesigner.prototype.GetRectForRulersSelectors = function (comps) {
    var jsObject = this;
    var compsRect = null;
    var currComponents = comps || (jsObject.options.selectedObject ? [jsObject.options.selectedObject] : jsObject.options.selectedObjects);

    if (currComponents && currComponents.length > 0) {
        for (var i = 0; i < currComponents.length; i++) {
            var comp = currComponents[i];
            if (comp.typeComponent == "StiPage" || comp.typeComponent == "StiReport") continue;
            if (!compsRect) compsRect = {};
            var left = parseInt(comp.getAttribute("left"));
            var top = parseInt(comp.getAttribute("top"));
            var width = parseInt(comp.getAttribute("width"));
            var height = parseInt(comp.getAttribute("height"));
            if (!isNaN(left) && (compsRect.left == null || left < compsRect.left)) compsRect.left = left;
            if (!isNaN(top) && (compsRect.top == null || top < compsRect.top)) compsRect.top = top;
            if (!isNaN(width) && (compsRect.right == null || left + width > compsRect.right)) compsRect.right = left + width;
            if (!isNaN(height) && (compsRect.bottom == null || top + height > compsRect.bottom)) compsRect.bottom = top + height;
        }
    }

    return compsRect;
}