﻿
StiMobileDesigner.prototype.InitializeReportPanelSingleLine = function (reportPanel) {
    var jsObject = this;

    var mainTable = reportPanel.mainTableSingleLine = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "SingleLine" ? "" : "none";
    mainTable.style.height = (jsObject.options.ribbonSingleLineHeight - 2) + "px";
    mainTable.addCell(this.ReportPanelSingleLineReportSetupBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    reportPanel.appendChild(mainTable);

    reportPanel.updateSingleLineControls = function () {
        var buttonNames = ["reportSetupSingle", "previewSettingsSingle", "exportSettingsSingle", "globalizationSingle", "propertiesSingle"];

        for (var i = 0; i < buttonNames.length; i++) {
            var button = jsObject.options.buttons[buttonNames[i]];
            if (button) {
                button.setEnabled(jsObject.options.report != null);

                if (buttonNames[i] == "previewSettingsSingle") {
                    button.setMarkerVisibleState(button.isEnabled && jsObject.PreviewSettingsIsNotDefault());
                }
                if (buttonNames[i] == "exportSettingsSingle" && !jsObject.options.jsMode) {
                    button.setMarkerVisibleState(button.isEnabled && jsObject.ExportSettingsIsNotDefault());
                }
                if (buttonNames[i] == "globalizationSingle") {
                    button.setMarkerVisibleState(false);
                    var report = jsObject.options.report;

                    if (button.isEnabled && report) {
                        if (report.properties.globalizationStringsIsDefault != null) {
                            button.setMarkerVisibleState(!report.properties.globalizationStringsIsDefault);
                        }
                        else {
                            var globalButton = button;
                            jsObject.SendCommandGetGlobalizationStrings(function (answer) {
                                report.properties.globalizationStringsIsDefault = answer.globalizationStrings && answer.globalizationStrings.length == 0;
                                globalButton.setMarkerVisibleState(!report.properties.globalizationStringsIsDefault);
                            });
                        }
                    }
                }
            }
        }
    }
}

//Report Setup
StiMobileDesigner.prototype.ReportPanelSingleLineReportSetupBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();
    var reportSetupText = this.loc.MainMenu.menuFileReportSetup.replace("...", "").replace("&", "");

    var buttons = [
        [this.SingleLineRibbonButton("reportSetupSingle", null, reportSetupText, "ReportPanel.SingleLine.ReportSetup.png", [reportSetupText, this.GetHelpLink("report")], null, null, null, null, null, true), "reportPanelReportSetup"],
        [this.SingleLineRibbonButton("previewSettingsSingle", null, this.loc.PropertyMain.PreviewSettings, "ReportPanel.SingleLine.Preview.png", [this.loc.PropertyMain.PreviewSettings, this.GetHelpLink("report")], null, null, null, null, null, true), "reportPanelPreviewSettings"],
        [this.SingleLineRibbonButton("exportSettingsSingle", null, this.loc.PropertyMain.ExportSettings, "ReportPanel.SingleLine.ExportSettings.png", [this.loc.PropertyMain.ExportSettings, this.GetHelpLink("report")], null, null, null, null, null, true), "reportPanelExportSettings"],
        [this.SingleLineRibbonButton("globalizationSingle", null, this.loc.PropertyCategory.GlobalizationCategory, "ReportPanel.SingleLine.Globalization.png", [this.loc.PropertyCategory.GlobalizationCategory, this.GetHelpLink("report")], null, null, null, null, null, true), "reportPanelGlobalization"],
        [this.SingleLineRibbonButton("propertiesSingle", null, this.loc.Panels.Properties, "Properties.png", [this.loc.Panels.Properties, this.GetHelpLink("report")], null, null, null, null, null, true), "reportPanelProperties"]
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i][0];
        button.cloneName = buttons[i][1];
        button.style.margin = "0 2px 0 2px";

        if (button.cloneName == "reportPanelExportSettings" && jsObject.options.jsMode)
            continue;

        table.addCell(button);

        if (button.cloneName == "reportSetup" || button.cloneName == "globalization") {
            table.addCell(jsObject.RibbonPanelSingleLineSeparator());
        }

        button.action = function () {
            var cloneButton = jsObject.options.buttons[this.cloneName];
            if (cloneButton) cloneButton.action();
        }
    }

    return table;
}