﻿
StiMobileDesigner.prototype.TableCellsPropertiesGroup = function () {
    var jsObject = this;
    var group = this.PropertiesGroup("tableCellsPropertiesGroup", this.loc.PropertyMain.Cells, null, 1);
    group.style.display = "none";
    group.innerGroups = {};

    var groupNames = [
        ["columns", this.loc.PropertyMain.Columns, "main", 1],
        ["data", this.loc.PropertyMain.Data, "main", 1],
        ["rows", this.loc.PropertyMain.Rows, "main", 1],
        ["totals", this.loc.PropertyMain.Totals, "main", 1]
    ]

    for (var i = 0; i < groupNames.length; i++) {
        var innerGroup = this.PropertiesGroup(null, groupNames[i][1], null, groupNames[i][3]);
        group.innerGroups[groupNames[i][0]] = innerGroup;
        innerGroup.parentGroup = groupNames[i][2] == "main" ? group : group.innerGroups[groupNames[i][2]];
    }

    var props = [
        ["cellsColumnsBackColor", this.loc.PropertyMain.BackColor, this.PropertyColorControl("controlPropertyCellsColumnsBackColor", null, this.options.propertyControlWidth - 5), "columns"],
        ["cellsColumnsFont", this.loc.PropertyMain.Font, this.PropertyFontControl("cellsColumnsFont", "cellsColumnsFont", null, null, 1), "columns"],
        ["cellsColumnsForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyCellsColumnsForeColor", null, this.options.propertyControlWidth - 5), "columns"],
        ["cellsDataBackColor", this.loc.PropertyMain.BackColor, this.PropertyColorControl("controlPropertyCellsDataBackColor", null, this.options.propertyControlWidth - 5), "data"],
        ["cellsDataFont", this.loc.PropertyMain.Font, this.PropertyFontControl("cellsDataFont", "cellsDataFont", null, null, 1), "data"],
        ["cellsDataForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyCellsDataForeColor", null, this.options.propertyControlWidth - 5), "data"],
        ["cellsRowsBackColor", this.loc.PropertyMain.BackColor, this.PropertyColorControl("controlPropertyCellsRowsBackColor", null, this.options.propertyControlWidth - 5), "rows"],
        ["cellsRowsFont", this.loc.PropertyMain.Font, this.PropertyFontControl("cellsRowsFont", "cellsRowsFont", null, null, 1), "rows"],
        ["cellsRowsForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyCellsRowsForeColor", null, this.options.propertyControlWidth - 5), "rows"],
        ["cellsTotalsBackColor", this.loc.PropertyMain.BackColor, this.PropertyColorControl("controlPropertyCellsTotalsBackColor", null, this.options.propertyControlWidth - 5), "totals"],
        ["cellsTotalsFont", this.loc.PropertyMain.Font, this.PropertyFontControl("cellsTotalsFont", "cellsTotalsFont", null, null, 1), "totals"],
        ["cellsTotalsForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyCellsTotalsForeColor", null, this.options.propertyControlWidth - 5), "totals"]
    ]

    for (var i = 0; i < props.length; i++) {
        var control = props[i][2];
        control.propertyName = props[i][0];
        var currentGroup = props[i][3] == "main" ? group : group.innerGroups[props[i][3]];
        currentGroup.container.appendChild(this.Property(props[i].length > 4 ? props[i][4] : props[i][0], props[i][1], control, null, currentGroup.nestingLevel));

        control.action = function () {
            jsObject.ApplyPropertyValue(this.propertyName, jsObject.GetControlValue(this));
        }
    }

    for (var i = 0; i < groupNames.length; i++) {
        group.innerGroups[groupNames[i][0]].parentGroup.container.appendChild(group.innerGroups[groupNames[i][0]]);
    }

    return group;
}