﻿
StiMobileDesigner.prototype.RegionMapElementPropertiesGroup = function () {
    var jsObject = this;
    var group = this.PropertiesGroup("regionMapElementPropertiesGroup", this.loc.PropertyCategory.RegionMapCategory);
    group.style.display = "none";

    group.innerGroups = {};

    var groupNames = [
        ["labels", this.loc.PropertyCategory.LabelsCategory, "main", 1]
    ]

    for (var i = 0; i < groupNames.length; i++) {
        var innerGroup = this.PropertiesGroup(null, groupNames[i][1], null, groupNames[i][3]);
        group.innerGroups[groupNames[i][0]] = innerGroup;
        innerGroup.parentGroup = groupNames[i][2] == "main" ? group : group.innerGroups[groupNames[i][2]];
    }

    var props = [
        ["crossFiltering", this.loc.PropertyMain.CrossFiltering, this.CheckBox("controlPropertyRegionMapElementCrossFiltering"), "main", "crossFilteringRegionMap"],
        ["dataTransformation", this.loc.PropertyMain.DataTransformation, this.PropertyDataTransformationControl("regionMapElementDataTransformation", this.options.propertyControlWidth), "main", "dataTransformationRegionMap"],
        ["group", this.loc.PropertyMain.Group, this.PropertyTextBox("controlPropertyRegionMapElementGroup", this.options.propertyControlWidth), "main", "groupRegionMap"],
        ["mapLabelsFont", this.loc.PropertyMain.Font, this.PropertyFontControl("controlPropertyRegionMapLabelsFont", null, true), "labels", "labelsFontRegionMap"],
        ["mapLabelsForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyRegionMapLabelsForeColor", null, this.options.propertyControlWidth, true), "labels", "labelsForeColorRegionMap"],
        ["mapLabelsShadowColor", this.loc.PropertyMain.ShadowColor, this.PropertyColorControl("controlPropertyRegionMapLabelsShadowColor", null, this.options.propertyControlWidth, true), "labels", "labelsShadowColorRegionMap"],
        ["mapLabelsShowShadow", this.loc.PropertyMain.ShowShadow, this.CheckBox("controlPropertyRegionMapLabelsShowShadow"), "labels", "labelsShowShadowRegionMap"],
        ["show3D", this.loc.PropertyMain.Show3D, this.CheckBox("controlPropertyRegionMapElementShow3D"), "main", "show3DRegionMap"],
        ["showValue", this.loc.PropertyMain.ShowValue, this.CheckBox("controlPropertyRegionMapElementShowValue"), "main", "showValueRegionMap"],
        ["showZeros", this.loc.PropertyMain.ShowZeros, this.CheckBox("controlPropertyRegionMapElementShowZeros"), "main", "showZerosRegionMap"]
    ]

    for (var i = 0; i < props.length; i++) {
        var control = props[i][2];
        control.propertyName = props[i][0];
        var currentGroup = props[i][3] == "main" ? group : group.innerGroups[props[i][3]];
        currentGroup.container.appendChild(this.Property(props[i].length > 4 ? props[i][4] : props[i][0], props[i][1], control, null, currentGroup.nestingLevel));

        control.action = function () {
            jsObject.ApplyPropertyValue(this.propertyName, jsObject.GetControlValue(this));
        }
    }

    for (var i = 0; i < groupNames.length; i++) {
        group.innerGroups[groupNames[i][0]].parentGroup.container.appendChild(group.innerGroups[groupNames[i][0]]);
    }

    return group;
}

