
StiMobileDesigner.prototype.PropertyDashboardInteractionControl = function (name, width, height) {
    var control = this.PropertyTextBoxWithEditButton(name, width, true, true, height);
    control.key = null;

    control.button.action = function () {
        this.jsObject.InitializeDashboardInteractionForm(function (form) {
            control.preOpening();
            form.show(control.key, control.columnNames);

            form.action = function () {
                form.changeVisibleState(false);
                control.setKey(form.getResultInteraction());
                control.action();
            }
        });
    }

    control.clearButton.action = function () {
        control.setToDefault();
        control.action();
    }

    control.setKey = function (key) {
        this.key = key;
        this.textBox.value = "[" + (this.isDefault() ? this.jsObject.loc.PropertyMain.Default : this.jsObject.loc.FormFormatEditor.Custom) + "]";
        this.clearButton.setEnabled(!this.isDefault());
    }

    control.setToDefault = function () {
        if (this.key) {
            this.key.hyperlinkDestination = "NewTab";
            this.key.hyperlink = "";
            this.key.toolTip = "";
            this.key.drillDownPageKey = "";
            this.key.drillDownParameters = [];
            this.key.allowUserFiltering = true;
            this.key.allowUserSorting = true;
            this.key.allowUserColumnSelection = true;
            this.key.showFullScreenButton = true;
            this.key.showSaveButton = true;
            this.key.showViewDataButton = true;
            this.key.drillDownFiltered = true;
            this.key.fullRowSelect = false;

            switch (this.key.ident) {
                case "TableColumn":
                case "CardsColumn": {
                    this.key.onHover = "None";
                    this.key.onClick = "None";
                    break;
                }
                case "Table":
                case "Cards":
                case "Chart":
                case "RegionMap": {
                    this.key.onHover = "ShowToolTip";
                    this.key.onClick = "ApplyFilter";
                    break;
                }
                case "Gauge": {
                    this.key.onHover = "ShowToolTip";
                    this.key.onClick = "None";
                    break;
                }
                case "Text":
                case "Image": {
                    this.key.onHover = "ShowToolTip";
                    this.key.onClick = "OpenHyperlink";
                    break;
                }
                default: {
                    this.key.onHover = "None";
                    this.key.onClick = "None";
                }
            }
        }
        control.clearButton.setEnabled(false);
        this.textBox.value = "[" + this.jsObject.loc.PropertyMain.Default + "]";
    }

    control.isDefault = function () {
        return this.key && this.key.isDefault;
    }

    control.preOpening = function () { };

    return control;
}