﻿
StiMobileDesigner.prototype.PropertyColorExpressionControl = function (name, toolTip, width) {
    var jsObject = this;
    var colorControl = this.PropertyColorControl(name, toolTip, width);
    colorControl.cutBrackets = true;
    if (name) this.options.controls[name] = colorControl;

    colorControl.button.action = function () {
        var colorDialog = this.jsObject.options.menus.colorDialog || this.jsObject.InitializeColorDialog();
        colorDialog.rightToLeft = this.colorControl.rightToLeft;
        colorDialog.noFillButton.caption.innerHTML = colorControl.isDbsElement && !colorDialog.visible
            ? this.jsObject.loc.FormStyleDesigner.FromStyle
            : this.jsObject.loc.PropertyColor.Transparent;

        colorDialog.changeVisibleState(!colorDialog.visible, this);
        colorDialog.showExpression(colorControl.expression);

        colorDialog.expressionPanel.expressionButton.action = function () {
            colorDialog.changeVisibleState(false, colorControl.button);

            jsObject.InitializeExpressionEditorForm(function (form) {
                form.resultControl = colorControl;

                form.onshow = function () {
                    if (form.dictionaryPanel && form.expDictionaryTree) {
                        form.dictionaryPanel.addDictionaryTreeToPanel(form.expDictionaryTree);
                        form.expDictionaryTree.build(jsObject.options.report.dictionary, true);
                        form.expDictionaryTree.currentEditor = form.expressionTextArea;
                    }
                    form.expressionTextArea.value = colorControl.expression || colorControl.getExpressionFromColor();
                    form.expressionTextArea.focus();

                    jsObject.AddHintHelperToControl(form.expressionTextArea, 40, false, true, ["\"Red\"", "RGB(255, 0, 0)", "\"33ff95\"", "MyStringVariable", "MyData.MyColumn > 0 ? \"Red\" : \"Green\""]);
                }

                form.action = function () {
                    colorControl.setKey(colorControl.key, colorControl.isDbsElement, form.expressionTextArea.value != "" ? form.expressionTextArea.value : null);
                    form.changeVisibleState(false);
                    colorControl.action();
                }

                form.changeVisibleState(true);
            });
        }
    }

    colorControl.getExpressionFromColor = function () {
        return "\"" + colorControl.strColorToHex(this.key) + "\"";
    }

    colorControl.strColorToHex = function (strColor) {
        if (strColor) {
            if (strColor == "transparent") return "#00FFFFFF";
            var colors = strColor.split(",");
            return jsObject.RgbToHex(parseInt(colors[0]), parseInt(colors[1]), parseInt(colors[2]), colors.length > 3 ? parseInt(colors[3]) : null).toUpperCase();
        }
        return "";
    }

    colorControl.setKey = function (key, isDbsElement, expression) {
        var notLocalizeValues = this.ownerIsProperty && jsObject.options.propertiesPanel && !jsObject.options.propertiesPanel.localizePropertyGrid;
        this.key = key;
        this.expression = expression;
        this.isDbsElement = isDbsElement;

        if (expression) {
            this.button.image.style.display = "none";
            this.textField.value = expression;
        }
        else {
            this.button.image.style.display = "";
            if (key == "StiEmptyValue") {
                this.button.image.style.opacity = 0;
                this.textField.value = "";
                return;
            }
            this.button.image.style.opacity = 1;
            var color;
            if (key == "transparent")
                color = "255,255,255";
            else {
                var colors = key.split(",");
                if (colors.length == 4) {
                    this.button.image.style.opacity = jsObject.StrToInt(colors[0]) / 255;
                    colors.splice(0, 1);
                }
                color = colors[0] + "," + colors[1] + "," + colors[2];
            }

            this.button.image.style.background = "rgb(" + color + ")";
            var colorName = jsObject.GetColorNameByRGB(this.key, notLocalizeValues);
            var hexColor = this.key == "transparent" || this.key == "0,255,255,255" ? jsObject.loc.PropertyColor.Transparent : jsObject.RgbColorStrToHexColor(this.key).toUpperCase();
            this.textField.value = (isDbsElement && key == "transparent") ? (notLocalizeValues ? "FromStyle" : jsObject.loc.FormStyleDesigner.FromStyle) : (colorName || hexColor);
        }
    };

    return colorControl;
}