﻿
StiMobileDesigner.prototype.MapPropertiesGroup = function () {
    var jsObject = this;
    var group = this.PropertiesGroup("mapPropertiesGroup", this.loc.Components.StiMap);
    group.style.display = "none";
    group.innerGroups = {};

    var groupNames = [
        ["labels", this.loc.PropertyCategory.LabelsCategory, "main", 1]
    ]

    for (var i = 0; i < groupNames.length; i++) {
        var innerGroup = this.PropertiesGroup(null, groupNames[i][1], null, groupNames[i][3]);
        group.innerGroups[groupNames[i][0]] = innerGroup;
        innerGroup.parentGroup = groupNames[i][2] == "main" ? group : group.innerGroups[groupNames[i][2]];
    }

    var props = [
        ["colorEach", this.loc.PropertyMain.ColorEach, this.CheckBox(), "main", "colorEachMap"],
        ["displayNameType", this.loc.PropertyMain.DisplayNameType, this.PropertyDropDownList("controlPropertyMapDisplayNameType", this.options.propertyControlWidth, this.GetMapDisplayNameTypeItems(), true), "main", "displayNameTypeMap"],
        ["show3D", this.loc.PropertyMain.Show3D, this.CheckBox(), "main", "show3DMap"],
        ["showValue", this.loc.PropertyMain.ShowValue, this.CheckBox(), "main", "showValueMap"],
        ["showZeros", this.loc.PropertyMain.ShowZeros, this.CheckBox(), "main", "showZerosMap"],
        ["userBingKey", this.loc.PropertyMain.UserBingKey || "User Bing Key", this.PropertyTextBox("controlPropertyOnlineMapUserBingKey", this.options.propertyControlWidth), "main", "userBingKeyMap"],
		["onePointZoom", this.loc.PropertyMain.OnePointZoom || "One Point Zoom", this.PropertyTextBox("controlPropertyMapOnePointZoom", this.options.propertyNumbersControlWidth), "main", "onePointZoomMap"],
        ["stretch", this.loc.PropertyMain.Stretch, this.CheckBox(), "main", "stretchMap"],
        ["mapLabelsFont", this.loc.PropertyMain.Font, this.PropertyFontControl("controlPropertyMapLabelsFont", null, true), "labels", "labelsFontMap"],
        ["mapLabelsForeColor", this.loc.PropertyMain.ForeColor, this.PropertyColorControl("controlPropertyMapLabelsForeColor", null, this.options.propertyControlWidth, true), "labels", "labelsForeColorMap"],
        ["mapLabelsShadowColor", this.loc.PropertyMain.ShadowColor, this.PropertyColorControl("controlPropertyMapLabelsShadowColor", null, this.options.propertyControlWidth, true), "labels", "labelsShadowColorMap"],
        ["mapLabelsShowShadow", this.loc.PropertyMain.ShowShadow, this.CheckBox(), "labels", "labelsShowShadowMap"]
    ]

    for (var i = 0; i < props.length; i++) {
        var control = props[i][2];
        control.propertyName = props[i][0];
        var currentGroup = props[i][3] == "main" ? group : group.innerGroups[props[i][3]];
        currentGroup.container.appendChild(this.Property(props[i].length > 4 ? props[i][4] : props[i][0], props[i][1], control, null, currentGroup.nestingLevel));

        control.action = function () {
            jsObject.ApplyPropertyValue(this.propertyName, jsObject.GetControlValue(this));
        }
    }

    for (var i = 0; i < groupNames.length; i++) {
        group.innerGroups[groupNames[i][0]].parentGroup.container.appendChild(group.innerGroups[groupNames[i][0]]);
    }

    return group;
}