﻿
StiMobileDesigner.prototype.InitializeDictionarySettingsMenu = function (parentButton) {
    var jsObject = this;
    var dictMenu = this.VerticalMenu("dictionarySettingsMenu", parentButton, "Down");
    dictMenu.controls = {};

    var settingsControls = [
        ["commonGroup", this.FormBlockHeader(this.loc.Chart.Common)],
        ["createFieldOnDoubleClick", this.CheckBoxMenuItem(null, this.loc.PropertyMain.CreateFieldOnDoubleClick)],
        ["createLabel", this.CheckBoxMenuItem(null, this.loc.PropertyMain.CreateLabel)],
        ["useAliases", this.CheckBoxMenuItem(null, this.loc.PropertyMain.UseAliases)],
        ["showFind", this.CheckBoxMenuItem(null, this.loc.Buttons.ShowSpecific.replace("{0}", this.loc.FormViewer.Find))]
    ]
        
    var setSettingsToCookie = function () {
        var settings = {};
        settings.createFieldOnDoubleClick = dictMenu.controls.createFieldOnDoubleClick.isChecked;
        settings.createLabel = dictMenu.controls.createLabel.isChecked;
        jsObject.options.useAliases = settings.useAliases = dictMenu.controls.useAliases.isChecked;
        settings.sort = dictMenu.controls.ascending.isChecked ? "ascending" : (dictMenu.controls.descending.isChecked ? "descending" : "noSorting");
        StiMobileDesigner.SetCookie("StiMobileDesignerDictionarySettings", JSON.stringify(settings));
    }

    for (var i = 0; i < settingsControls.length; i++) {
        var control = settingsControls[i][1];
        control.name = settingsControls[i][0];
        dictMenu.controls[control.name] = control;
        dictMenu.innerContent.appendChild(control);

        if (control.name != "commonGroup") {
            control.action = function () {
                setSettingsToCookie();

                if (this.name == "showFind") {
                    if (this.isChecked != jsObject.options.showDictionaryFind) {
                        jsObject.options.dictionaryPanel.findControl.changeVisibleState(this.isChecked);
                        jsObject.options.showDictionaryFind = this.isChecked;
                        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerShowDictionaryFind", this.isChecked.toString());
                    }
                }

                if (this.name == "useAliases") {
                    jsObject.SendCommandUpdateReportAliases();
                }
            }
        }
    }

    dictMenu.innerContent.appendChild(jsObject.VerticalMenuSeparator(dictMenu));

    var subMenuAction = function (menuItem) {
        var name = menuItem.name;

        if (name == "ascending" || name == "descending" || name == "noSorting") {
            dictMenu.controls.ascending.setChecked(name == "ascending");
            dictMenu.controls.descending.setChecked(name == "descending");
            dictMenu.controls.noSorting.setChecked(name == "noSorting");
            jsObject.options.dictionarySorting = name;

            if (jsObject.options.report) {
                if (name == "noSorting")
                    jsObject.SendCommandSynchronizeDictionary();
                else
                    jsObject.options.dictionaryTree.build(jsObject.options.report.dictionary, true);
            }
        }

        setSettingsToCookie();
    }

    //Sort
    var sortItem = this.VerticalMenuItem(dictMenu, "sort", this.loc.PropertyMain.Sort, "Empty16.png", "Sort", null, true);
    dictMenu.innerContent.appendChild(sortItem);

    var sortMenu = this.InitializeSubMenu("sortDictionaryMenu", [], sortItem, dictMenu, null, 28);

    var ascendingItem = dictMenu.controls.ascending = this.CheckBoxMenuItem("ascending", this.loc.FormBand.Ascending);
    ascendingItem.action = function () { subMenuAction(this); }
    sortMenu.innerContent.appendChild(ascendingItem);

    var descendingItem = dictMenu.controls.descending = this.CheckBoxMenuItem("descending", this.loc.FormBand.Descending);
    descendingItem.action = function () { subMenuAction(this); }
    sortMenu.innerContent.appendChild(descendingItem);

    var noSortingItem = dictMenu.controls.noSorting = this.CheckBoxMenuItem("noSorting", this.loc.FormBand.NoSort);
    noSortingItem.action = function () { subMenuAction(this); }
    sortMenu.innerContent.appendChild(noSortingItem);
        
    var settings = {
        createFieldOnDoubleClick: false,
        createLabel: false,
        useAliases: false,
        sort: "noSorting"
    };

    var jsonSettings = StiMobileDesigner.GetCookie("StiMobileDesignerDictionarySettings");
    if (jsonSettings) settings = JSON.parse(jsonSettings);

    dictMenu.controls.createFieldOnDoubleClick.setChecked(settings.createFieldOnDoubleClick);
    dictMenu.controls.createLabel.setChecked(settings.createLabel);
    dictMenu.controls.useAliases.setChecked(jsObject.options.useAliasesDictionary == "Auto" ? settings.useAliases : jsObject.options.useAliasesDictionary == "True");
    dictMenu.controls.showFind.setChecked(jsObject.options.showDictionaryFind);

    dictMenu.controls.ascending.setChecked(settings.sort == "ascending");
    dictMenu.controls.descending.setChecked(settings.sort == "descending");
    dictMenu.controls.noSorting.setChecked(settings.sort == "noSorting" || !settings.sort);

    setSettingsToCookie();

    return dictMenu;
}