﻿
StiMobileDesigner.prototype.InitializeDictionaryChangeDBTypeMenu = function (parentMenu) {
    var jsObject = this;
    var menu = this.InitializeSubMenu("dictionaryChangeDBType", this.GetDictionaryChangeDBTypeItems(), parentMenu.items["changeDatabaseType"], parentMenu, "stiDesignerMenuMiddleItem", null, { width: 32, height: 32 });

    menu.onshow = function () {
        var selectedItem = jsObject.options.dictionaryTree.selectedItem;

        for (var itemName in this.items) {
            var item = this.items[itemName];
            item.style.display = selectedItem && selectedItem.itemObject.typeConnection == item.key ? "none" : "";
        }
    }

    menu.action = function (menuItem) {
        parentMenu.changeVisibleState(false);
        menu.changeVisibleState(false);

        var messageForm = jsObject.InitializeMessageForm();
        messageForm.messageText = jsObject.loc.Messages.DatabaseTypeChangeWarning.replace("{0}", menuItem.caption.innerText);
        messageForm.caption.innerHTML = jsObject.loc.FormDesigner.title.toUpperCase();
        messageForm.buttonCancel.style.display = "none";

        messageForm.changeVisibleState(true);
        messageForm.action = function (state) {
            if (state) {
                var selectedItem = jsObject.options.dictionaryTree.selectedItem;
                if (selectedItem && selectedItem.itemObject.typeItem == "DataBase") {
                    var newDatabaseType = menuItem.key;
                    var currentDatabaseName = selectedItem.itemObject.name;

                    jsObject.SendCommandToDesignerServer("PrepareToChangeDatabaseType", { newDatabaseType: newDatabaseType, currentDatabaseName: currentDatabaseName }, function (answer) {
                        if (answer.newItemObject) {
                            jsObject.InitializeEditConnectionForm(function (form) {
                                form.connection = answer.newItemObject;
                                form.connection.isChangeDatabaseType = true;
                                form.changeVisibleState(true);
                            });
                        }
                    });
                }
            }
        }
    }

    return menu;
}