
StiMobileDesigner.prototype.GetThemeTonesItems = function () {
    var items = [];
    items.push({ name: "White", color: "white" });
    items.push({ name: "LightGray", color: "#f6f6f6" });
    items.push({ name: "DarkGray", color: "#e5e5e5" });
    items.push({ name: "VeryDarkGray", color: "#6a6a6a" });

    return items;
}

StiMobileDesigner.prototype.GetThemeAccentsItems = function () {
    var items = [];
    items.push({ name: "Blue", color: "#2b579a" });
    items.push({ name: "Carmine", color: "#a4373a" });
    items.push({ name: "Green", color: "#207245" });
    items.push({ name: "Orange", color: "#d14625" });
    items.push({ name: "Purple", color: "#8653a5" });
    items.push({ name: "Teal", color: "#077568" });
    items.push({ name: "Violet", color: "#6d3069" });

    return items;
}

StiMobileDesigner.prototype.GetCurrentThemeIdent = function () {
    var theme = this.options.theme || "Office2022WhiteBlue";
    if (theme.indexOf("Office2013") >= 0) return "Office2013";
    else return "Office2022";
}

StiMobileDesigner.prototype.GetCurrentThemeTone = function () {
    var theme = this.options.theme || "Office2022WhiteBlue";
    if (theme.indexOf("VeryDarkGray") >= 0) return "VeryDarkGray";
    else if (theme.indexOf("DarkGray") >= 0) return "DarkGray";
    else if (theme.indexOf("LightGray") >= 0) return "LightGray";
    else if (theme.indexOf("Black") >= 0) return "Black";
    else return "White";
}

StiMobileDesigner.prototype.GetCurrentThemeAccent = function () {
    var theme = this.options.theme || "Office2022WhiteBlue";
    return theme.replace(this.GetCurrentThemeTone(), "").replace("Office2013", "").replace("Office2022", "");
}

StiMobileDesigner.prototype.getSelectedButton = function (groupName) {
    for (var i in this.options.buttons) {
        if (this.options.buttons[i].groupName == groupName && this.options.buttons[i].isSelected) {
            return this.options.buttons[i];
        }
    }
}

StiMobileDesigner.prototype.OverrideOptionsForm = function () {
    var jsObject = this;

    this.OldInitializeOptionsForm = this.InitializeOptionsForm;
    this.InitializeOptionsForm = function () {
        this.OldInitializeOptionsForm(function (optionsForm) {
            //Add theme panel
            var container = document.createElement("Div");
            container.className = "stiDesignerEditFormPanel";
            container.style.overflow = "hidden";
            optionsForm.panels.Gui.appendChild(container);

            container.appendChild(jsObject.FormBlockHeader(jsObject.loc.Gui.colorpicker_themecolorslabel));

            var innerTable = jsObject.CreateHTMLTable();
            innerTable.style.margin = "6px 0 6px 0";
            container.appendChild(innerTable);

            var themeItems = [
                jsObject.Item("Office2013", "Office2013", null, "Office2013"),
                jsObject.Item("Office2022", "Office2022", null, "Office2022")
            ];

            var themeControl = jsObject.DropDownList("optionsFormTheme", 180, null, themeItems, true, false, null, true);
            themeControl.style.margin = "6px 0 6px 0";
            themeControl.setKey(jsObject.GetCurrentThemeIdent());

            var themeCaption = innerTable.addTextCellInLastRow(jsObject.loc.PropertyMain.Style);
            themeCaption.className = "stiDesignerCaptionControlsBigIntervals";
            themeCaption.style.width = "100px";
            innerTable.addCellInLastRow(themeControl);

            innerTable.addTextCellInNextRow(jsObject.loc.Options.LabelBackground.replace(":", "")).className = "stiDesignerCaptionControlsBigIntervals";

            var themeTonesPanel = $("<div></div>")[0];
            themeTonesPanel.style.height = "28px";
            themeTonesPanel.style.margin = "6px 0 6px 0";
            var themeTones = jsObject.GetThemeTonesItems();
            var currentThemeTone = jsObject.GetCurrentThemeTone();

            var autoToneButton = jsObject.ThemeAutoToneButton("autoThemeTone", "themeTone");
            themeTonesPanel.appendChild(autoToneButton);

            var sep1 = jsObject.HomePanelSeparator();
            sep1.style.float = "left";
            sep1.style.margin = "2px 5px 2px 0px";
            themeTonesPanel.appendChild(sep1);

            for (var i = 0; i < themeTones.length; i++) {
                var button = jsObject.ThemeColorButton(themeTones[i].color, "themeTone" + themeTones[i].color, "themeTone", themeTones[i].name);
                if (!jsObject.options.isAutoThemeMode && (currentThemeTone == themeTones[i].name || (currentThemeTone == "Black" && themeTones[i].name == "VeryDarkGray"))) {
                    button.setSelected(true);
                }
                themeTonesPanel.appendChild(button);
            }
            innerTable.addCellInLastRow(themeTonesPanel);

            if (jsObject.options.isAutoThemeMode) {
                autoToneButton.setSelected(true);
            }

            innerTable.addTextCellInNextRow(jsObject.loc.Options.LabelForeground.replace(":", "")).className = "stiDesignerCaptionControlsBigIntervals";

            var themeAccentPanel = $("<div></div>")[0];
            themeAccentPanel.style.height = "28px";
            themeAccentPanel.style.margin = "6px 0 6px 0";
            var themeAccents = jsObject.GetThemeAccentsItems();

            var customAccentButton = optionsForm.customAccentButton = jsObject.ThemeCustomAccentButton("customAccent", "themeAccent", "custom");

            var sep2 = jsObject.HomePanelSeparator();
            sep2.style.float = "left";
            sep2.style.margin = "2px 5px 2px 0px";

            themeAccentPanel.appendChild(customAccentButton);
            themeAccentPanel.appendChild(sep2);

            for (var i = 0; i < themeAccents.length; i++) {
                var button = jsObject.ThemeColorButton(themeAccents[i].color, "themeAccent" + themeAccents[i].name, "themeAccent", themeAccents[i].name);
                if (!jsObject.options.customThemeAccent && jsObject.GetCurrentThemeAccent() == themeAccents[i].name) {
                    button.setSelected(true);
                }
                themeAccentPanel.appendChild(button);
            }

            if (jsObject.options.customThemeAccent) {
                customAccentButton.setSelected(true);
                var rgb = jsObject.HexToRgb(jsObject.options.customThemeAccent);
                customAccentButton.setKey((rgb ? rgb.r : 0) + "," + (rgb ? rgb.g : 0) + "," + (rgb ? rgb.b : 0));
            }

            innerTable.addCellInLastRow(themeAccentPanel);

            optionsForm.restoreDefaults.action = function () {
                optionsForm.fill(jsObject.options.defaultDesignerOptions);
                for (var i = 0; i < themeTonesPanel.childNodes.length; i++) {
                    var button = themeTonesPanel.childNodes[i];
                    if (button.value == "White") button.onclick();
                }
                for (var i = 0; i < themeAccentPanel.childNodes.length; i++) {
                    var button = themeAccentPanel.childNodes[i];
                    if (button.value == "Blue") button.onclick();
                }
            }

            optionsForm.oldAction = optionsForm.action;

            optionsForm.action = function () {
                optionsForm.oldAction();

                var themeIdent = themeControl.key;
                var themeTone = jsObject.getSelectedButton("themeTone").value;
                var themeAccent = jsObject.getSelectedButton("themeAccent").value;

                if (themeIdent == "Office2022" && themeTone == "VeryDarkGray") {
                    themeTone = "Black";
                }

                jsObject.options.customThemeAccent = themeAccent == "custom" && optionsForm.customAccentButton.key ? jsObject.RgbColorStrToHexColor(optionsForm.customAccentButton.key) : "";
                StiMobileDesigner.SetCookie("StimulsoftCustomThemeAccent", jsObject.options.customThemeAccent);

                var newTheme = autoToneButton.isSelected ? "Auto" : (themeIdent + themeTone + themeAccent);

                if (jsObject.options.theme != newTheme) {
                    if (themeAccent == "custom") {
                        jsObject.LoadStyle(jsObject.options.stylesUrl + "&stiweb_customaccent=" + jsObject.options.customThemeAccent.replace("#", ""), true);

                        if (jsObject.options.viewer) {
                            var jsViewer = jsObject.options.viewer.jsObject;
                            var viewerStylesUrl = jsViewer.options.appearance.customStylesUrl || jsViewer.GetResourceUrl("styles");
                            viewerStylesUrl += "&stiweb_customaccent=" + jsObject.options.customThemeAccent.replace("#", "");
                            jsViewer.LoadStyle(viewerStylesUrl, true);
                        }
                    }
                    else {
                        var messageForm = jsObject.InitializeMessageForm();

                        messageForm.messageText = jsObject.options.helpLanguage == "ru" ? "Перезагрузить дизайнер, чтобы применить новую тему?" : "Restart designer to apply new theme?";
                        messageForm.caption.innerHTML = jsObject.loc.FormDesigner.title.toUpperCase();
                        messageForm.buttonNo.style.display = "none";
                        messageForm.buttonOk.caption.innerHTML = jsObject.loc.Buttons.Ok.replace("&", "");
                        messageForm.changeVisibleState(true);

                        messageForm.action = function (state) {
                            if (state) {
                                var cloudParameters = jsObject.options.cloudParameters;

                                var designerParams = {
                                    cp: jsObject.GetCloudPlanNumberValue(),
                                    localizationName: cloudParameters.localizationName || jsObject.options.cultureName,
                                    themeName: newTheme
                                }

                                if (autoToneButton.isSelected) {
                                    designerParams.themeIdent = themeIdent;
                                    designerParams.themeAccent = themeAccent;
                                }

                                if (cloudParameters.sessionKey) {
                                    designerParams.sessionKey = cloudParameters.sessionKey;
                                    designerParams.userKey = cloudParameters.userKey;

                                    if (cloudParameters.reportTemplateItemKey) {
                                        designerParams.reportTemplateItemKey = cloudParameters.reportTemplateItemKey;
                                        designerParams.reportType = cloudParameters.isDashboard ? "dbs" : "rep";
                                        if (cloudParameters.versionKey) designerParams.versionKey = cloudParameters.versionKey;
                                    }
                                }
                                else {
                                    designerParams.demomode = true;
                                }

                                if (cloudParameters.reportName) designerParams.reportName = StiBase64.encode(cloudParameters.reportName);

                                jsObject.PostForm({ "designerParams": StiBase64.encode(JSON.stringify(designerParams)) }, document, window.location.href, true);
                            }
                        }
                    }
                }
            }

            optionsForm.show();
        });
    }
}