﻿
StiMobileDesigner.prototype.InitializeLayoutPanel = function () {
    var jsObject = this;
    var layoutPanel = this.ChildWorkPanel("layoutPanel");
    layoutPanel.style.display = "none";

    var mainTable = layoutPanel.mainTableClassic = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "Classic" ? "" : "none";
    mainTable.addCell(this.LayoutPanelArrangeBlock());
    mainTable.addCell(this.GroupBlockSeparator());
    mainTable.addCell(this.LayoutPanelDesignBlock());
    mainTable.addCell(this.GroupBlockSeparator());
    layoutPanel.appendChild(mainTable);

    this.InitializeLayoutPanelSingleLine(layoutPanel);

    layoutPanel.changeByRibbonType = function () {
        this.mainTableSingleLine.style.display = jsObject.options.ribbonType != "Classic" ? "" : "none";
        this.mainTableClassic.style.display = jsObject.options.ribbonType == "Classic" ? "" : "none";
        this.setHeightByRibbonType();
    }

    layoutPanel.updateControls = function () {
        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);

        var enableArrangeButtons = currentObject && currentObject.typeComponent != "StiPage" && currentObject.typeComponent != "StiReport";
        var arrangeButtons = ["alignToGrid", "alignLayout", "bringToFront", "sendToBack", "moveForward", "moveBackward",
            "layoutSize", "link", "lock"]
        for (var i = 0; i < arrangeButtons.length; i++) {
            var button = jsObject.options.buttons[arrangeButtons[i]];
            if (button) button.setEnabled(enableArrangeButtons);
        }

        if (currentObject) {
            jsObject.options.buttons.lock.setSelected(currentObject.properties.locked === true);
            jsObject.options.buttons.link.setSelected(currentObject.properties.linked === true);
            jsObject.options.buttons.layoutSize.setEnabled(jsObject.options.selectedObjects && jsObject.options.selectedObjects.length > 0);
        }

        layoutPanel.updateSingleLineControls();
    }
}

//Arrange
StiMobileDesigner.prototype.LayoutPanelArrangeBlock = function () {
    var jsObject = this;
    var arrangeGroupBlock = this.GroupBlock("groupBlockArrange", this.loc.Toolbars.ToolbarArrange, false, null);
    var innerTable = this.GroupBlockInnerTable();
    arrangeGroupBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";

    //Align To Grid 
    var alignToGridButton = this.StandartBigButton("alignToGrid", null, this.loc.Toolbars.AlignToGrid, "Layout.BigAlignToGrid.png", [this.loc.HelpDesigner.AlignToGrid, this.GetHelpLink("layout")], 60);
    innerTable.addCell(alignToGridButton).style.padding = "2px";
    alignToGridButton.action = function () {
        jsObject.SendCommandAlignToGridComponents();
    }

    //Separator
    var sep1 = this.HomePanelSeparator();
    sep1.style.height = this.options.isTouchDevice ? "90px" : "70px";
    innerTable.addCell(sep1);

    //Align
    var alignButton = this.BigButton("alignLayout", null, this.loc.Toolbars.Align, "Layout.BigAlignToGrid.png", [this.loc.HelpDesigner.Align, this.GetHelpLink("layout")], true, "stiDesignerStandartBigButton", null, 80);
    alignButton.cellImage.style.height = "40px";
    innerTable.addCell(alignButton).style.padding = "2px";
    var alignMenu = this.LayoutAlignMenu();

    alignButton.action = function () {
        alignMenu.changeVisibleState(!alignMenu.visible);
    }

    //Separator
    var sep2 = this.HomePanelSeparator();
    sep2.style.height = this.options.isTouchDevice ? "90px" : "70px";
    innerTable.addCell(sep2);

    //Bring To Front
    var bringToFrontButton = this.StandartBigButton("bringToFront", null, this.loc.Toolbars.BringToFront, "Layout.BigBringToFront.png", [this.loc.HelpDesigner.BringToFront, this.GetHelpLink("layout")], 60);
    innerTable.addCell(bringToFrontButton).style.padding = "2px";
    bringToFrontButton.action = function () {
        jsObject.SendCommandChangeArrangeComponents("BringToFront");
    }

    //Send To Back
    var sendToBackButton = this.StandartBigButton("sendToBack", null, this.loc.Toolbars.SendToBack, "Layout.BigSendToBack.png", [this.loc.HelpDesigner.SendToBack, this.GetHelpLink("layout")], 60);
    innerTable.addCell(sendToBackButton).style.padding = "2px";
    sendToBackButton.action = function () {
        jsObject.SendCommandChangeArrangeComponents("SendToBack");
    }

    //Move Forward
    var moveForwardButton = this.StandartBigButton("moveForward", null, this.loc.Toolbars.MoveForward, "Layout.BigMoveForward.png", [this.loc.HelpDesigner.MoveForward, this.GetHelpLink("layout")], 60);
    innerTable.addCell(moveForwardButton).style.padding = "2px";
    moveForwardButton.action = function () {
        jsObject.SendCommandChangeArrangeComponents("MoveForward");
    }

    //Move Backward
    var moveBackwardButton = this.StandartBigButton("moveBackward", null, this.loc.Toolbars.MoveBackward, "Layout.BigMoveBackward.png", [this.loc.HelpDesigner.MoveBackward, this.GetHelpLink("layout")], 60);
    innerTable.addCell(moveBackwardButton).style.padding = "2px";
    moveBackwardButton.action = function () {
        jsObject.SendCommandChangeArrangeComponents("MoveBackward");
    }

    return arrangeGroupBlock;
}

//Design
StiMobileDesigner.prototype.LayoutPanelDesignBlock = function () {
    var jsObject = this;
    var designGroupBlock = this.GroupBlock("groupBlockLayoutDesign", this.loc.PropertyCategory.DesignCategory, false, null);
    var innerTable = this.CreateHTMLTable();
    designGroupBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";

    //Size
    var sizeCell = innerTable.addCell();
    sizeCell.setAttribute("rowspan", "2");
    var sizeButton = this.BigButton("layoutSize", null, this.loc.PropertyMain.Size, "Layout.BigSize.png",
        [this.loc.HelpDesigner.ComponentSize, this.GetHelpLink("layout")], true, "stiDesignerStandartBigButton", null, 60);

    sizeCell.appendChild(sizeButton);
    sizeCell.style.padding = "1px 1px 0 1px";

    var layoutSizeMenu = jsObject.LayoutSizeMenu();

    sizeButton.action = function () {
        layoutSizeMenu.changeVisibleState(!layoutSizeMenu.visible);
    }

    //Lock
    var lockButton = this.StandartSmallButton("lock", null, this.loc.Toolbars.Lock, "Layout.Lock.png", [this.loc.HelpDesigner.Lock, this.GetHelpLink("layout")], null);
    innerTable.addCell(lockButton).style.padding = "1px 1px 0 1px";
    lockButton.action = function () {
        this.setSelected(!this.isSelected);
        jsObject.ApplyPropertyValue("locked", this.isSelected);
    }

    //Link
    var linkButton = this.StandartSmallButton("link", null, this.loc.Toolbars.Link, "Layout.Link.png", [this.loc.HelpDesigner.Link, this.GetHelpLink("layout")], null);
    innerTable.addCellInNextRow(linkButton).style.padding = "0 1px 0 1px";
    linkButton.action = function () {
        this.setSelected(!this.isSelected);
        jsObject.ApplyPropertyValue("linked", this.isSelected);
    }

    return designGroupBlock;
}