﻿
StiMobileDesigner.prototype.InitializeInfoPanel = function () {
    var infoPanel = document.createElement("div");
    var jsObject = infoPanel.jsObject = this;
    infoPanel.id = this.options.mobileDesigner.id + "infoPanel";
    infoPanel.className = "stiDesignerInfoPanel";
    this.options.infoPanel = infoPanel;
    this.options.mainPanel.appendChild(infoPanel);
    infoPanel.style.display = "none";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.width = innerTable.style.height = "100%";
    infoPanel.appendChild(innerTable);

    var closeButton = this.StandartSmallButton(null, null, null, "CloseForm.png", null, null, null);
    closeButton.style.height = "24px";
    closeButton.style.marginLeft = "12px";
    innerTable.addCell(closeButton).style.width = "1px";

    closeButton.action = function () {
        infoPanel.hide();
    }

    var textCell = innerTable.addCell();
    textCell.style.overflow = "hidden";
    textCell.style.paddingLeft = "12px";

    infoPanel.setText = function (text) {
        textCell.innerHTML = text;
    }

    var upgradeButton = this.FormButton(null, null, this.loc.Buttons.Upgrade);
    upgradeButton.style.margin = "0 12px 0 12px";
    upgradeButton.style.height = "24px";
    innerTable.addCell(upgradeButton).style.width = "1px";

    upgradeButton.action = function () {
        jsObject.openNewWindow("https://www.stimulsoft.com/" + (jsObject.options.helpLanguage || "en") + "/online-store");
    }

    infoPanel.checkState = function () {
        if (!jsObject.options.cloudMode && !jsObject.options.standaloneJsMode && !jsObject.options.alternateValid) {
            infoPanel.show();
        }
    }

    infoPanel.show = function () {
        if (this.visibleState !== false && this.style.display == "none") {
            this.visibleState = true;

            if (!jsObject.options.menus.fileMenu || !jsObject.options.menus.fileMenu.visible)
                infoPanel.changeVisibleState(true);

            var buildDate = new Date();
            try {
                if (jsObject.options.jsMode && typeof Stimulsoft != "undefined") {
                    // eslint-disable-next-line no-undef
                    var innerDate = Stimulsoft.StiVersion.created.innerDate;
                    if (innerDate["getFullYear"] && innerDate.getFullYear() > 2017)
                        // eslint-disable-next-line no-undef
                        buildDate = Stimulsoft.StiVersion.created.innerDate;
                }
                else if (jsObject.options.buildDate) {
                    buildDate = new Date(jsObject.options.buildDate);
                }
            }
            catch (e) {
                buildDate = new Date();
            }

            if (!jsObject.options.cloudMode) {
                var trDays = Math.floor(((new Date()).getTime() - buildDate.getTime()) / 1000 / 60 / 60 / 24);
                if (trDays > 30) closeButton.style.display = "none";
                if (trDays > 45) setTimeout(function () { infoPanel.showTrMessage(trDays > 60); }, 3000);
            }
        }
    }

    infoPanel.showTrMessage = function (trExp) {
        if (!jsObject.options.cloudMode && !jsObject.options.standaloneJsMode && !jsObject.options.alternateValid) {
            jsObject.InitializeNotificationForm(function (form) {
                form.show(trExp ? jsObject.loc.Notices.YourTrialHasExpired : jsObject.loc.Notices.YouUsingTrialVersion, null, "Notifications.Warning.png");

                form.upgradeButton.caption.innerHTML = jsObject.loc.Buttons.Upgrade;

                if (trExp) {
                    form.upgradeButton.action = function () {
                        form.changeVisibleState(false);
                        window.location.href = "https://www.stimulsoft.com/en/online-store";
                    }

                    form.cancelAction = function () {
                        window.location.href = "https://www.stimulsoft.com/en/online-store";
                    }
                }
                else {
                    form.upgradeButton.action = function () {
                        form.changeVisibleState(false);
                    }
                }
            });
        }
    }

    infoPanel.hide = function () {
        this.visibleState = false;
        infoPanel.changeVisibleState(false);
    }

    infoPanel.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        jsObject.options.workPanel.layoutOtherPanels();
    }

    infoPanel.getInfoText = function () {
        var text = "You are using the trial version of Stimulsoft Reports and Dashboards. To use the software in production you should purchase a license.";

        if (jsObject.IsRusCulture(jsObject.options.cultureName)) {
            text = "Вы используете пробную версию продукта. Для полноценного использования Вам необходимо приобрести лицензию.";
        }
        else if (jsObject.options.cultureName == "de") {
            text = "Sie verwenden die Testversion von Stimulsoft Reports and Dashboards. Um die Software für die Produktion zu verwenden, kaufen Sie die Lizenz ein.";
        }
        else if (jsObject.options.cultureName == "fr") {
            text = "Vous utilisez la version d'essai de Stimulsoft Rapports et Tableaux de bord. Pour utiliser le logiciel en production, vous devez acheter une licence.";
        }
        else if (jsObject.options.cultureName == "ja") {
            text = "Stimulsoft Reports と Dashboardsの試用版を使用しています。 本番環境でソフトウェアを使用するには、ライセンスを購入する必要があります。";
        }
        else if (jsObject.options.cultureName == "ko") {
            text = "Stimulsoft Reports 및 대시보드의 평가판을 사용하고 있습니다. 운영 중인 소프트웨어를 사용하려면 라이센스를 구입해야 합니다.";
        }
        return text;
    }

    infoPanel.setText(infoPanel.getInfoText());
}