﻿
StiMobileDesigner.prototype.InitializeTextEditorForm_ = function () {
    var jsObject = this;

    //Text Editor Form
    var textEditorForm = this.BaseForm("textEditor", this.loc.PropertyMain.Text, 3, this.GetHelpLink("expression"));
    textEditorForm.propertyName = "";
    textEditorForm.dataTree = this.options.dataTree;
    textEditorForm.mode = "Expression";

    this.AddProgressToControl(textEditorForm);

    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    textEditorForm.container.appendChild(mainTable);
    textEditorForm.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["Expression", "TextForm.TextExpression.png", this.loc.PropertyMain.Expression],
        ["DataColumn", "TextForm.TextDataColumn.png", this.loc.PropertyMain.DataColumn],
        ["SystemVariable", "TextForm.TextSystemVariable.png", this.loc.PropertyMain.SystemVariable],
        ["SummaryText", "TextForm.TextSummary.png", this.loc.PropertyMain.Summary],
        ["RichText", "TextForm.TextHtml.png", "HTML"]
    ];

    //Add Panels && Buttons
    var buttonsPanel = mainTable.addCell();
    var panelsContainer = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    buttonsPanel.style.paddingTop = "6px";
    textEditorForm.mainButtons = {};
    textEditorForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerEditFormPanel";
        panel.style.minWidth = this.options.isTouchDevice ? "660px" : "610px";
        panel.style.width = "auto";
        panel.style.overflow = "visible";
        panel.style.display = i != 0 ? "none" : "inline-block";
        panelsContainer.appendChild(panel);
        textEditorForm.panels[buttonProps[i][0]] = panel;

        var button = this.FormTabPanelButton(null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], null, { width: 24, height: 24 }, 34);
        textEditorForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);
        button.panelName = buttonProps[i][0];
        button.action = function () {
            textEditorForm.setMode(this.panelName);
        }
    }

    //Expression
    var expTable = this.CreateHTMLTable();
    expTable.style.display = "inline-block";
    var expTextArea = textEditorForm.expressionTextArea = this.TextArea("textEditorFormExpression", this.options.isTouchDevice ? 366 : 316, 364, true);
    expTextArea.style.margin = "12px 12px 0 12px";
    expTable.addCell(expTextArea);
    textEditorForm.panels.Expression.appendChild(expTable);
                    
    var expDictionaryTree = jsObject.options.expDictionaryTree || this.DictionaryTree(true);
    var dictionaryPanel = jsObject.DictionaryPanelForEditors(250, 422, true);
    dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
    dictionaryPanel.style.margin = "12px 12px 0 0";
    expTable.addCell(dictionaryPanel).style.display = "inline-block";

    expTextArea.addInsertButton(expDictionaryTree);

    this.AddHintHelperToControl(expTextArea, 50, true, false, ["Text: {Expression}", "{DataSource.Field}"]);

    new ResizeObserver(function () {
        if (expTextArea.offsetHeight > 0) {
            dictionaryPanel.style.height = (expTextArea.offsetHeight + 52) + "px";
        }
    }).observe(expTextArea);

    expTextArea.checkButtonAction = function () {
        expTextArea.checkButton.setEnabled(false);

        var params = {
            expression: StiBase64.encode(expTextArea.value),
            useAliases: jsObject.options.useAliases,
            componentName: jsObject.options.selectedObject ? jsObject.options.selectedObject.properties.name : null
        }

        jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
            expTextArea.checkButton.setEnabled(true);

            if (answer.checkResult) {
                var message = StiBase64.decode(answer.checkResult);
                var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                messageForm.action = function (state) {
                    messageForm.changeVisibleState(false);

                    if (state) {
                        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                            stimulAIForm.show(textEditorForm, expTextArea, function () {
                                stimulAIForm.sendButtonAction("FixTextAndExpression");
                            });
                        });
                    }
                }
            }
        });
    };

    //DataColumn
    var columnContainer = this.SystemVariablesTree();
    columnContainer.className = "stiSimpleContainerWithBorder";
    columnContainer.style.margin = "12px 0 0 12px";
    columnContainer.style.overflow = "auto";
    columnContainer.style.height = "390px";
    columnContainer.style.width = this.options.isTouchDevice ? "633px" : "583px";
    textEditorForm.panels.DataColumn.appendChild(columnContainer);

    var nullValTable = this.CreateHTMLTable();
    nullValTable.style.margin = "12px 0 0 5px";
    textEditorForm.panels.DataColumn.appendChild(nullValTable);
    nullValTable.addTextCell(this.loc.FormSystemTextEditor.LabelShowInsteadNullValues.replace(":", "")).className = "stiDesignerCaptionControls";
    var nullValuesControl = this.DropDownList("textFormNullValues", 125, null, this.GetInsteadNullValuesItems(), true);
    nullValTable.addCell(nullValuesControl);

    //System Variables
    var sysTreeCont = document.createElement("div");
    sysTreeCont.className = "stiSimpleContainerWithBorder";
    sysTreeCont.style.margin = "12px 0 0 12px";
    sysTreeCont.style.height = "422px";
    sysTreeCont.style.width = this.options.isTouchDevice ? "633px" : "583px";
    textEditorForm.panels.SystemVariable.appendChild(sysTreeCont);

    var systemVarsTree = this.SystemVariablesTree(true);
    systemVarsTree.style.height = "350px";
    systemVarsTree.style.overflow = "auto";
    sysTreeCont.appendChild(systemVarsTree);

    var systemVarsInfoPanel = document.createElement("div");
    systemVarsInfoPanel.className = "stiDesignerTextEditFormSystemVariablesInfo";
    sysTreeCont.appendChild(systemVarsInfoPanel);

    systemVarsTree.onSelectedItem = function (item) {
        var isNone = item.itemObject.name == "noneItem";
        systemVarsTree.style.height = isNone ? "422px" : "350px";
        systemVarsInfoPanel.style.display = isNone ? "none" : "";
        systemVarsInfoPanel.innerHTML = jsObject.GetSystemVariableDescription(item.itemObject.name);
    };
    systemVarsTree.action = function () { textEditorForm.action(); };

    //Summary
    var summaryText = textEditorForm.summaryText = this.SummaryExpression("textEditorFormSummaryText");
    summaryText.style.height = "440px";
    summaryText.controls.expressionTextArea.readOnly = true;
    textEditorForm.panels.SummaryText.appendChild(summaryText);

    this.AddHintHelperToControl(summaryText.controls.expressionTextArea, 30, false, false, [this.loc.Editor.AutomaticallyGeneratedExpression], "");

    //RichText
    var richTextEditor = this.RichTextEditor("textEditorFormRichText", this.options.isTouchDevice ? 633 : 583, 384, null, true);
    textEditorForm.panels.RichText.appendChild(richTextEditor);

    richTextEditor.action = function () {
        richTextEditor.isModified = true;
    }

    //Form Methods
    textEditorForm.getDataForAI = function () {
        return {
            commandName: "textAndExpression",
            expression: StiBase64.encode(textEditorForm.mode == "SummaryText" ? summaryText.controls.expressionTextArea.value : expTextArea.value)
        }
    }

    textEditorForm.reset = function () {
        textEditorForm.dataTree.setKey("");
        expTextArea.value = "";
        summaryText.reset();
        textEditorForm.setMode("Expression");
    }

    textEditorForm.setMode = function (mode) {
        textEditorForm.mode = mode;
        for (var panelName in textEditorForm.panels) {
            textEditorForm.panels[panelName].style.display = mode == panelName ? "inline-block" : "none";
            textEditorForm.mainButtons[panelName].setSelected(mode == panelName);
        }
        if (mode == "Expression") {
            var richTextValue = richTextEditor.getText();
            if (richTextEditor.isModified && richTextEditor.startValue != null && richTextValue != richTextEditor.startValue) expTextArea.value = richTextEditor.getText(true);
            expTextArea.focus();
        }
        else if (mode == "RichText") {
            var selectedObject = jsObject.options.selectedObject;
            var text = expTextArea.value;
            richTextEditor.setText(text, selectedObject ? jsObject.FontStrToObject(selectedObject.properties.font) : null, true);
            richTextEditor.startValue = richTextEditor.getText();
        }
        else if (mode == "SummaryText") {
            summaryText.controls.expressionTextArea.focus();
        }
    }

    textEditorForm.onshow = function () {
        richTextEditor.isModified = false;
        textEditorForm.setMode("Expression");
        textEditorForm.container.style.visibility = "hidden";

        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        textEditorForm.mainButtons.RichText.style.display = currentObject && currentObject.typeComponent == "StiText" ? "" : "none";
        nullValuesControl.setKey(currentObject.properties.nullValue);

        dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
        expDictionaryTree.build(jsObject.options.report.dictionary, true);
        expDictionaryTree.currentEditor = expTextArea;
    }

    textEditorForm.oncompleteshow = function () {
        if (this.showFunction) {
            this.showFunction();
            this.showFunction = null;
            return;
        }

        textEditorForm.progress.show();

        setTimeout(function () {
            textEditorForm.mainButtons.SummaryText.style.display = textEditorForm.propertyName == "text" ? "" : "none";

            //Build SystemVariables Tree
            systemVarsInfoPanel.innerHTML = "";
            systemVarsTree.build();
            if (systemVarsTree.firstChild && systemVarsTree.firstChild.childsContainer.childNodes.length > 0) {
                systemVarsTree.firstChild.childsContainer.childNodes[0].setSelected();
            }

            //Build Data Tree
            columnContainer.appendChild(textEditorForm.dataTree);
            textEditorForm.dataTree.build(null, null, null, true);
            textEditorForm.dataTree.action = function () {
                textEditorForm.action();
            }

            //Reset Controls
            textEditorForm.reset();

            if (jsObject.options.selectedObjects) {
                textEditorForm.setMode("Expression");
                expTextArea.focus();
            }
            else {
                var selectedObject = jsObject.options.selectedObject;

                var propertyValue = selectedObject.properties[textEditorForm.propertyName] != null
                    ? StiBase64.decode(selectedObject.properties[textEditorForm.propertyName])
                    : (textEditorForm.resultControl != null ? textEditorForm.resultControl.value : "");

                var textType = selectedObject.properties.textType;
                var subStringPropertyValue = propertyValue.length > 1 ? propertyValue.substring(1, propertyValue.length - 1) : "";
                expTextArea.value = propertyValue;


                if (textType == "DataColumn" || textEditorForm.dataTree.setKey(subStringPropertyValue)) {
                    if (textType == "DataColumn") textEditorForm.dataTree.setKey(subStringPropertyValue);
                    textEditorForm.setMode("DataColumn");
                    textEditorForm.dataTree.autoscroll();
                }
                else if (textType == "SystemVariables" || (textEditorForm.propertyName != "condition" && jsObject.options.report && jsObject.IsContains(jsObject.options.report.dictionary.systemVariables, subStringPropertyValue))) {
                    textEditorForm.setMode("SystemVariable");
                    var selectedItem = systemVarsTree.mainItem.getChildByName(subStringPropertyValue);
                    if (selectedItem) {
                        selectedItem.setSelected();
                        systemVarsTree.autoscroll();
                    }
                }
                else if (textType == "Totals") {
                    textEditorForm.setMode("SummaryText");
                    summaryText.fill(propertyValue);
                }
                else {
                    textEditorForm.setMode(selectedObject.properties.allowHtmlTags ? "RichText" : "Expression");
                    expTextArea.focus();
                }
            }
            textEditorForm.container.style.visibility = "visible";
            textEditorForm.progress.hide();
            expTextArea.focus();
        }, 50);
    }

    textEditorForm.action = function () {
        textEditorForm.changeVisibleState(false);

        if (this.actionFunction) {
            this.actionFunction();
            this.actionFunction = null;
            return;
        }

        var result = textEditorForm.mode == "SummaryText" ? summaryText.controls.expressionTextArea.value : expTextArea.value;
        var textType = textEditorForm.mode == "SummaryText" ? "Totals" : "Expression";

        if (textEditorForm.mode == "DataColumn") {
            result = (textEditorForm.dataTree.key ? "{" + textEditorForm.dataTree.key + "}" : "");
            textType = "DataColumn";
        }
        else if (textEditorForm.mode == "SystemVariable") {
            result = systemVarsTree.selectedItem && systemVarsTree.selectedItem.itemObject.name != "noneItem" ? "{" + systemVarsTree.selectedItem.itemObject.name + "}" : "";
            textType = result == "" ? "Expression" : "SystemVariables";
        }
        else if (textEditorForm.mode == "RichText") {
            result = richTextEditor.getText(true);
        }

        var propertyNames = [textEditorForm.propertyName];
        var propertyValues = [StiBase64.encode(result)];

        if (textEditorForm.propertyName == "text") {
            propertyNames.push("textType");
            propertyValues.push(textType);
        }

        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        if (currentObject && currentObject.typeComponent == "StiText") {
            if (textEditorForm.mode == "RichText") {
                propertyNames.push("allowHtmlTags");
                propertyValues.push(true);
            }
            propertyNames.push("nullValue");
            propertyValues.push(nullValuesControl.key);
        }

        jsObject.ApplyPropertyValue(propertyNames, propertyValues);
    }

    return textEditorForm;
}