﻿
StiMobileDesigner.prototype.InitializeStimulAIForm_ = function () {
    var form = this.BaseForm("stimulAIForm", "Stimul AI (Beta)", 4);
    form.isNotModal = true;
    form.controls = {};
    form.hideButtonsPanel();

    var jsObject = this;
    var progress = this.AddProgressToControl(form.container);

    var messagesContainer = document.createElement("div");
    form.container.appendChild(messagesContainer);

    var messagesFrame = document.createElement("iframe");
    messagesFrame.className = "stiStimulAIMessagesContainer";
    messagesFrame.style.width = "605px";
    messagesContainer.appendChild(messagesFrame);

    messagesFrame.onload = function () {
        messagesFrame.contentWindow.addEventListener("message", function (args) {
            if (args.data) {
                form.receivedMessageFromFrame(args.data);
            }
        }, false);
    }

    var textArea = this.TextArea(null, 600, 60);
    textArea.style.margin = "0 12px 12px 12px";
    form.container.appendChild(textArea);

    textArea.onkeydown = function (event) {
        if (event && event.keyCode == 13) {
            if (jsObject.options.CTRL_pressed) {
                this.value += "\r\n";
            }
            else {
                form.sendUserMessage(StiBase64.encode(this.value));
                this.value = "";
                this.focus();
                event.preventDefault();
                event.stopPropagation();
            }
        }
    }

    form.sendUserMessage = function (message, callbackFunc) {
        if (message) {
            form.sendCommandToAI("AIChatUserMessage", { message: message });
            form.sendCommandToAI("AIChatSession", { message: message }, function (answer) {
                if (callbackFunc) callbackFunc(answer);
            });
        }
    }

    form.sendButtonAction = function (buttonId, callbackFunc) {
        form.sendCommandToAI("AIChatButtonAction", { buttonId: buttonId }, function () {
            form.sendCommandToAI("AIChatButtonAction", { buttonId: buttonId, isSecondRequest: true }, function (answer) {
                if (callbackFunc) callbackFunc(answer);
            });
        });
    }

    form.receivedMessageFromFrame = function (buttonId) {
        if (buttonId == "buttonStop") {
            if (jsObject.xmlHttp) {
                jsObject.xmlHttpAbortedByUser = true;
                jsObject.xmlHttp.abort();
            }
            textArea.focus();
        }
        form.sendCommandToAI("AIChatButtonAction", { buttonId: buttonId }, function (answer) {
            if (answer.needSecondRequest) {
                form.sendCommandToAI("AIChatButtonAction", { buttonId: buttonId, isSecondRequest: true });
            }
            else if (answer.clipboardText) {
                jsObject.copyTextToClipboard(StiBase64.decode(answer.clipboardText));
            }
            else if (answer.appliedText) {
                var editorForm = form.editorForm;
                var editorControl = form.editorControl;
                var newValue = StiBase64.decode(answer.appliedText);

                if (editorControl) {
                    if (editorControl.textBox) {
                        editorControl.textBox.value = newValue;
                    }
                    else {
                        editorControl.value = newValue;
                    }
                }
                else if (editorForm) {
                    if (editorForm.name == "blocklyEditor") {
                        editorForm.insertXmlToBlockly(newValue);
                    }
                }
            }
        });
    }

    form.prepareTextForFrame = function (text) {
        if (text) {
            text = StiBase64.decode(text);
            text = text.replace(/window.chrome.webview.postMessage/g, 'window.postMessage');
        }
        return text;
    }

    form.getEditorData = function () {
        var editor = form.editorForm || form.editorControl;

        if (editor && editor.getDataForAI) {
            return editor.getDataForAI()
        }
        return {};
    }

    form.sendCommandToAI = function (commandName, commandData, callbackFunc) {
        var data = {
            editorData: form.getEditorData(),
            chatGuid: form.chatGuid,
            sessionKey: form.sessionKey,
            isBlackTheme: jsObject.isBlackTheme()
        }
        if (commandData) {
            for (var key in commandData) {
                data[key] = commandData[key];
            }
        }
        jsObject.SendCommandToDesignerServer(commandName, data, function (answer) {            
            if (callbackFunc) {
                callbackFunc(answer);
            }
            if (answer.text) {
                messagesFrame.srcdoc = form.prepareTextForFrame(answer.text);
            }
        });
    }

    form.onhide = function () {        
        form.sendCommandToAI("CloseAIChatSession");
    }

    form.show = function (editorForm, editorControl, completeFunc) {
        if (!jsObject.options.cloudParameters) return;

        if (!jsObject.options.cloudParameters.sessionKey) {
            jsObject.options.forms.authForm.show();
            return;
        }

        this.chatGuid = jsObject.newGuid();
        this.sessionKey = jsObject.options.cloudParameters.sessionKey;
        this.editorForm = editorForm;
        this.editorControl = editorControl;

        form.changeVisibleState(true);
        progress.show();

        textArea.value = "";
        textArea.focus();

        form.sendCommandToAI("AIChatSession", { user: jsObject.options.cloudParameters.user }, function () {
            progress.hide();
            if (completeFunc) completeFunc();
        });
    }

    return form;
}