
StiMobileDesigner.prototype.InitializeGoogleDriveOpenResourceForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("googleDriveOpenResource", "GoogleDrive", 4);

    //Tree
    var googleTree = jsObject.GoogleDriveTree(form);
    googleTree.style.position = "relative";
    googleTree.progress = jsObject.AddProgressToControl(form.container);
    googleTree.toolBar.style.display = "none";
    googleTree.navigatePanel.style.margin = "12px";

    var innerContainer = googleTree.innerContainer;
    innerContainer.style.position = "relative";
    innerContainer.style.height = "500px";
    innerContainer.style.width = "700px";
    innerContainer.style.top = "0";
    form.container.appendChild(googleTree);

    googleTree.ondblClickAction = function (item) {
        if (item.itemObject.ident != "Folder") {
            item.select();
            form.action();
        }
    }

    googleTree.action = function (item) {
        if (item.itemObject.ident == "Folder") {
            googleTree.openFolder(form, item.itemObject.id, form.resourceIdents, function (data) {
                googleTree.selectedItem = null;
                form.buttonOk.setEnabled(false);
            });
        }
        else if (item.itemObject.ident) {
            item.select();
            form.buttonOk.setEnabled(true);
        }
    }

    googleTree.navigatePanel.action = function (folderId) {
        googleTree.openFolder(form, folderId, form.resourceIdents, function (data) {
            googleTree.selectedItem = null;
        });
    }

    form.show = function (resourceContainer, resourceIdents) {
        form.resourceContainer = resourceContainer;
        form.resourceIdents = resourceIdents;
        form.changeVisibleState(true);
        form.buttonOk.setEnabled(false);
        form.buttonOk.caption.innerHTML = jsObject.loc.Buttons.Upload;

        googleTree.clear();
        googleTree.style.display = "";
        googleTree.findControl.setValue("");

        googleTree.openFolder(form, "root", resourceIdents, function (data) { });
    }

    form.action = function () {
        form.changeVisibleState(false);

        if ((jsObject.options.cloudMode || jsObject.options.standaloneJsMode) && (!jsObject.CheckUserTrExpired() || !jsObject.CheckUserActivated()))
            return;

        if (googleTree.selectedItem) {
            var resContainer = form.resourceContainer;
            var itemObject = googleTree.selectedItem.itemObject;

            var setProgress = function (state) {
                if (resContainer["setProgress"]) {
                    resContainer.setProgress(state)
                }
            }

            setProgress(true);

            jsObject.ConnectToGoogleDrive(form, function (success) {
                if (success && jsObject.googleDriveConnectParams) {
                    var params = {
                        fileId: itemObject.id,
                        fileIdent: itemObject.ident,
                        googleDriveConnectParams: jsObject.googleDriveConnectParams
                    };
                    jsObject.SendCommandToDesignerServer("LoadResourceFileFromGoogleDrive", params,
                        function (answer) {
                            setProgress(false);

                            if (answer.contentBase64) {
                                var content = jsObject.GetMimeTypeByFileName(itemObject.name) + answer.contentBase64;

                                if (resContainer["setImage"]) {
                                    resContainer.setImage(content);
                                    if (resContainer["action"]) resContainer.action();
                                }
                                else {
                                    var resourceName = itemObject.name.substring(0, itemObject.name.lastIndexOf("."));
                                    resContainer.setResource(jsObject.GetMimeTypeByFileName(itemObject.name) + answer.contentBase64, jsObject.GetResourceTypeByFileName(itemObject.name), resourceName, answer.contentSize, null, true);
                                    resContainer.action();
                                }
                            }
                        }
                    );
                }
                else {
                    setProgress(false);
                }
            });
        }
    }

    return form;
}