﻿
StiMobileDesigner.prototype.InitializeEditUserFunctionForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("editUserFunctionForm", this.loc.FormDictionaryDesigner.FunctionNew, 3, this.GetHelpLink("userFunction"));
    form.userfunction = null;
    form.mode = "Edit";
    form.controls = {};

    this.AddProgressToControl(form.container);

    //Save Copy
    var saveCopyButton = this.FormButton(null, null, this.loc.Buttons.SaveCopy, null);
    saveCopyButton.style.display = "inline-block";
    saveCopyButton.style.margin = "12px";

    saveCopyButton.action = function () {
        if (!form.controls.name.checkExists(jsObject.GetUserFunctionsFromDictionary(jsObject.options.report.dictionary), "name")) {
            form.controls.name.value += "Copy";

            var resultName = form.controls.name.value;
            var i = 2;

            while (!form.controls.name.checkExists(jsObject.GetUserFunctionsFromDictionary(jsObject.options.report.dictionary), "name")) {
                form.controls.name.value = resultName + i;
                i++;
            }
        }
        form.mode = "New";
        form.action();
    }

    //Check
    var stimulAIButton = this.FormButton(null, null, this.loc.StimulAI.CheckWithStimulAI, null);
    stimulAIButton.style.margin = "12px 0 12px 12px";

    stimulAIButton.action = function () {
        form.aiCommandName = "userFunctionCheckScript";

        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
            stimulAIForm.show(form, form.controls.scriptContainer.textArea, function () {
                stimulAIForm.sendButtonAction("UserFunctionCheckScript");
            });
        });
    }

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = form.buttonsPanel;
    form.removeChild(buttonsPanel);
    form.appendChild(footerTable);
    footerTable.addCell(stimulAIButton).style.width = "1px";
    footerTable.addCell(saveCopyButton).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(form.buttonOk).style.width = "1px";
    footerTable.addCell(form.buttonCancel).style.width = "1px";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "6px 0 6px 0";
    form.container.appendChild(innerTable);

    var scriptLangs = ["CSharp", "JS", "VB"];
    var codeTable = this.CreateHTMLTable();
    codeTable.style.width = "100%";
    var codeButtonsPanel = codeTable.addCell();
    codeButtonsPanel.style.verticalAlign = "top";
    codeButtonsPanel.style.width = "1px";
    codeTable.buttons = {};

    var scriptContainer = form.controls.scriptContainer = this.TextAreaWithEditButton(null, "100%", 150, false, true, true);
    scriptContainer.style.width = "calc(100% - 28px)";
    scriptContainer.textArea.style.width = "calc(100% - 32px)";
    scriptContainer.textArea.style.paddingRight = "28px";
    scriptContainer.className = "stiDesignerTextArea stiDesignerTextAreaDefault";
    scriptContainer.textArea.style.border = "0";
    scriptContainer.textArea.onmouseover = null;
    scriptContainer.textArea.onmouseenter = null;
    scriptContainer.textArea.onmouseleave = null;
    scriptContainer.scriptLang = this.options.jsMode ? "JS" : "CSharp";
    scriptContainer.scriptText = {};

    for (var i = 0; i < scriptLangs.length; i++) {
        var button = codeTable.buttons[scriptLangs[i]] = this.FormTabPanelButton(null, scriptLangs[i] == "CSharp" ? "C#" : scriptLangs[i]);
        button.style.margin = "0 12px 6px 0";
        button.style.width = "70px";
        button.scriptLang = scriptLangs[i];
        codeButtonsPanel.appendChild(button);

        button.action = function () {
            scriptContainer.setScriptLanguage(this.scriptLang);
        }
    }

    codeTable.addCell(scriptContainer)

    var properties = [
        ["name", this.loc.PropertyMain.Name, this.TextBox(null, 200), "6px 12px 6px 12px"],
        ["description", this.loc.PropertyMain.Description, this.TextBox(null, 300), "6px 12px 6px 12px"],
        ["category", this.loc.PropertyMain.Category, this.DropDownList(null, 200, null, this.GetUserFuncCategoryItems(), true), "6px 12px 6px 12px"],
        ["customCategory", this.loc.UserFunctionEditor.CustomCategory, this.TextBox(null, 200), "6px 12px 6px 12px"],
        ["returnType", this.loc.UserFunctionEditor.ReturnType, this.DropDownList(null, 200, null, this.GetUserFuncReturnTypeItems(), true, false, null, null, { width: 16, height: 16 }), "6px 12px 6px 12px"],
        ["separator1", null, this.FormSeparator(), "6px 12px 6px 12px"],
        ["argumentsButton", this.loc.PropertyMain.Arguments, this.FormButton(null, null, this.loc.Buttons.Add, null, null, null, true), "6px 12px 6px 12px"],
        ["argumentsContainer", null, this.UserFunctionArgumentsContainer(form, 150), "6px 12px 6px 12px"],
        ["argumentName", this.loc.UserFunctionEditor.ArgumentName, this.TextBox(null, 200), "6px 12px 6px 12px"],
        ["argumentType", this.loc.UserFunctionEditor.ArgumentType, this.DropDownList(null, 200, null, this.GetUserFuncReturnTypeItems(), true, false, null, null, { width: 16, height: 16 }), "6px 12px 6px 12px"],
        ["scriptHeader", null, this.FormBlockHeader(this.loc.UserFunctionEditor.Script), "10px 12px 6px 12px"],
        ["scriptMode", this.loc.UserFunctionEditor.ScriptMode, this.DropDownList(null, 200, null, this.GetUserFuncScriptModeItems(), true), "6px 12px 6px 12px"],
        ["labelTextContainer", null, this.SimpleTextContainer("", 350), "6px 12px 0px 12px"],
        ["separator1", null, this.FormSeparator(), "6px 12px 6px 12px"],
        ["codeTable", null, codeTable, "6px 12px 6px 12px"],
        ["sampleTextContainer", null, this.SimpleTextContainer(""), "6px 12px 12px 94px"]
    ];

    for (var i = 0; i < properties.length; i++) {
        var propertyName = properties[i][0];
        var control = properties[i][2];
        form.addControlRow(innerTable, properties[i][1], propertyName, control, properties[i][3], 130);

        control.action = function () { }
    }

    form.controls.argumentsButton.parentElement.style.textAlign = "right";

    //Convert Script
    var convertButton = this.SmallButton(null, null, null, "AI.AI.png", this.loc.UserFunctionEditor.ConvertScript, null, "stiDesignerFormButton", true);
    convertButton.style.position = "absolute";
    convertButton.style.right = "4px";
    convertButton.style.top = this.options.isTouchDevice ? "36px" : "32px";
    scriptContainer.buttonCell.appendChild(convertButton);

    var convertMenu = this.VerticalMenu("UserFuncConvertMenu", convertButton, "Down", this.GetUserFuncConvertScriptItems());

    convertButton.action = function () {
        convertMenu.changeVisibleState(!convertMenu.visible);
    }

    convertMenu.onshow = function () {
        for (var i = 0; i < scriptLangs.length; i++) {
            convertMenu.items[scriptLangs[i]].style.display = scriptContainer.scriptLang != scriptLangs[i] ? "" : "none";
        }
    }

    convertMenu.action = function (menuItem) {
        this.changeVisibleState(false);

        if (!jsObject.options.cloudParameters.sessionKey) {
            jsObject.options.forms.authForm.show();
            return;
        }

        form.aiCommandName = "userFunctionConvertScript";
        form.container.progress.show();

        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
            stimulAIForm.chatGuid = jsObject.newGuid();
            stimulAIForm.sessionKey = jsObject.options.cloudParameters.sessionKey;
            stimulAIForm.editorForm = form;
            stimulAIForm.editorControl = form.controls.scriptContainer.textArea;

            stimulAIForm.sendCommandToAI("AIChatSession", { toLanguage: menuItem.key == "CSharp" ? "C#" : menuItem.key }, function (answer) {
                form.container.progress.hide();

                if (answer.text) {
                    scriptContainer.setScriptLanguage(menuItem.key);
                    form.controls.scriptContainer.textArea.value = StiBase64.decode(answer.text);
                    scriptContainer.textArea.action();
                    scriptContainer.updateMode();
                }
            });
        });
    }

    var blocklyEmpty = jsObject.CreateHTMLTable();
    scriptContainer.buttonCell.appendChild(blocklyEmpty);
    blocklyEmpty.style.opacity = "0.5";
    blocklyEmpty.style.top = "40px";
    blocklyEmpty.style.left = "calc(100% - 325px)";
    blocklyEmpty.style.position = "absolute";
    blocklyEmpty.style.display = "none";

    var emptyImg = document.createElement("img");
    emptyImg.style.width = emptyImg.style.height = "32px";
    emptyImg.style.margin = "6px";
    StiMobileDesigner.setImageSource(emptyImg, jsObject.options, "Blockly.BlocklyGray.png");

    blocklyEmpty.addCell(emptyImg).style.textAlign = "center";
    blocklyEmpty.addCellInNextRow(jsObject.SimpleTextContainer(jsObject.loc.FormStyleDesigner.NotSpecified, 200)).style.textAlign = "center";

    var blocklyBlocks = jsObject.SimpleTextContainer("(" + jsObject.loc.PropertyMain.Blocks + ")", 200);
    scriptContainer.buttonCell.appendChild(blocklyBlocks);
    blocklyBlocks.style.textAlign = "center";
    blocklyBlocks.style.top = "65px";
    blocklyBlocks.style.left = "calc(100% - 325px)";
    blocklyBlocks.style.position = "absolute";
    blocklyBlocks.style.display = "none";

    var argsContainer = form.controls.argumentsContainer;

    var errorBlock = this.SimpleTextContainer("This report uses Interpretation mode. Functions with code will not work. We recommend switching to ScriptMode on Blocks.");
    errorBlock.style.color = "white";
    errorBlock.style.background = "#eb5558";
    errorBlock.style.lineHeight = "1.3";
    errorBlock.style.padding = "12px";
    errorBlock.style.display = "none";
    errorBlock.style.boxSizing = "border-box";
    form.container.appendChild(errorBlock);

    form.controls.argumentsButton.action = function () {
        var itemName = argsContainer.getNewItemName("value");
        var item = argsContainer.addItem(argsContainer.getItemCaption(itemName, "String"), null, { name: itemName, type: "String" });
        item.select();
    }

    argsContainer.onAction = function (actionName) {
        var itemObject = this.selectedItem ? this.selectedItem.itemObject : null;
        if (itemObject) {
            form.controls.argumentName.value = itemObject.name;
            form.controls.argumentType.setKey(itemObject.type);
        }
        form.updateControlsVisibleStates();
        form.updateFunctionLabel();
        form.controls.argumentsButton.setEnabled(argsContainer.getCountItems() < 10);
    }

    argsContainer.fill = function (argsItems) {
        this.clear();
        for (var i = 0; i < argsItems.length; i++) {
            argsContainer.addItem(argsContainer.getItemCaption(argsItems[i].name, argsItems[i].type), null, { name: argsItems[i].name, type: argsItems[i].type });
        }
    }

    argsContainer.getItems = function () {
        var items = [];
        for (var i = 0; i < this.childNodes.length; i++) {
            if (this.childNodes[i].itemObject) {
                items.push(this.childNodes[i].itemObject);
            }
        }
        return items;
    }

    form.getDataForAI = function () {
        return {
            commandName: form.aiCommandName,
            script: StiBase64.encode(form.controls.scriptContainer.textArea.value),
            returnType: form.controls.returnType.key,
            language: scriptContainer.scriptLang == "CSharp" ? "C#" : scriptContainer.scriptLang,
            functionName: form.userfunction.name,
            arguments: form.controls.argumentsContainer.getItems()
        }
    }

    form.controls.category.action = function () {
        form.updateControlsVisibleStates();
    }

    form.controls.scriptMode.action = function (isChanged) {
        if (isChanged) {
            scriptContainer.textArea.value = this.key == "Code" ? (scriptContainer.scriptText[scriptContainer.scriptLang] || form.getReturnTypeScript()) : scriptContainer.scriptText.Blockly;
            scriptContainer.textArea.action();
        }
        if (this.key == "Code" && jsObject.options.report && jsObject.options.report.properties.calculationMode == "Interpretation") {
            if (jsObject.options.compilationAccess == "Deny") {
                form.controls.scriptMode.setKey("Blocks");

                var errorMessageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
                errorMessageForm.show(jsObject.loc.HelpDesigner.NotPossibleEnableCompilationMode, "Warning");
            }
            else if (jsObject.options.compilationAccess == "Ask") {
                var messageForm = jsObject.MessageFormForSwitchToCompilation();
                messageForm.changeVisibleState(true);

                messageForm.action = function (state) {
                    if (state) {
                        form.controls.scriptMode.setKey("Code");
                        scriptContainer.updateMode();
                        jsObject.options.report.properties.calculationMode = "Compilation";
                        jsObject.SendCommandSetReportProperties(["calculationMode"]);

                        if (messageForm.doNotAskMe.isChecked) {
                            jsObject.options.compilationAccess = "Allow";
                            StiMobileDesigner.SetCookie("StimulsoftMobileDesignerCompilationAccess", "Allow");
                        }
                    }
                }
                messageForm.cancelAction = function (state) {
                    form.controls.scriptMode.setKey("Blocks");
                    scriptContainer.updateMode();
                }
            }
        }
        scriptContainer.updateMode();
        form.updateControlsVisibleStates();
    }

    form.controls.argumentName.action = function () {
        var selectedItem = argsContainer.selectedItem;
        if (selectedItem) {
            if (this.value == "") this.value = "value";
            selectedItem.itemObject.name = this.value;
            selectedItem.captionContainer.innerHTML = argsContainer.getItemCaption(this.value, selectedItem.itemObject.type);
        }
        form.updateFunctionLabel();
    }

    form.controls.argumentType.action = function () {
        var selectedItem = argsContainer.selectedItem;
        if (selectedItem) {
            selectedItem.itemObject.type = this.key;
            selectedItem.captionContainer.innerHTML = argsContainer.getItemCaption(selectedItem.itemObject.name, this.key);
        }
        form.updateFunctionLabel();
    }

    form.controls.returnType.action = function () {
        form.updateCodeSample();
        form.updateFunctionLabel();
    }

    scriptContainer.textArea.action = function () {
        scriptContainer.scriptText[form.controls.scriptMode.key == "Code" ? scriptContainer.scriptLang : "Blockly"] = this.value;
    }

    scriptContainer.button.action = function () {
        if (form.controls.scriptMode.key == "Code") {
            var codeEditorForm = jsObject.InitializeCodeEditorForm(form);
            codeEditorForm.resultControl = scriptContainer.textArea;
            codeEditorForm.changeVisibleState(true);
        }
        else {
            var showBlocklyForm = function () {
                jsObject.InitializeBlocklyEditorForm(function (blocklyForm) {
                    blocklyForm.resultControl = scriptContainer;

                    blocklyForm.show(scriptContainer.textArea.value, "", form.getCurrentUserFunction());

                    blocklyForm.resultControl.action = function () {
                        scriptContainer.textArea.value = blocklyForm.resultControl.hiddenValue;
                        scriptContainer.textArea.action();
                        scriptContainer.updateMode();
                    }
                });
            }
            if (!jsObject.options.blocklyInitialized && !jsObject.options.jsMode) {
                jsObject.LoadScriptWithProcessImage(jsObject.options.scriptsUrl + "BlocklyScripts;" + (jsObject.options.cultureName || "en"), function () {
                    jsObject.options.blocklyInitialized = true;
                    showBlocklyForm();
                });
            }
            else {
                showBlocklyForm();
            }
        }
    }

    scriptContainer.setScriptLanguage = function (scriptLang) {
        this.scriptLang = scriptLang;

        for (var i = 0; i < scriptLangs.length; i++) {
            codeTable.buttons[scriptLangs[i]].setSelected(scriptLangs[i] == scriptLang);
        }

        scriptContainer.textArea.value = (form.controls.scriptMode.key == "Blocks" ? scriptContainer.scriptText.Blockly : (scriptContainer.scriptText[scriptLang]) || form.getReturnTypeScript());
        form.updateCodeSample();
    }

    scriptContainer.updateMode = function () {
        var scriptMode = form.controls.scriptMode.key;
        this.textArea.style.visibility = scriptMode == "Blocks" ? "hidden" : "visible";
        blocklyEmpty.style.display = scriptMode == "Blocks" && scriptContainer.textArea.value == "" ? "" : "none";
        blocklyBlocks.style.display = scriptMode == "Blocks" && scriptContainer.textArea.value != "" ? "" : "none";
        codeButtonsPanel.style.display = scriptMode == "Code" ? "" : "none";
        this.button.setAttribute("title", jsObject.loc.UserFunctionEditor[scriptMode == "Blocks" ? "EditWithBlockly" : "EditCode"]);
        stimulAIButton.setEnabled(scriptMode == "Code");
        convertButton.style.display = scriptMode == "Code" && jsObject.options.cloudMode ? "" : "none";
    }

    form.controls.sampleTextContainer.style.visibility = "hidden";
    form.controls.sampleTextContainer.style.cursor = "pointer";

    form.controls.sampleTextContainer.onclick = function () {
        scriptContainer.textArea.value = form.getReturnTypeScript();
        scriptContainer.textArea.action();
    }

    form.getReturnTypeScript = function () {
        var scriptLang = scriptContainer.scriptLang;

        switch (form.controls.returnType.key) {
            case "String":
            case "Text":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return \"Hello\";";
                        case "VB": return "Return \"Hello\"";
                        case "JS": return "return \"Hello\";";
                    }
                }
                break;

            case "Float":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return 100f;";
                        case "VB": return "Return 100F";
                        case "JS": return "return 100.0;";
                    }
                }
                break;

            case "Double":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return 100d;";
                        case "VB": return "Return 100R";
                        case "JS": return "return 100.0;";
                    }
                }
                break;
            case "Decimal":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return 100M;";
                        case "VB": return "Return 100D";
                        case "JS": return "return 100;";
                    }
                }
                break;

            case "DateTime":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return DateTime.Now;";
                        case "VB": return "Return DateTime.Now";
                        case "JS": return "return new Date();";
                    }
                }
                break;

            case "DateTimeOffset":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return DateTimeOffset.Now;";
                        case "VB": return "Return DateTimeOffset.Now";
                        case "JS": return "return new Date();";
                    }
                }
                break;

            case "DateOnly":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return DateOnly.Now;";
                        case "VB": return "Return DateOnly.Now";
                        case "JS": return "return new Date();";
                    }
                }
                break;

            case "TimeSpan":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return TimeSpan.Zero;";
                        case "VB": return "Return TimeSpan.Zero";
                        case "JS": return "return { 6, 0, 0 };";
                    }
                }
                break;
            case "TimeOnly":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return new TimeOnly(0);";
                        case "VB": return "Return New TimeOnly(0)";
                        case "JS": return "return { 0, 0, 0, 0 };";
                    }
                }
                break;

            case "Sbyte":
            case "Byte":
            case "Short":
            case "Ushort":
            case "Int":
            case "Uint":
            case "Long":
            case "Ulong":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return 0;";
                        case "VB": return "Return 0";
                        case "JS": return "return 0;";
                    }
                }
                break;

            case "ByteArray":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return new byte[0];";
                        case "VB": return "Return New Byte(-1) {}";
                        case "JS": return "return new Uint8Array(0);";
                    }
                }
                break;

            case "Bool":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return true;";
                        case "VB": return "Return True";
                        case "JS": return "return true;";
                    }
                }
                break;

            case "Char":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return 'a';";
                        case "VB": return "Return \"a\"c";
                        case "JS": return "return 'a';";
                    }
                }
                break;

            case "Guid":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return Guid.NewGuid();";
                        case "VB": return "Return Guid.NewGuid()";
                        case "JS": return "return \"\";";
                    }
                }
                break;
            case "Object":
                {
                    switch (scriptLang) {
                        case "CSharp": return "return null;";
                        case "VB": return "Return Nothing";
                        case "JS": return "return null;";
                    }
                }
                break;
        }

        return "";
    }

    form.updateFunctionLabel = function () {
        var labelText = "";
        var createLabel = function (text, color, margin) {
            return "<p style='display:inline-block; margin:" + (margin || "0 4px 0 0") + "; color:" + color + ";'>" + text + "</p>";
        }

        if (jsObject.options.jsMode) {
            labelText += createLabel(form.controls.name.value + "(", "#696969", "0");
        }
        else {
            labelText += createLabel(jsObject.ConvertArgTypeToString(form.controls.returnType.key), "#3b8ad5");
            labelText += createLabel(form.controls.name.value + "(", "#696969", "0");
        }

        var argumentss = form.controls.argumentsContainer.getItems()

        var isFirstArgument = true;
        for (var i = 0; i < argumentss.length; i++) {
            if (!isFirstArgument) {
                labelText += createLabel(",", "#696969", "0 4px 0 0");
            }

            if (jsObject.options.jsMode) {
                labelText += createLabel(argumentss[i].name + ":", "#696969", "0 4px 0 0");
                labelText += createLabel(jsObject.ConvertArgTypeToString(argumentss[i].type), "#3b8ad5", "0");
            }
            else {
                labelText += createLabel(jsObject.ConvertArgTypeToString(argumentss[i].type), "#3b8ad5");
                labelText += createLabel(argumentss[i].name, "#696969", "0");
            }

            isFirstArgument = false;
        }

        if (jsObject.options.jsMode) {
            labelText += createLabel("):", "#696969", "0");
            labelText += createLabel(jsObject.ConvertArgTypeToString(form.controls.returnType.key), "#3b8ad5", "0 0 0 4px");
        }
        else {
            labelText += createLabel(")", "#696969", "0");
        }

        form.controls.labelTextContainer.innerHTML = labelText;
    }

    form.updateCodeSample = function () {
        form.controls.sampleTextContainer.innerHTML = "<b>" + jsObject.loc.FormFormatEditor.Sample + "</b>: " + form.getReturnTypeScript();
    }

    form.updateControlsVisibleStates = function () {
        form.controls.argumentNameRow.style.display = form.controls.argumentTypeRow.style.display = argsContainer.getCountItems() > 0 && argsContainer.selectedItem ? "" : "none";
        form.controls.customCategoryRow.style.display = form.controls.category.key == "Custom" ? "" : "none";
        form.controls.sampleTextContainer.style.visibility = form.controls.scriptMode.key == "Code" ? "visible" : "hidden";
    }

    form.getCurrentUserFunction = function () {
        var userfunction = {};
        userfunction.mode = this.mode;
        userfunction.name = this.controls.name.value;
        userfunction.description = StiBase64.encode(this.controls.description.value);
        userfunction.category = this.controls.category.key;
        userfunction.customCategory = this.controls.customCategory.value;
        userfunction.returnType = this.controls.returnType.key;
        userfunction.arguments = this.controls.argumentsContainer.getItems();
        userfunction.scriptMode = this.controls.scriptMode.key;
        if (this.mode == "Edit") userfunction.oldName = this.userfunction.name;

        userfunction.scriptCSharp = StiBase64.encode(this.controls.scriptContainer.scriptText.CSharp);
        userfunction.scriptJS = StiBase64.encode(this.controls.scriptContainer.scriptText.JS);
        userfunction.scriptVB = StiBase64.encode(this.controls.scriptContainer.scriptText.VB);
        userfunction.scriptBlockly = StiBase64.encode(this.controls.scriptContainer.scriptText.Blockly);

        return userfunction;
    }

    form.onshow = function () {
        this.mode = "Edit";
        if (this.userfunction == null) {
            this.userfunction = jsObject.UserFunctionObject();
            this.mode = "New";
        }
        saveCopyButton.style.visibility = this.mode == "Edit" ? "visible" : "hidden";
        stimulAIButton.style.display = jsObject.options.showStimulAI ? "inline-block" : "none";

        var caption = jsObject.loc.UserFunctionEditor["UserFunction" + this.mode];
        this.caption.innerHTML = caption;
        this.controls.name.hideError();
        this.controls.name.focus();
        this.controls.name.value = this.userfunction.name;
        this.controls.description.value = StiBase64.decode(this.userfunction.description);
        this.controls.category.setKey(this.userfunction.category);
        this.controls.customCategory.value = this.userfunction.customCategory;
        this.controls.returnType.setKey(this.userfunction.returnType);
        this.controls.scriptMode.setKey(this.userfunction.scriptMode);
        this.controls.argumentsContainer.fill(this.userfunction.arguments);

        scriptContainer.scriptText.CSharp = StiBase64.decode(this.userfunction.scriptCSharp);
        scriptContainer.scriptText.JS = StiBase64.decode(this.userfunction.scriptJS);
        scriptContainer.scriptText.VB = StiBase64.decode(this.userfunction.scriptVB);
        scriptContainer.scriptText.Blockly = StiBase64.decode(this.userfunction.scriptBlockly);

        var scriptLang = jsObject.options.jsMode
            ? "JS"
            : jsObject.options.report && jsObject.options.report.properties.scriptLanguage ? jsObject.options.report.properties.scriptLanguage : "CSharp";

        scriptContainer.setScriptLanguage(scriptLang);
        scriptContainer.updateMode();

        this.updateControlsVisibleStates();
        this.updateFunctionLabel();
        this.updateCodeSample();

        errorBlock.style.width = form.container.offsetWidth + "px";
        errorBlock.style.display = (!jsObject.options.jsMode && this.userfunction.scriptMode == "Code" && jsObject.options.report && jsObject.options.report.properties.calculationMode == "Interpretation") ? "" : "none";
    }

    form.action = function () {
        this.controls.name.value = this.controls.name.value.trim();

        if (!this.controls.name.checkNotEmpty(jsObject.loc.PropertyMain.Name))
            return;

        if ((this.mode == "New" || this.controls.name.value != this.userfunction.name) &&
            (!(this.controls.name.checkExists(jsObject.GetUserFunctionsFromDictionary(jsObject.options.report.dictionary), "name") &&
                this.controls.name.checkExists(jsObject.GetDataSourcesFromDictionary(jsObject.options.report.dictionary), "name") &&
                this.controls.name.checkExists(jsObject.GetVariablesFromDictionary(jsObject.options.report.dictionary), "name")) ||
                !this.controls.name.checkCorrectName(jsObject.loc.PropertyMain.Name)))
            return;

        this.changeVisibleState(false);
        jsObject.SendCommandCreateOrEditUserFunction(this.getCurrentUserFunction());
    }

    return form;
}

StiMobileDesigner.prototype.UserFunctionArgumentsContainer = function (form) {
    var container = this.DataContainer(null, null, true, " ");
    container.multiItems = true;
    container.style.minHeight = "90px";
    container.style.maxHeight = "120px";

    container.getNewItemName = function (baseName) {
        var itemName = baseName;

        var index = 0;
        var flag = false;
        if (container.getCountItems() > 0) {
            while (!flag) {
                index++;
                flag = true;
                for (var i = 0; i < container.childNodes.length; i++) {
                    if (container.childNodes[i].itemObject.name.toLowerCase() == itemName.toLowerCase() + index) {
                        flag = false;
                        break;
                    }
                }
            }
            return itemName + (index == 0 ? "" : index);
        }
        else {
            return itemName + "1";
        }
    }

    container.getItemCaption = function (name, type) {
        return name + " : " + type;
    }

    return container;
}

StiMobileDesigner.prototype.InitializeCodeEditorForm = function (editUserFuncForm) {
    var jsObject = this;
    var form = this.InitializeBaseExpressionEditorForm("codeEditor", this.loc.FormTitles.CodeEditorForm, 3, this.GetHelpLink("expression"));

    form.getDataForAI = function () {
        var dataForAI = editUserFuncForm.getDataForAI();
        dataForAI.script = StiBase64.encode(form.expressionTextArea.value);
        dataForAI.commandName = "userFunctionCheckScript";

        return dataForAI;
    }

    if (jsObject.options.showStimulAI) {
        //Check Expression
        var stimulAIButton = this.FormButton(null, null, this.loc.StimulAI.CheckWithStimulAI, null);
        stimulAIButton.style.margin = "12px 0 12px 12px";
        stimulAIButton.style.display = "inline-block";

        stimulAIButton.action = function () {
            jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                stimulAIForm.show(form, form.expressionTextArea, function () {
                    stimulAIForm.sendButtonAction("UserFunctionCheckScript");
                });
            });
        }

        var footerTable = this.CreateHTMLTable();
        footerTable.style.width = "100%";
        var buttonsPanel = form.buttonsPanel;
        form.removeChild(buttonsPanel);
        form.appendChild(footerTable);
        footerTable.addCell(stimulAIButton).style.textAlign = "left";
        footerTable.addCell();
        footerTable.addCell(form.buttonOk).style.width = "1px";
        footerTable.addCell(form.buttonCancel).style.width = "1px";
    }

    return form;
}