﻿
StiMobileDesigner.prototype.InitializeEditPdfElementForm_ = function () {
    var jsObject = this;
    var form = this.BaseFormPanel("editPdfElement", this.loc.Components.StiPdfDigitalSignatureElement, 1, this.GetHelpLink("signature"));
    form.controls = {};

    var message = document.createElement("div");
    message.className = "stiDesignerTextContainer";
    message.style.width = "450px";
    message.style.margin = "12px";
    message.innerHTML = this.loc.Signature.PdfDigitalSignatureTitle;
    form.container.appendChild(message);

    var controlsTable = this.CreateHTMLTable();
    controlsTable.style.width = "100%";
    form.container.appendChild(controlsTable);

    var appearance = this.DropDownList("appearancePdfElem", 200, null, this.GetSignatureAppearanceItems(), true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Type, "appearance", appearance, "12px", true);

    appearance.action = function () {
        form.applyProperty("signatureAppearance", this.key);
        form.updateControlsVisibleStates();
    }

    var objectsHeader = this.FormBlockHeader(this.loc.QueryBuilder.Objects);
    form.container.appendChild(objectsHeader);

    var imageControl = this.ImageControl(null, 450, 170);
    imageControl.style.margin = "12px";
    imageControl.style.borderStyle = "solid";
    form.container.appendChild(imageControl);

    imageControl.action = function () {
        form.applyProperty("signatureImageBytes", imageControl.src);
    }

    var drawControl = this.InitializeDrawControl(null, 450, 170);
    drawControl.style.margin = "12px";
    form.container.appendChild(drawControl);

    drawControl.action = function () {
        form.applyProperty("signatureDrawBytes", this.getCanvasContent());
    }

    var labelsHeader = this.FormBlockHeader(this.loc.PropertyCategory.LabelsCategory);
    form.container.appendChild(labelsHeader);

    var labelsTable = this.CreateHTMLTable();
    labelsTable.style.width = "100%";
    labelsTable.style.margin = "12px";
    form.container.appendChild(labelsTable);

    var labels = [
        ["Name", this.loc.PropertyMain.Name],
        ["DistinguishedName", this.loc.PropertyMain.DistinguishedName],
        ["Date", this.loc.FormFormatEditor.Date],
        ["Location", this.loc.PropertyMain.Location],
        ["Logo", this.loc.PropertyMain.Logo],
        ["Labels", this.loc.PropertyCategory.LabelsCategory],
        ["Reason", this.loc.PropertyMain.Reason],
        ["RightToLeft", this.loc.PropertyMain.RightToLeft]
    ];

    form.labelsControls = {};

    for (var i = 0; i < labels.length; i++) {
        var checkBox = this.CheckBox(null, labels[i][1]);
        checkBox.name = labels[i][0];
        checkBox.style.marginBottom = "12px";
        form.labelsControls[checkBox.name] = checkBox;        
        labelsTable.addCellInLastRow(checkBox);
        if (i % 2 != 0) labelsTable.addRow();

        checkBox.action = function () {
            if (this.name == "RightToLeft") {
                form.applyProperty("rightToLeft", this.isChecked);
            }
            else {
                form.applyProperty("signatureOptions", form.getLabels());
            }
        }
    }

    form.setLabels = function () {
        var options = this.currComp.properties.signatureOptions;
        form.labelsControls.Name.setChecked(options.indexOf("Name") >= 0 || options.indexOf("Default") >= 0 || options.indexOf("HasText") >= 0);
        form.labelsControls.DistinguishedName.setChecked(options.indexOf("DistinguishedName") >= 0 || options.indexOf("HasText") >= 0);
        form.labelsControls.Date.setChecked(options.indexOf("Date") >= 0 || options.indexOf("Default") >= 0 || options.indexOf("HasText") >= 0);
        form.labelsControls.Location.setChecked(options.indexOf("Location") >= 0 || options.indexOf("HasText") >= 0);
        form.labelsControls.Logo.setChecked(options.indexOf("Logo") >= 0 || options.indexOf("Default") >= 0);
        form.labelsControls.Labels.setChecked(options.indexOf("Labels") >= 0 || options.indexOf("Default") >= 0);
        form.labelsControls.Reason.setChecked(options.indexOf("Reason") >= 0 || options.indexOf("HasText") >= 0);
        form.labelsControls.RightToLeft.setChecked(this.currComp.properties.rightToLeft);
    }

    form.getLabels = function () {
        var result = "";

        for (var labelName in form.labelsControls) {
            if (labelName == "RightToLeft") continue;
            var checkBox = form.labelsControls[labelName];

            if (checkBox.isChecked) {
                if (result != "") result += ", ";
                result += labelName;
            }
        }
        return result;
    }
        
    form.updateControls = function () {
        var props = this.currComp.properties;
        appearance.setKey(props.signatureAppearance);
        imageControl.setImage(props.signatureImageBytes);
        drawControl.setCanvasContent(props.signatureDrawBytes);
        this.setLabels();
    }

    form.updateControlsVisibleStates = function () {
        objectsHeader.style.display = appearance.key == "Image" || appearance.key == "Draw" ? "" : "none";
        imageControl.style.display = appearance.key == "Image" ? "" : "none";
        drawControl.style.display = appearance.key == "Draw" ? "" : "none";
    }

    form.applyProperty = function (propertyName, propertyValue) {
        this.currComp.properties[propertyName] = propertyValue;
        jsObject.SendCommandSendProperties([this.currComp], [propertyName], true);
    }

    form.onshow = function () {
        var selectedObject = jsObject.options.selectedObject;

        if (!selectedObject || selectedObject.typeComponent != "StiPdfDigitalSignatureElement") {
            this.changeVisibleState(false);
        }

        this.currComp = selectedObject;
        this.oldSvgContent = selectedObject.properties.svgContent;
        this.oldProperties = jsObject.CopyObject(selectedObject.properties);

        this.updateControls();
        this.updateControlsVisibleStates();
    }

    form.action = function () {
        this.changeVisibleState(false);
    }

    form.cancelAction = function () {
        jsObject.SendCommandCanceledEditComponent(this.currComp.properties.name);

        if (this.oldProperties) {
            for (var propertyName in this.oldProperties) {
                this.currComp.properties[propertyName] = this.oldProperties[propertyName];
            }
            this.currComp.repaint();
        }
    }

    return form;
}