﻿
StiMobileDesigner.prototype.InitializeEditColumnForm_ = function () {
    var jsObject = this;
    var editColumnForm = this.BaseFormPanel("editColumnForm", this.loc.PropertyMain.Column, 3, this.GetHelpLink("columnEdit"));
    editColumnForm.column = null;
    editColumnForm.mode = "Edit";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "6px 0 6px 0";
    editColumnForm.container.appendChild(innerTable);

    //Name, NameInSource, Alias
    var textBoxes = [
        ["nameInSource", this.loc.PropertyMain.NameInSource],
        ["name", this.loc.PropertyMain.Name],
        ["alias", this.loc.PropertyMain.Alias]
    ]

    for (var i = 0; i < textBoxes.length; i++) {
        editColumnForm[textBoxes[i][0] + "ControlRow"] = innerTable.addRow();
        var text = innerTable.addCellInLastRow();
        text.className = "stiDesignerCaptionControlsBigIntervals";
        text.innerHTML = textBoxes[i][1];
        var control = editColumnForm[textBoxes[i][0] + "Control"] = this.TextBox("editColumnForm" + textBoxes[i][0], 300);
        innerTable.addCellInLastRow(control).className = "stiDesignerControlCellsBigIntervals2";
    }

    //Type
    editColumnForm.typeControlRow = innerTable.addRow();
    var textType = innerTable.addCellInLastRow();
    textType.className = "stiDesignerCaptionControlsBigIntervals";
    textType.innerHTML = this.loc.PropertyMain.Type;
    editColumnForm.typeControl = this.DropDownList("editColumnFormTypeControl", 150, null, this.GetColumnTypesItems(), true);
    innerTable.addCellInLastRow(editColumnForm.typeControl).className = "stiDesignerControlCellsBigIntervals2";

    editColumnForm.typeControl.action = function () {
        editColumnForm.typeIsChanged = true;
    }

    //Value
    editColumnForm["valueControlRow"] = innerTable.addRow();
    var textValue = innerTable.addCellInLastRow();
    textValue.className = "stiDesignerCaptionControlsBigIntervals";
    textValue.innerHTML = this.loc.PropertyMain.Value;
    textValue.style.verticalAlign = "top";
    textValue.style.paddingTop = "8px";        

    //Expression
    var expTable = this.CreateHTMLTable();
    expTable.style.display = "inline-block";
    var valueControl = editColumnForm.valueControl = this.TextArea("editColumnFormValueControl", 300, 150, true);
    expTable.addCell(valueControl);
    innerTable.addCellInLastRow(expTable).className = "stiDesignerControlCellsBigIntervals2";

    var expDictionaryTree = jsObject.options.expDictionaryTree || this.DictionaryTree(true);
    var dictionaryPanel = jsObject.DictionaryPanelForEditors(200, 225, true);
    dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
    dictionaryPanel.style.marginLeft = "12px";
    expTable.addCell(dictionaryPanel).style.display = "inline-block";

    valueControl.addInsertButton(expDictionaryTree);

    this.AddHintHelperToControl(valueControl, 65, true, true, ["DataSource.Field", "DataSource.Field + \"ABC\"", "DataSource.Field + Variable"]);

    new ResizeObserver(function () {
        if (valueControl.parentContainer.offsetHeight > 0) {
            dictionaryPanel.style.height = (valueControl.parentContainer.offsetHeight - 2) + "px";
        }
    }).observe(valueControl);

    valueControl.checkButton.action = function () {
        valueControl.checkButton.setEnabled(false);

        var params = {
            expression: StiBase64.encode(valueControl.value),
            returnType: editColumnForm.typeControl.key,
            onlyExpression: true,
            useAliases: jsObject.options.useAliases
        }

        jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
            valueControl.checkButton.setEnabled(true);

            if (answer.checkResult) {
                var message = StiBase64.decode(answer.checkResult);

                var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                messageForm.action = function (state) {
                    messageForm.changeVisibleState(false);

                    if (state) {
                        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                            stimulAIForm.show(editColumnForm, valueControl, function () {
                                stimulAIForm.sendButtonAction("FixCalcColumnExpression");
                            });
                        });
                    }
                }
            }
        });
    }

    editColumnForm.nameControl.action = function () {
        if (this.oldValue == editColumnForm.aliasControl.value) {
            editColumnForm.aliasControl.value = this.value;
        }
    }

    editColumnForm.getDataForAI = function () {
        return {
            commandName: "typedExpression",
            expression: StiBase64.encode(valueControl.value),
            returnType: editColumnForm.typeControl.key
        }
    }

    editColumnForm.onshow = function () {
        this.mode = "Edit";
        this.typeIsChanged = false;
        var dictionaryTree = jsObject.options.dictionaryTree;
        this.currentParent = dictionaryTree.getCurrentColumnParent();

        dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
        expDictionaryTree.build(jsObject.options.report.dictionary, true);
        expDictionaryTree.currentEditor = valueControl;

        if (typeof (this.column) == "string") {
            var parentObject = (this.currentParent.type == "BusinessObject")
                ? jsObject.GetBusinessObjectByNameFromDictionary(dictionaryTree.selectedItem.getBusinessObjectFullName())
                : jsObject.GetDataSourceByNameFromDictionary(this.currentParent.name);
            this.column = jsObject.ColumnObject(this.column == "calcColumn", parentObject ? parentObject.columns : null);
            this.column.isDataTransformationColumn = parentObject.typeItem == "DataSource" && parentObject.typeDataSource == "StiDataTransformation";
            this.mode = "New";
        }

        this.caption.innerHTML = jsObject.loc.FormDictionaryDesigner[(this.column.isCalcColumn ? "CalcColumn" : "Column") + this.mode];
        this.editableDictionaryItem = this.mode == "Edit" && jsObject.options.dictionaryTree ? jsObject.options.dictionaryTree.selectedItem : null;
        textValue.innerHTML = this.column.isDataTransformationColumn ? jsObject.loc.PropertyMain.Expression : jsObject.loc.PropertyMain.Value;

        this.nameInSourceControl.value = this.column.nameInSource;
        this.nameControl.focus();
        this.nameControl.value = this.column.name;
        this.aliasControl.value = this.column.alias;
        this.typeControl.setKey(this.column.type);
        this.valueControlRow.style.display = this.column.isCalcColumn || this.column.isDataTransformationColumn ? "" : "none";

        valueControl.value = StiBase64.decode(this.column.expression);
    }

    editColumnForm.action = function () {
        this.column.mode = this.mode;
        this.column.currentParentType = this.currentParent.type;
        this.column.currentParentName = this.column.currentParentType == "DataSource"
            ? this.currentParent.name
            : (this.editableDictionaryItem || jsObject.options.dictionaryTree.selectedItem).getBusinessObjectFullName();
        if (this.mode == "Edit") this.column["oldName"] = this.column.name;
        this.column.nameInSource = this.nameInSourceControl.value;
        this.column.name = this.nameControl.value;
        this.column.alias = this.aliasControl.value;
        this.column.expression = StiBase64.encode(valueControl.value);
        this.column.type = this.typeControl.key;

        if (!this.nameControl.checkNotEmpty(jsObject.loc.PropertyMain.Name)) return;
        this.changeVisibleState(false);

        jsObject.SendCommandCreateOrEditColumn(this.column);

        if (this.typeIsChanged) {
            var dataSourceObject = editColumnForm.currentParent;
            var dataSourceItem = jsObject.options.dictionaryTree.getItemByNameAndType(dataSourceObject.name, dataSourceObject.type);

            if (dataSourceItem && dataSourceItem.parent) {
                var connectionItemObject = dataSourceItem.parent.itemObject;
                if (connectionItemObject.castToColumnType == "LeaveUnprocessed") {

                    var msgForm = jsObject.MessageFormChangeColumnType();
                    msgForm.changeVisibleState(true);

                    msgForm.action = function (state) {
                        if (state) {
                            var params = {
                                propertyName: "castToColumnType",
                                propertyValue: "CastToColumnType",
                                itemObject: connectionItemObject
                            };
                            jsObject.SendCommandToDesignerServer("SetDictionaryElementProperty", params, function (answer) {
                                jsObject.options.report.dictionary = answer.dictionary;
                                jsObject.options.dictionaryTree.build(answer.dictionary, true);
                            });
                        }
                    }
                }
            }
        }
    }

    return editColumnForm;
}