﻿
StiMobileDesigner.prototype.InitializeCrossTabForm_ = function () {
    var jsObject = this;
    var crossTabForm = this.BaseFormPanel("crossTabForm", " ", 1, this.GetHelpLink("crosstabform"));
    crossTabForm.container.style.paddingTop = "6px";
    crossTabForm.controls = {};
    crossTabForm.selectedContainerItem = null;
    crossTabForm.minimizeMode = true;

    var showMore = this.FormButton(null, null, this.loc.Buttons.ShowMore);
    showMore.style.display = "inline-block";
    showMore.style.margin = "12px";

    showMore.action = function () {
        crossTabForm.setMinimizeMode(!crossTabForm.minimizeMode);
    }

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = crossTabForm.buttonsPanel;
    crossTabForm.removeChild(buttonsPanel);
    crossTabForm.appendChild(footerTable);
    footerTable.addCell(showMore).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(crossTabForm.buttonOk).style.width = "1px";
    footerTable.addCell(crossTabForm.buttonCancel).style.width = "1px";

    var mainTable = this.CreateHTMLTable();
    crossTabForm.container.appendChild(mainTable);

    //DataSource
    var dataSourceControl = this.DataSourcesControl(null, 246);
    dataSourceControl.style.marginLeft = "12px";
    var dataSourceText = this.CrossTabContainerHeader(this.loc.PropertyMain.DataSource);
    dataSourceText.style.margin = "0 0 8px 12px";

    var leftCell = mainTable.addCell(dataSourceText);
    leftCell.appendChild(dataSourceControl);
    leftCell.className = "stiDesignerCrossTabContainerCell";

    dataSourceControl.action = function () {
        crossTabForm.rebuildColumnsTree();
        crossTabForm.sendCommand({
            command: "ChangedDataSource",
            dataSourceName: this.key.dataSource || this.key.businessObject,
            dataSourceType: this.key.dataSource ? "DataSource" : (this.key.businessObject ? "BusinessObject" : "")
        });
        crossTabForm.updateDataMode();
    }

    //ColumnsTree
    var columnsCont = document.createElement("div");
    columnsCont.className = "stiSimpleContainerWithBorder";
    columnsCont.style.width = "250px";
    columnsCont.style.height = "295px";
    columnsCont.style.overflow = "auto";
    columnsCont.style.margin = "12px";
    leftCell.appendChild(columnsCont);

    var columnsTree = crossTabForm.controls.columnsTree = this.DataTree();
    columnsCont.appendChild(columnsTree);

    columnsCont.onmouseup = function (event) {
        if (jsObject.options.itemInDrag) {
            var originalItem = jsObject.options.itemInDrag.originalItem;
            var itemObject = jsObject.CopyObject(originalItem.itemObject);

            if (!itemObject || originalItem.tree != jsObject.options.dictionaryTree) return;
            var typeItem = itemObject.typeItem;

            if (typeItem == "Column" || typeItem == "DataSource" || typeItem == "BusinessObject") {
                var draggedItem = {}

                if (typeItem == "Column") {
                    var columnParent = jsObject.options.dictionaryTree.getCurrentColumnParent();
                    if (columnParent) {
                        draggedItem.currentParentType = columnParent.type;
                        draggedItem.currentParentName = (columnParent.type == "BusinessObject") ? jsObject.options.itemInDrag.originalItem.getBusinessObjectFullName() : columnParent.name;
                    }
                }
                else if (typeItem == "DataSource" || typeItem == "BusinessObject") {
                    draggedItem.currentParentType = typeItem;
                    draggedItem.currentParentName = itemObject.name;
                }

                dataSourceControl.setKey({
                    dataSource: draggedItem.currentParentType == "DataSource" ? draggedItem.currentParentName : "",
                    businessObject: draggedItem.currentParentType == "BusinessObject" ? draggedItem.currentParentName : "",
                });

                dataSourceControl.action();
            }
        }
    }

    //Columns Containers
    var rightTable = this.CreateHTMLTable();
    var rightCell = mainTable.addCell(rightTable);
    rightCell.className = "stiDesignerCrossTabContainerCell";
    rightCell.style.borderRight = "0";
    rightCell.style.position = "relative";

    var selDataText = this.CrossTabSelectDataPanel();
    rightCell.appendChild(selDataText);

    crossTabForm.updateDataMode = function () {
        var dataDefined = dataSourceControl.key.dataSource || dataSourceControl.key.businessObject;
        rightTable.style.visibility = dataDefined ? "visible" : "hidden";
        selDataText.style.display = dataDefined ? "none" : "";
    }

    var columnsContainer = crossTabForm.controls.columnsContainer = this.CrossTabContainer(crossTabForm, "columns", 250, 160, this.loc.FormCrossTabDesigner.Columns.replace(":", ""));
    var rowsContainer = crossTabForm.controls.rowsContainer = this.CrossTabContainer(crossTabForm, "rows", 250, 160, this.loc.FormCrossTabDesigner.Rows.replace(":", ""));
    var summaryContainer = crossTabForm.controls.summaryContainer = this.CrossTabContainer(crossTabForm, "summary", 250, 160, this.loc.FormCrossTabDesigner.Summary.replace(":", ""));

    columnsContainer.style.margin = "12px";
    summaryContainer.style.margin = "0 12px 12px 12px";
    rowsContainer.style.margin = "0 0 12px 12px";

    columnsContainer.onAction = function () {
        crossTabForm.onActionContainers(this);        
    }

    rowsContainer.onAction = function () {
        crossTabForm.onActionContainers(this);
    }

    summaryContainer.onAction = function () {
        if (crossTabForm.controls.summaryDirectionButton) {
            crossTabForm.controls.summaryDirectionButton.style.display = this.getCountItems() > 1 ? "" : "none";
        }
        crossTabForm.onActionContainers(this);
    }

    var fxButton = this.SmallButton(null, null, "", "Function.png", null, "Down", "stiDesignerFormButton");
    fxButton.style.display = "inline-block";
    fxButton.style.marginRight = "2px";
    fxButton.style.height = "22px";
    fxButton.arrowCell.style.padding = "0 4px 0 4px";

    fxButton.setKey = function (key) {
        this.key = key;
        fxButton.caption.innerHTML = key != "None" ? key : "";
    }

    summaryContainer.toolBar.insertCell(2, fxButton).style.lineHeight = "0";

    var fxMenu = this.VerticalMenu("crossTabSummaryFxMenu", fxButton, "Down", this.GetSummaryTypeForCrossTabFiledItems());

    fxMenu.innerContent.appendChild(jsObject.VerticalMenuSeparator(fxMenu, "sep"));

    var showPercentsControl = this.CheckBox(null, this.loc.PropertyMain.ShowPercents);
    showPercentsControl.style.margin = "12px";
    fxMenu.innerContent.appendChild(showPercentsControl);

    showPercentsControl.action = function () {
        fxButton.showPercents = this.isChecked;

        var crossTabProps = jsObject.options.propertiesPanel.editCrossTabPropertiesPanel;
        if (crossTabProps && crossTabProps.groups.Data) {
            var showPercentsC = crossTabProps.groups.Data.properties.showPercents.control;
            showPercentsC.setChecked(this.isChecked);
            showPercentsC.action();
        }
    }

    fxButton.action = function () {
        fxMenu.changeVisibleState(!fxMenu.visible);
    }

    fxMenu.onshow = function () {
        if (this.items[fxButton.key]) {
            this.items[fxButton.key].setSelected(true);
        }
        showPercentsControl.setChecked(fxButton.showPercents);
    }

    fxMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        fxButton.setKey(menuItem.key);

        var crossTabProps = jsObject.options.propertiesPanel.editCrossTabPropertiesPanel;
        if (crossTabProps && crossTabProps.groups.Data) {
            var summaryControl = crossTabProps.groups.Data.properties.summary.control;
            summaryControl.setKey(menuItem.key);
            summaryControl.action();
        }
    }

    crossTabForm.onActionContainers = function (aciveContainer, notUpdateProps) {
        this.selectedContainerItem = aciveContainer.selectedItem;
        if (columnsContainer != aciveContainer) columnsContainer.setNotActive();
        if (rowsContainer != aciveContainer) rowsContainer.setNotActive();
        if (summaryContainer != aciveContainer) summaryContainer.setNotActive();
        if (!notUpdateProps) this.updateProperties();
        fxButton.setEnabled(summaryContainer.getCountItems() > 0 && summaryContainer.selectedItem);
        jsObject.options.propertiesPanel.showContainer(this.selectedContainerItem ? "Properties" : "Dictionary");
    }

    crossTabForm.updateProperties = function () {
        var crossTabPropPanel = jsObject.options.propertiesPanel.editCrossTabPropertiesPanel;

        if (this.selectedContainerItem && crossTabForm.controls.resultPage) {
            for (var i = 0; i < crossTabForm.controls.resultPage.childNodes.length; i++) {
                var component = crossTabForm.controls.resultPage.childNodes[i];
                if (component.properties && this.selectedContainerItem && component.properties.name == this.selectedContainerItem.itemObject.name) {
                    component.action();

                    if (component.properties.summary) {
                        fxButton.setKey(component.properties.summary);
                        fxButton.showPercents = component.properties.showPercents;
                    }
                    break;
                }
            }
        }
        else {
            if (jsObject.options.selectedCrossTabField) jsObject.options.selectedCrossTabField.setSelected(false);
            crossTabPropPanel.updateProperties(null);
        }
    }

    //Summary Direction
    var summaryDirection = this.options.selectedObject ? this.options.selectedObject.properties.summaryDirection : "LeftToRight";
    var sumDirButton = crossTabForm.controls.summaryDirectionButton = this.FormImageButton(null, "CrossTab." + summaryDirection + "Direction.png", this.loc.PropertyMain.Direction);
    sumDirButton.style.display = "none";

    var buttonsTable = this.CreateHTMLTable();
    buttonsTable.style.display = "inline-block";
    buttonsTable.style.margin = "0 0 10px 0";
    buttonsTable.addCell(sumDirButton).style.paddingRight = "4px";

    var emptyCell = rightTable.addCell(buttonsTable)
    emptyCell.style.verticalAlign = "bottom";
    emptyCell.style.textAlign = "right";

    sumDirButton.action = function () {
        var selectedObject = jsObject.options.selectedObject;
        if (!selectedObject) return;
        selectedObject.properties.summaryDirection = selectedObject.properties.summaryDirection == "LeftToRight" ? "UpToDown" : "LeftToRight";
        StiMobileDesigner.setImageSource(sumDirButton.image, jsObject.options, "CrossTab." + selectedObject.properties.summaryDirection + "Direction.png");

        crossTabForm.sendCommand({
            command: "ChangeSummaryDirection",
            summaryDirection: selectedObject.properties.summaryDirection
        });
    }

    var rotateButton = this.FormImageButton(null, "CrossTab.Rotate.png", this.loc.FormCrossTabDesigner.Swap);
    buttonsTable.addCell(rotateButton);

    rotateButton.action = function () {
        crossTabForm.sendCommand({
            command: "SwapColumnsAndRows"
        });
    }

    rightTable.addCell(columnsContainer);
    rightTable.addCellInNextRow(rowsContainer);
    rightTable.addCellInLastRow(summaryContainer);

    //Result Container
    var resultContainer = document.createElement("div");
    resultContainer.style.padding = "10px";
    resultContainer.style.overflow = "auto";
    resultContainer.style.position = "relative";
    resultContainer.style.minHeight = "150px";
    crossTabForm.controls.resultContainer = resultContainer;

    var notDataText = document.createElement("div");
    notDataText.innerHTML = this.loc.Dashboard.DataNotDefined;
    notDataText.className = "stiDesignerCrossTabNotDataPanel";
    notDataText.style.display = "none";
    resultContainer.appendChild(notDataText);

    var resultCell = mainTable.addCellInNextRow(resultContainer);
    resultCell.setAttribute("colspan", "2");
    resultCell.className = "stiDesignerCrossTabResultCell";
    resultCell.style.display = "none";

    resultContainer.update = function (compObjects, selectedComponentName) {
        if (crossTabForm.controls.resultPage) {
            resultContainer.removeChild(crossTabForm.controls.resultPage);
            crossTabForm.controls.resultPage = null;
        }
        notDataText.style.display = "";

        if (compObjects && compObjects.length > 0) {
            //paint components
            var oldZoom = jsObject.options.report.zoom;
            jsObject.options.report.zoom = 1;

            var resultPage = crossTabForm.controls.resultPage = jsObject.CreateCrossTabResultPage();
            resultContainer.appendChild(resultPage);
            notDataText.style.display = "none";

            for (var i = 0; i < compObjects.length; i++) {
                var newComponent = jsObject.CreateCrossTabFieldComponent(compObjects[i], true);
                newComponent.repaint();
                resultPage.appendChild(newComponent);
                newComponent.parentContainer = resultPage;

                if (selectedComponentName != null && newComponent.properties.name == selectedComponentName) {
                    newComponent.action();
                }
            }
            resultContainer.updateSizes();
            jsObject.options.report.zoom = oldZoom;
        }
    }

    resultContainer.updateSizes = function () {
        var resultPage = crossTabForm.controls.resultPage;
        if (resultPage) {
            try {
                var bbox = resultPage.getBBox();
                if (bbox) {
                    resultPage.style.padding = "5px";
                    resultPage.setAttribute("width", parseInt(bbox.x + bbox.width) + 5);
                    resultPage.setAttribute("height", parseInt(bbox.y + bbox.height) + 5);
                }
            }
            catch (e) { }
        }
    }

    crossTabForm.updateContainers = function (fieldsProperties, activeContainerName, selectedIndex) {
        columnsContainer.fill(fieldsProperties.columns);
        rowsContainer.fill(fieldsProperties.rows);
        summaryContainer.fill(fieldsProperties.summary);

        var currContainer = crossTabForm.controls[activeContainerName + "Container"];
        if (currContainer && selectedIndex != null && selectedIndex < currContainer.getCountItems()) {
            var item = currContainer.getItemByIndex(selectedIndex);
            if (item) item.action();
        }
    }

    crossTabForm.rebuildColumnsTree = function () {
        var currDataSourceName = dataSourceControl.key.dataSource || dataSourceControl.key.businessObject;

        if (currDataSourceName) {
            columnsTree.build("Column", currDataSourceName, true);
            if (columnsTree.mainItem) {
                for (var key in columnsTree.mainItem.childs) {
                    var itemObject = columnsTree.mainItem.childs[key].itemObject;
                    if (!itemObject) continue;
                    if (itemObject.typeItem == "NoItem") columnsTree.mainItem.childs[key].style.display = "none";
                    if (itemObject.typeItem == "DataSource") columnsTree.mainItem.childs[key].setOpening(true);
                }
            }
        }
        else {
            columnsTree.clear();
        }

        columnsContainer.clear();
        rowsContainer.clear();
        summaryContainer.clear();
        crossTabForm.selectedContainerItem = null;
        resultContainer.update();
        crossTabForm.updateProperties();
    }

    crossTabForm.setMinimizeMode = function (state) {
        this.minimizeMode = state;
        showMore.caption.innerText = state ? jsObject.loc.Buttons.ShowMore : jsObject.loc.Buttons.ShowLess;
        resultCell.style.display = state ? "none" : "";
        resultContainer.updateSizes();
        crossTabForm.correctHeight();
        jsObject.SetObjectToCenter(crossTabForm);
    }

    crossTabForm.onshow = function () {
        var selectedObject = jsObject.options.selectedObject;
        if (!selectedObject) this.changeVisibleState(false);
        this.selectedObject = selectedObject;

        dataSourceControl.setKey({
            dataSource: selectedObject.properties.dataSource != "[Not Assigned]" ? selectedObject.properties.dataSource : "",
            businessObject: selectedObject.properties.businessObject != "[Not Assigned]" ? selectedObject.properties.businessObject : ""
        });

        jsObject.options.propertiesPanel.setEditCrossTabMode(true);

        crossTabForm.rebuildColumnsTree();
        crossTabForm.updateContainers(selectedObject.properties.crossTabFields);
        crossTabForm.updateDataMode();
        resultContainer.update(selectedObject.properties.crossTabFields.components);

        StiMobileDesigner.setImageSource(crossTabForm.controls.summaryDirectionButton.image, jsObject.options, "CrossTab." + selectedObject.properties.summaryDirection + "Direction.png");
        summaryContainer.onAction();
    }

    crossTabForm.onhide = function () {
        jsObject.options.propertiesPanel.setEditCrossTabMode(false);
        jsObject.DeleteTemporaryMenus();
    }

    crossTabForm.action = function () {
        this.changeVisibleState(false);

        var properties = this.selectedObject.properties;
        properties.dataSource = dataSourceControl.key.dataSource || "[Not Assigned]";
        properties.businessObject = dataSourceControl.key.businessObject || "[Not Assigned]";

        jsObject.SendCommandSendProperties(this.selectedObject, ["dataSource", "businessObject"]);
    }

    crossTabForm.cancelAction = function () {
        jsObject.SendCommandCanceledEditComponent(this.selectedObject.properties.name);
    }

    crossTabForm.sendCommand = function (parameters) {
        jsObject.SendCommandUpdateCrossTabComponent(this.selectedObject.properties.name, parameters);
    }

    crossTabForm.recieveCommandResult = function (result) {

        switch (result.command) {
            case "InsertItemToContainer":
            case "RemoveItemFromContainer":
            case "SwapColumnsAndRows":
            case "ItemMoveDown":
            case "ItemMoveUp":
                {
                    crossTabForm.updateContainers(result.fieldsProperties, result.containerName, result.selectedIndex);
                    resultContainer.update(result.fieldsProperties.components);
                    crossTabForm.updateProperties();
                    break;
                }
            case "UpdateProperty":
                {
                    resultContainer.update(result.fieldsProperties.components, result.selectedComponentName);
                    break;
                }
            case "ChangeSummaryDirection":
            case "ItemMoveToIndex":
                {
                    resultContainer.update(result.fieldsProperties.components);
                    crossTabForm.updateProperties();
                    break;
                }
        }
    }

    return crossTabForm;
}

StiMobileDesigner.prototype.CrossTabContainerHeader = function (caption) {
    var header = this.SimpleTextContainer(caption);
    header.style.opacity = "0.8";
    header.style.height = this.options.controlsHeight + "px";

    return header;
}

StiMobileDesigner.prototype.CrossTabContainerToolButton = function (caption, imageName, toolTip, height) {
    var button = this.StandartSmallButton(null, null, caption, imageName, toolTip, null, true);
    if (button.imageCell) button.imageCell.style.padding = "0 3px 0 3px";
    button.style.height = height + "px";

    return button;
}

StiMobileDesigner.prototype.CrossTabContainer = function (crossTabForm, name, width, height, headerCaption) {
    var container = document.createElement("div");
    var jsObject = container.jsObject = this;
    container.selectedItem = null;
    container.onAction = function () { };
    container.name = name;
    container.style.position = "relative";

    var dropDataText = document.createElement("div");
    dropDataText.innerHTML = this.loc.Dashboard.DragDropData;
    dropDataText.className = "stiDesignerCrossTabNotDataPanel";
    dropDataText.style.display = "none";
    dropDataText.style.width = width + "px";
    dropDataText.style.left = "0";
    dropDataText.style.top = "calc(50% + 5px)";
    container.appendChild(dropDataText);

    //Toolbar
    var toolBarHeight = 22;
    var toolBar = container.toolBar = this.CreateHTMLTable();
    toolBar.className = "stiDesignerrCrossTabContainerToolbar";
    container.appendChild(toolBar);

    var moveUpButton = this.CrossTabContainerToolButton(null, "Arrows.ArrowUpBlue.png", this.loc.QueryBuilder.MoveUp, toolBarHeight);
    var moveDownButton = this.CrossTabContainerToolButton(null, "Arrows.ArrowDownBlue.png", this.loc.QueryBuilder.MoveDown, toolBarHeight);
    var removeButton = this.CrossTabContainerToolButton(null, "Remove.png", this.loc.Buttons.Remove, toolBarHeight);

    toolBar.addCell(this.CrossTabContainerHeader(headerCaption));
    toolBar.addCell().style.width = "100%";
    toolBar.addCell(moveUpButton);
    toolBar.addCell(moveDownButton);
    toolBar.addCell(removeButton);

    moveUpButton.setEnabled(false);
    moveDownButton.setEnabled(false);
    removeButton.setEnabled(false);

    if (!jsObject.options.isTouchDevice) {
        moveUpButton.style.display = moveDownButton.style.display = removeButton.style.display = "none";
    }

    var moveItem = function (direction) {
        if (container.selectedItem) {
            var params = {
                command: "ItemMove" + direction,
                indexForMoving: container.selectedItem.getIndex(),
                containerName: container.name
            }
            container.selectedItem.move(direction);
            params.selectedIndexAfterMoving = container.selectedItem.getIndex();
            crossTabForm.sendCommand(params);
        }
    }

    moveUpButton.action = function () {
        moveItem("Up");
    }

    moveDownButton.action = function () {
        moveItem("Down");
    }

    removeButton.action = function () {
        if (container.selectedItem) {
            var indexForRemove = container.selectedItem.getIndex();
            container.selectedItem.remove();

            crossTabForm.sendCommand({
                command: "RemoveItemFromContainer",
                indexForRemove: indexForRemove,
                containerName: container.name,
                selectIndexAfterRemoved: container.selectedItem ? container.selectedItem.getIndex() : null
            });
        }
    }

    toolBar.updateControls = function () {
        var count = container.getCountItems();
        var index = container.selectedItem ? container.selectedItem.getIndex() : -1;
        moveUpButton.setEnabled(index > 0);
        moveDownButton.setEnabled(index != -1 && index < count - 1);
        removeButton.setEnabled(count > 0 && index != -1);
        dropDataText.style.display = count > 0 ? "none" : "";
    }

    //Container
    var innerContainer = document.createElement("div");
    innerContainer.className = "stiSimpleContainerWithBorder";
    innerContainer.style.width = width + "px";
    innerContainer.style.height = (height - toolBarHeight) + "px";
    innerContainer.style.overflow = "auto";
    container.innerContainer = innerContainer;
    container.appendChild(innerContainer);

    container.clear = function (runActionEvent) {
        while (innerContainer.childNodes[0]) innerContainer.removeChild(innerContainer.childNodes[0]);
        this.selectedItem = null;
        toolBar.updateControls();
        if (runActionEvent) this.onAction();
    }

    container.addItem = function (itemObject, runActionEvent, insertIndex) {
        var item = jsObject.StandartSmallButton(null, null, itemObject.alias, null);
        item.name = itemObject.name;
        item.itemObject = itemObject;
        item.innerTable.style.width = "100%";

        if (item.caption) {
            item.caption.style.width = "100%";
            var captCont = document.createElement("div");
            item.captionContainer = captCont;
            captCont.style.position = "relative";
            captCont.style.overflow = "hidden";
            captCont.style.textOverflow = "ellipsis";
            captCont.style.padding = "2px 0 2px 0";
            captCont.style.maxWidth = (width - 50) + "px";
            captCont.innerHTML = itemObject.alias;
            item.caption.innerHTML = "";
            item.caption.appendChild(captCont);
        }

        var closeButton = item.closeButton = jsObject.StandartSmallButton(null, null, null, "CloseForm.png");
        closeButton.imageCell.style.padding = "0";
        closeButton.style.margin = "1px";
        closeButton.style.background = "white";
        closeButton.style.height = closeButton.style.width = "20px";
        closeButton.style.display = "none";
        closeButton.style.background = "transparent";
        closeButton.innerTable.style.width = "100%";
        item.innerTable.addCell(closeButton).style.width = "1px";

        closeButton.onmouseenter = function () {
            if (!this.isEnabled || jsObject.options.isTouchClick) return;
            this.className = this.overClass;
            this.isOver = true;
            this.image.style.opacity = "0.8";
        }

        closeButton.onmouseleave = function () {
            this.isOver = false;
            if (!this.isEnabled) return;
            this.className = this.isSelected ? this.selectedClass : this.defaultClass;
            this.image.style.opacity = "1";
        }

        closeButton.action = function () {
            item.closeButtonAction = true;
            removeButton.action();
        }

        if (insertIndex != null && insertIndex < innerContainer.childNodes.length)
            innerContainer.insertBefore(item, innerContainer.childNodes[insertIndex]);
        else
            innerContainer.appendChild(item);

        toolBar.updateControls();
        if (runActionEvent) container.onAction();

        if (!jsObject.options.isTouchDevice) {
            item.onmouseenter = function () {
                this.className = this.overClass;
                this.isOver = true;
                closeButton.style.display = "";
            }

            item.onmouseleave = function () {
                this.isOver = false;
                this.className = this.isSelected ? this.selectedClass : this.defaultClass;
                closeButton.style.display = "none";
            }
        }

        item.select = function () {
            if (container.selectedItem) container.selectedItem.setSelected(false);
            this.setSelected(true);
            container.selectedItem = this;
            toolBar.updateControls();
        }

        item.action = function () {
            if (!this.closeButtonAction) {
                if (!this.isSelected) {
                    this.select();
                    container.onAction();
                }
            };
            this.closeButtonAction = false;
        }

        item.remove = function () {
            innerContainer.removeChild(this);
            if (this == container.selectedItem) {
                container.selectedItem = null;
                var count = container.getCountItems();
                if (count > 0) {
                    innerContainer.childNodes[0].select();
                }
            }
            toolBar.updateControls();
            container.onAction();
        };

        item.getIndex = function () {
            for (var i = 0; i < innerContainer.childNodes.length; i++)
                if (innerContainer.childNodes[i] == this) return i;
        };

        item.move = function (direction) {
            var index = this.getIndex();
            innerContainer.removeChild(this);
            var count = container.getCountItems();
            var newIndex = direction == "Up" ? index - 1 : index + 1;
            if (direction == "Up" && newIndex == -1) newIndex = 0;
            if (direction == "Down" && newIndex >= count) {
                innerContainer.appendChild(this);
                toolBar.updateControls();
                container.onAction();
                return;
            }
            innerContainer.insertBefore(this, innerContainer.childNodes[newIndex]);
            toolBar.updateControls();
            container.onAction();
        }

        item.ontouchstart = function (event, mouseProcess) {
            var this_ = this;
            this.isTouchStartFlag = mouseProcess ? false : true;
            clearTimeout(this.isTouchStartTimer);

            if (event) event.preventDefault();
            this.action();

            if (event.button != 2) {
                var itemInDragObject = jsObject.TreeItemForDragDrop(this.itemObject, null, true);
                itemInDragObject.container = container;
                itemInDragObject.originalItem = this;
                itemInDragObject.beginingOffset = 0;
                jsObject.options.itemInDrag = itemInDragObject;
            }

            this.isTouchStartTimer = setTimeout(function () {
                this_.isTouchStartFlag = false;
            }, 1000);
        }

        //Mouse Down
        item.onmousedown = function (event) {
            if (this.isTouchStartFlag) return;
            this.ontouchstart(event, true);
        }

        return item;
    }

    container.getCountItems = function () {
        return innerContainer.childNodes.length;
    }

    container.getItemByName = function (name) {
        for (var i = 0; i < innerContainer.childNodes.length; i++) {
            if (innerContainer.childNodes[i].name == name) return innerContainer.childNodes[i];
        }
        return null;
    }

    container.getItemByIndex = function (index) {
        if (index < innerContainer.childNodes.length) return innerContainer.childNodes[index];
        return null;
    }

    container.getIndexCurrentOverItem = function () {
        for (var i = 0; i < innerContainer.childNodes.length; i++) {
            if (innerContainer.childNodes[i].isOver) return i;
        }
        return null;
    }

    //Events
    container.onmouseup = function () {
        if (jsObject.options.itemInDrag) {
            container.insertItem(jsObject.options.itemInDrag);
        }
    }
    container.ontouchend = function () {
        this.onmouseup();
    }

    container.insertItem = function (draggedItem) {
        if (draggedItem) {
            if (draggedItem.container == this) {
                var fromIndex = draggedItem.originalItem.getIndex();
                var toIndex = this.getIndexCurrentOverItem();

                if (fromIndex != null && toIndex != null && fromIndex != toIndex) {
                    var itemFrom = innerContainer.childNodes[fromIndex];
                    if (toIndex == innerContainer.childNodes.length - 1) {
                        innerContainer.appendChild(itemFrom);
                    }
                    else {
                        innerContainer.insertBefore(itemFrom, toIndex > fromIndex ? innerContainer.childNodes[toIndex].nextSibling : innerContainer.childNodes[toIndex]);
                    }
                    itemFrom.action();

                    var params = {
                        command: "ItemMoveToIndex",
                        fromIndex: fromIndex,
                        toIndex: itemFrom.getIndex(),
                        containerName: this.name
                    }
                    crossTabForm.sendCommand(params);
                }
            }
            else {
                var insertIndex = null;
                for (var i = 0; i < innerContainer.childNodes.length; i++) {
                    if (innerContainer.childNodes[i].isOver) {
                        if (i + 1 < innerContainer.childNodes.length) insertIndex = i + 1;
                        break;
                    }
                }

                var itemObject = draggedItem.itemObject;

                if (!draggedItem.container) {
                    itemObject = {
                        type: "ItemFromDataSourcesTree",
                        columnFullName: draggedItem.originalItem.getFullName(),
                        alias: draggedItem.itemObject.alias
                    }
                }

                var params = {
                    command: "InsertItemToContainer",
                    destinationContainerName: this.name,
                    destinationIndex: insertIndex,
                    itemObject: itemObject,
                    sourceContainerName: draggedItem.container ? draggedItem.container.name : "datasources"
                }

                if (draggedItem.container) {
                    params.sourceIndex = draggedItem.originalItem.getIndex();
                    draggedItem.originalItem.remove();
                }

                var newItem = container.addItem(itemObject, null, insertIndex);
                newItem.select();
                container.onAction();
                crossTabForm.sendCommand(params);
            }
        }
    }

    container.setNotActive = function () {
        if (this.selectedItem) this.selectedItem.setSelected(false);
        this.selectedItem = null;
        moveUpButton.setEnabled(false);
        moveDownButton.setEnabled(false);
        removeButton.setEnabled(false);
    }

    container.fill = function (itemObjects) {
        this.clear();
        for (var i = 0; i < itemObjects.length; i++) {
            this.addItem(itemObjects[i]);
        }
    }

    return container;
}

StiMobileDesigner.prototype.CrossTabSelectDataPanel = function () {
    var table = this.CreateHTMLTable();
    table.style.position = "absolute";
    table.style.left = "12px";
    table.style.top = "25px";
    table.style.display = "none";

    var img = document.createElement("img");
    img.style.margin = "1px 4px 0 0";
    StiMobileDesigner.setImageSource(img, this.options, "Arrows.MoveLeftGray.png");
    table.addCell(img);

    table.addCell(this.CrossTabContainerHeader(this.loc.Wizards.infoDataSource));

    return table;
}

StiMobileDesigner.prototype.CreateCrossTabResultPage = function () {
    return (("createElementNS" in document) ? document.createElementNS("http://www.w3.org/2000/svg", "svg") : document.createElement("svg"));
}

//Styles Container
StiMobileDesigner.prototype.CrossTabStylesContainer = function () {
    var stylesContainer = this.ContainerWithBigItems("crossTabFormStylesContainer", 200, this.options.isTouchDevice ? 462 : 467, 80);
    stylesContainer.className = "stiDesignerSeriesContainer";
    stylesContainer.buttons = {};

    return stylesContainer;
}